/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;

public abstract class FilterDialog
extends Dialog {
    private static final int DEFAULT_NUM_COLUMNS = 5;
    private Map<String, Button> typeFieldsUmsetzung;
    private Map<String, Button> typeFieldsSiegel;
    private Map<String, Button> typeFieldsSchicht;
    private Set<String> selectedUmsetzungTypes = new HashSet<String>();
    private Set<String> selectedSiegelTypes = new HashSet<String>();
    private Set<String> selectedSchichtTypes = new HashSet<String>();

    public FilterDialog(Shell parent, String[] umsetzung, String[] siegel, String[] schicht) {
        super(parent);
        String type;
        int n;
        int n2;
        String[] stringArray;
        if (umsetzung != null) {
            stringArray = umsetzung;
            n2 = umsetzung.length;
            n = 0;
            while (n < n2) {
                type = stringArray[n];
                this.selectedUmsetzungTypes.add(type);
                ++n;
            }
        }
        if (siegel != null) {
            stringArray = siegel;
            n2 = siegel.length;
            n = 0;
            while (n < n2) {
                type = stringArray[n];
                this.selectedSiegelTypes.add(type);
                ++n;
            }
        }
        if (schicht != null) {
            stringArray = schicht;
            n2 = schicht.length;
            n = 0;
            while (n < n2) {
                type = stringArray[n];
                this.selectedSchichtTypes.add(type);
                ++n;
            }
        }
    }

    public String[] getUmsetzungSelection() {
        return this.selectedUmsetzungTypes.toArray(new String[this.selectedUmsetzungTypes.size()]);
    }

    public String[] getSiegelSelection() {
        return this.selectedSiegelTypes.toArray(new String[this.selectedSiegelTypes.size()]);
    }

    public String[] getSchichtSelection() {
        return this.selectedSchichtTypes.toArray(new String[this.selectedSchichtTypes.size()]);
    }

    protected void createUmsetzungCheckboxes(Composite parent) {
        this.typeFieldsUmsetzung = new HashMap<String, Button>();
        String[] umsetzungStati = MassnahmenUmsetzung.getUmsetzungStati();
        PropertyType propertyType = HUITypeFactory.getInstance().getEntityType("mnums").getPropertyType("mnums_umsetzung");
        String[] stringArray = umsetzungStati;
        int n = umsetzungStati.length;
        int n2 = 0;
        while (n2 < n) {
            final String status = stringArray[n2];
            final Button button = new Button(parent, 32);
            if (status.equals("mnums_umsetzung_unbearbeitet")) {
                button.setText(Messages.FilterDialog_0);
            } else {
                button.setText(propertyType.getOption(status).getName());
            }
            this.typeFieldsUmsetzung.put(status, button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (button.getSelection()) {
                        FilterDialog.this.selectedUmsetzungTypes.add(status);
                    } else {
                        FilterDialog.this.selectedUmsetzungTypes.remove(status);
                    }
                }
            });
            ++n2;
        }
    }

    protected void createSiegelCheckboxes(Composite parent) {
        String[] siegelStufen;
        this.typeFieldsSiegel = new HashMap<String, Button>();
        String[] stringArray = siegelStufen = MassnahmenUmsetzung.getStufen();
        int n = siegelStufen.length;
        int n2 = 0;
        while (n2 < n) {
            final String stufe = stringArray[n2];
            final Button button = new Button(parent, 32);
            button.setText(stufe);
            this.typeFieldsSiegel.put(stufe, button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (button.getSelection()) {
                        FilterDialog.this.selectedSiegelTypes.add(stufe);
                    } else {
                        FilterDialog.this.selectedSiegelTypes.remove(stufe);
                    }
                }
            });
            ++n2;
        }
    }

    protected void createSchichtCheckboxes(Composite parent) {
        this.typeFieldsSchicht = new HashMap<String, Button>();
        String[] schichten = BausteinUmsetzung.getSchichten();
        String[] bezeichnung = BausteinUmsetzung.getSchichtenBezeichnung();
        int i = 0;
        String[] stringArray = schichten;
        int n = schichten.length;
        int n2 = 0;
        while (n2 < n) {
            final String schicht = stringArray[n2];
            final Button button = new Button(parent, 32);
            button.setText(bezeichnung[i++]);
            this.typeFieldsSchicht.put(schicht, button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (button.getSelection()) {
                        FilterDialog.this.selectedSchichtTypes.add(schicht);
                    } else {
                        FilterDialog.this.selectedSchichtTypes.remove(schicht);
                    }
                }
            });
            ++n2;
        }
    }

    protected void initContent() {
        Button button;
        int n;
        int n2;
        String[] stringArray;
        if (this.typeFieldsUmsetzung != null) {
            String[] umsetzungStati;
            stringArray = umsetzungStati = MassnahmenUmsetzung.getUmsetzungStati();
            n2 = umsetzungStati.length;
            n = 0;
            while (n < n2) {
                String umsetzung = stringArray[n];
                button = this.typeFieldsUmsetzung.get(umsetzung);
                button.setSelection(this.selectedUmsetzungTypes.contains(umsetzung));
                ++n;
            }
        }
        if (this.typeFieldsSiegel != null) {
            String[] siegelStati = MassnahmenUmsetzung.getStufen();
            stringArray = siegelStati;
            n2 = siegelStati.length;
            n = 0;
            while (n < n2) {
                String stufe = stringArray[n];
                button = this.typeFieldsSiegel.get(stufe);
                button.setSelection(this.selectedSiegelTypes.contains(stufe));
                ++n;
            }
        }
        if (this.typeFieldsSchicht != null) {
            String[] schichten = BausteinUmsetzung.getSchichten();
            stringArray = schichten;
            n2 = schichten.length;
            n = 0;
            while (n < n2) {
                String schicht = stringArray[n];
                button = this.typeFieldsSchicht.get(schicht);
                button.setSelection(this.selectedSchichtTypes.contains(schicht));
                ++n;
            }
        }
    }

    protected Group createSiegelGroup(Composite parent) {
        int numColumns = 4;
        Group boxesComposite2 = new Group(parent, 2048);
        boxesComposite2.setText(Messages.FilterDialog_1);
        GridData gridData2 = new GridData(4, 2, true, false, 2, 1);
        boxesComposite2.setLayoutData((Object)gridData2);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 4;
        boxesComposite2.setLayout((Layout)layout3);
        return boxesComposite2;
    }

    protected Group createUmsetzungGroup(Composite parent) {
        Group boxesComposite = new Group(parent, 2048);
        boxesComposite.setText(Messages.FilterDialog_2);
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        boxesComposite.setLayout((Layout)layout2);
        return boxesComposite;
    }

    protected Group createSchichtenGroup(Composite parent) {
        Group boxesComposite = new Group(parent, 2048);
        boxesComposite.setText(Messages.FilterDialog_3);
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        boxesComposite.setLayout((Layout)layout2);
        return boxesComposite;
    }
}

