/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.ElementSelectionComponent;

public class CnATreeElementSelectionDialog
extends Dialog {
    private String entityType;
    private CnATreeElement inputElmt;
    private ElementSelectionComponent selectionComponent;
    private boolean scopeOnly = true;
    private boolean showScopeCheckbox = true;
    private boolean includeCompendiumElements;
    private boolean showContainingObject;

    public CnATreeElementSelectionDialog(Shell shell, String selectedType, CnATreeElement inputElmt) {
        this(shell, selectedType, inputElmt, true);
    }

    public CnATreeElementSelectionDialog(String referencedEntityType, CnATreeElement inputElmt2) {
        this(Display.getCurrent().getActiveShell(), referencedEntityType, inputElmt2);
    }

    public CnATreeElementSelectionDialog(Shell shell, String selectedType, CnATreeElement inputElmt, boolean includeCompendiumElements) {
        this(shell, selectedType, inputElmt, includeCompendiumElements, false);
    }

    public CnATreeElementSelectionDialog(Shell shell, String selectedType, CnATreeElement inputElmt, boolean includeCompendiumElements, boolean showContainingObject) {
        super(shell);
        this.includeCompendiumElements = includeCompendiumElements;
        this.showContainingObject = showContainingObject;
        int style = 1120;
        style = style | 0x800 | 0x10000;
        this.setShellStyle(style | 0x10);
        this.entityType = selectedType;
        this.inputElmt = inputElmt;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellWidth = this.showContainingObject ? 650 : 400;
        int shellHeight = 500;
        int cursorLocationXSubtrahend = 200;
        int cursorLocationYSubtrahend = 250;
        newShell.setText(Messages.CnATreeElementSelectionDialog_2);
        newShell.setSize(shellWidth, 500);
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        newShell.setLocation(new Point(cursorLocation.x - 200, cursorLocation.y - 250));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Integer scopeId = null;
        if (this.inputElmt != null) {
            scopeId = this.inputElmt.getScopeId();
        }
        this.selectionComponent = new ElementSelectionComponent(container, this.entityType, scopeId);
        this.selectionComponent.setScopeOnly(this.scopeOnly);
        this.selectionComponent.setShowScopeCheckbox(this.showScopeCheckbox);
        this.selectionComponent.setIncludeCompendiumElements(this.includeCompendiumElements);
        this.selectionComponent.setShowContainingObject(this.showContainingObject);
        this.selectionComponent.init();
        this.selectionComponent.loadElements();
        this.selectionComponent.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CnATreeElementSelectionDialog.this.close();
            }
        });
        return this.selectionComponent.getContainer();
    }

    public List<CnATreeElement> getSelectedElements() {
        return this.selectionComponent.getSelectedElements();
    }

    public void setScopeOnly(boolean scopeOnly) {
        this.scopeOnly = scopeOnly;
        if (this.selectionComponent != null) {
            this.selectionComponent.setScopeOnly(scopeOnly);
        }
    }

    public void setShowScopeCheckbox(boolean showScopeCheckbox) {
        this.showScopeCheckbox = showScopeCheckbox;
        if (this.selectionComponent != null) {
            this.selectionComponent.setShowScopeCheckbox(showScopeCheckbox);
        }
    }
}

