/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.InputHelperFactory;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.EntityType;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.hui.swt.widgets.IHuiControlFactory;
import sernet.snutils.DBException;
import sernet.verinice.rcp.Preferences;

public class BulkEditDialog
extends Dialog {
    private static final Logger logger = Logger.getLogger(BulkEditDialog.class);
    private EntityType entType;
    private Entity entity = null;
    private boolean useRules = false;
    private String title = Messages.BulkEditDialog_0;
    private final Map<String, IHuiControlFactory> overrides;

    public BulkEditDialog(Shell parent, EntityType entType, Map<String, IHuiControlFactory> overrides) {
        super(parent);
        this.overrides = overrides;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.entType = entType;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellWidth = 440;
        int shellHeight = 800;
        int shellLocationXSubtrahend = 200;
        int shellLocationYSubtrahend = 400;
        newShell.setText(this.title);
        newShell.setSize(440, 800);
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        newShell.setLocation(new Point(cursorLocation.x - 200, cursorLocation.y - 400));
    }

    protected Control createDialogArea(Composite parent) {
        try {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new FillLayout());
            HitroUIComposite huiComposite = new HitroUIComposite(container, false);
            try {
                if (this.entity == null) {
                    this.entity = new Entity(this.entType.getId());
                }
                String[] tags = Preferences.getEditorTags();
                boolean strict = Activator.getDefault().getPluginPreferences().getBoolean("hui_tags_strict");
                huiComposite.createView(this.entity, true, this.useRules, tags, strict, new ArrayList(0), Activator.getDefault().getPreferenceStore().getBoolean("use_validation_gui_hints"), this.overrides);
                InputHelperFactory.setInputHelpers(this.entType, huiComposite);
                return huiComposite;
            }
            catch (DBException e) {
                ExceptionUtil.log(e, Messages.BulkEditDialog_1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error creating BulkeditDialog", (Throwable)e);
        }
        return null;
    }

    public Entity getEntity() {
        return this.entity;
    }
}

