/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dialogs.FilterDialog;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.gs.ui.rcp.main.bsi.filter.TagFilter;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;

public class BSIModelFilterDialog
extends FilterDialog {
    private String lebenszyklus = "";
    private Combo combo;
    private Set<Class<?>> filteredClasses;
    private Combo comboObjektLZ;
    private String objektLebenszyklus = "";
    private CheckboxTableViewer viewer;
    private String[] tagPattern;
    private Group tagGroup;
    private Button filterItVerbundCheckbox;
    private boolean filterItVerbund;
    private static Map<String, Class<?>> possibleFilters = new HashMap();
    private static final String[] LZ_ITEMS;
    private static final String[] LZ_ZIELOBJEKTE_ITEMS;
    private String[] checkedElements;

    static {
        possibleFilters.put(Messages.BSIModelFilterDialog_2, BausteinUmsetzung.class);
        possibleFilters.put(Messages.BSIModelFilterDialog_3, MassnahmenUmsetzung.class);
        LZ_ITEMS = new String[]{Messages.BSIModelFilterDialog_4, Messages.BSIModelFilterDialog_5, Messages.BSIModelFilterDialog_6, Messages.BSIModelFilterDialog_7, Messages.BSIModelFilterDialog_8, Messages.BSIModelFilterDialog_9, Messages.BSIModelFilterDialog_10};
        LZ_ZIELOBJEKTE_ITEMS = new String[]{Messages.BSIModelFilterDialog_11, Messages.BSIModelFilterDialog_12, Messages.BSIModelFilterDialog_13, Messages.BSIModelFilterDialog_14, Messages.BSIModelFilterDialog_15, Messages.BSIModelFilterDialog_16, Messages.BSIModelFilterDialog_17, Messages.BSIModelFilterDialog_18, Messages.BSIModelFilterDialog_19, Messages.BSIModelFilterDialog_20};
    }

    public BSIModelFilterDialog(Shell parent, String[] umsetzung, String[] siegel, String lebenszyklus, String objektLebenszyklus, Set<Class<?>> filteredClasses, String[] tags, boolean filterItVerbund) {
        super(parent, umsetzung, siegel, null);
        int style = 2144;
        style = style | 0x10000 | 0x10;
        this.setShellStyle(style);
        this.lebenszyklus = lebenszyklus;
        this.objektLebenszyklus = objektLebenszyklus;
        this.filteredClasses = filteredClasses;
        if (this.filteredClasses == null) {
            this.filteredClasses = new HashSet();
        }
        this.tagPattern = tags != null ? (String[])tags.clone() : null;
        this.filterItVerbund = filterItVerbund;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label intro = new Label(container, 0);
        intro.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        intro.setText(Messages.BSIModelFilterDialog_21);
        Group boxesComposite = this.createUmsetzungGroup(container);
        Group boxesComposite2 = this.createSiegelGroup(container);
        this.createLebenszyklusDropDown(container);
        this.createObjektLebenszyklusDropDown(container);
        this.createUmsetzungCheckboxes((Composite)boxesComposite);
        this.createSiegelCheckboxes((Composite)boxesComposite2);
        Group group = this.createAusblendenGroup(container);
        this.createAusblendenCheckboxes(group);
        this.tagGroup = this.createTagfilterGroup(container);
        this.initContent();
        container.layout();
        return container;
    }

    private Group createTagfilterGroup(Composite parent) {
        int scrolledCompositeWidth = 100;
        int scrolledCompositeHeight = 100;
        int checkboxColumnWidth = 35;
        int imageColumnWidth = 100;
        Group groupComposite = new Group(parent, 2048);
        groupComposite.setText(Messages.BSIModelFilterDialog_22);
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        this.filterItVerbundCheckbox = new Button((Composite)groupComposite, 32);
        this.filterItVerbundCheckbox.setText(Messages.BSIModelFilterDialog_0);
        ScrolledComposite comp = new ScrolledComposite((Composite)groupComposite, 512);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setExpandHorizontal(true);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)comp, (int)2048);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        comp.setContent(this.viewer.getControl());
        comp.setMinSize(100, 100);
        TableColumn checkboxColumn = new TableColumn(table, 16384);
        checkboxColumn.setText("");
        checkboxColumn.setWidth(35);
        TableColumn imageColumn = new TableColumn(table, 16384);
        imageColumn.setText(Messages.BSIModelFilterDialog_24);
        imageColumn.setWidth(100);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    return (String)element;
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        return groupComposite;
    }

    public String[] getCheckedElements() {
        return this.checkedElements != null ? (String[])this.checkedElements.clone() : null;
    }

    private Group createAusblendenGroup(Composite parent) {
        Group boxesComposite = new Group(parent, 2048);
        boxesComposite.setText(Messages.BSIModelFilterDialog_25);
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        boxesComposite.setLayout((Layout)layout2);
        return boxesComposite;
    }

    private boolean getFilterSelectionForButton(Button b) {
        return this.filteredClasses.contains(possibleFilters.get(b.getText()));
    }

    private void createAusblendenCheckboxes(Group parent) {
        Button button1 = new Button((Composite)parent, 32);
        button1.setText(Messages.BSIModelFilterDialog_26);
        button1.setSelection(this.getFilterSelectionForButton(button1));
        button1.addSelectionListener((SelectionListener)new SelectionHelper(button1));
        Button button2 = new Button((Composite)parent, 32);
        button2.setText(Messages.BSIModelFilterDialog_27);
        button2.setSelection(this.getFilterSelectionForButton(button2));
        button2.addSelectionListener((SelectionListener)new SelectionHelper(button2));
    }

    private void createLebenszyklusDropDown(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.BSIModelFilterDialog_28);
        label.pack();
        this.combo = new Combo(container, 0);
        this.combo.setItems(LZ_ITEMS);
        this.combo.setText(this.lebenszyklus == null ? "" : this.lebenszyklus);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BSIModelFilterDialog.this.setLZ();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createObjektLebenszyklusDropDown(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.BSIModelFilterDialog_30);
        label.pack();
        this.comboObjektLZ = new Combo(container, 0);
        this.comboObjektLZ.setItems(LZ_ZIELOBJEKTE_ITEMS);
        this.comboObjektLZ.setText(this.objektLebenszyklus == null ? "" : this.objektLebenszyklus);
        this.comboObjektLZ.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BSIModelFilterDialog.this.setObjektLZ();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setLZ() {
        this.lebenszyklus = this.combo.getSelectionIndex() == 0 ? "" : LZ_ITEMS[this.combo.getSelectionIndex()];
    }

    private void setObjektLZ() {
        this.objektLebenszyklus = this.comboObjektLZ.getSelectionIndex() == 0 ? "" : LZ_ZIELOBJEKTE_ITEMS[this.comboObjektLZ.getSelectionIndex()];
    }

    public String getLebenszyklus() {
        return this.lebenszyklus;
    }

    @Override
    protected void initContent() {
        super.initContent();
        int viewerTableWidth = 200;
        int viewerTableHeight = 200;
        if (CnAElementFactory.isModelLoaded()) {
            try {
                List<String> tags = CnAElementHome.getInstance().getTags();
                tags.add(0, TagFilter.NO_TAG);
                this.viewer.setInput(tags);
            }
            catch (CommandException e) {
                ExceptionUtil.log(e, Messages.BSIModelFilterDialog_34);
            }
            this.viewer.getTable().setSize(200, 200);
            if (this.tagPattern != null) {
                this.viewer.setCheckedElements((Object[])this.tagPattern);
            }
            this.tagGroup.getParent().layout(true);
            this.filterItVerbundCheckbox.setSelection(this.isFilterItVerbund());
        }
    }

    public boolean close() {
        List<Object> tagList = Arrays.asList(this.viewer.getCheckedElements());
        this.checkedElements = tagList.toArray(new String[tagList.size()]);
        this.setFilterItVerbund(this.filterItVerbundCheckbox.getSelection());
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellWidth = 400;
        int shellHeight = 500;
        newShell.setText(Messages.BSIModelFilterDialog_35);
        newShell.setSize(400, 500);
    }

    public Set<Class<?>> getFilteredClasses() {
        return this.filteredClasses;
    }

    public String getObjektLebenszyklus() {
        return this.objektLebenszyklus;
    }

    public boolean isFilterItVerbund() {
        return this.filterItVerbund;
    }

    public void setFilterItVerbund(boolean filterItVerbund) {
        this.filterItVerbund = filterItVerbund;
    }

    private class SelectionHelper
    extends SelectionAdapter {
        private Button b;

        SelectionHelper(Button b) {
            this.b = b;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.b.getSelection()) {
                BSIModelFilterDialog.this.filteredClasses.add(possibleFilters.get(this.b.getText()));
            } else {
                BSIModelFilterDialog.this.filteredClasses.remove(possibleFilters.get(this.b.getText()));
            }
        }
    }
}

