/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.text.Collator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dialogs.EditBausteinVorgabeDialog;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.ITypedElement;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.BausteinVorschlag;
import sernet.verinice.service.commands.LoadGenericElementByType;
import sernet.verinice.service.commands.SaveElement;
import sernet.verinice.service.commands.crud.RemoveGenericElement;

public class AutoBausteinDialog
extends Dialog {
    private BausteinVorschlag selectedSubtype;
    private ListViewer viewer;
    private List<BausteinVorschlag> elements;

    public AutoBausteinDialog(Shell shell) {
        super(shell);
        int style = 2144;
        style = style | 0x10000 | 0x10;
        this.setShellStyle(style);
    }

    protected void createListGroup(Composite parent) {
        int scrolledCompWidth = 100;
        int scrolledCompHeight = 100;
        Group groupComposite = new Group(parent, 2048);
        groupComposite.setText(Messages.AutoBausteinDialog_0);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite comp = new ScrolledComposite((Composite)groupComposite, 512);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setExpandHorizontal(true);
        this.viewer = new ListViewer((Composite)comp, 32);
        comp.setContent(this.viewer.getControl());
        comp.setMinSize(100, 100);
        LoadGenericElementByType command = new LoadGenericElementByType(BausteinVorschlag.class);
        try {
            command = (LoadGenericElementByType)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.AutoBausteinDialog_1);
        }
        this.elements = command.getElements();
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                BausteinVorschlag vorschlag = (BausteinVorschlag)element;
                return vorschlag.getName();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                BausteinVorschlag bst1 = (BausteinVorschlag)e1;
                BausteinVorschlag bst2 = (BausteinVorschlag)e2;
                return Collator.getInstance().compare(bst1.getName(), bst2.getName());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.elements);
        this.viewer.getList().pack();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)AutoBausteinDialog.this.viewer.getSelection();
                if (sel.size() == 1) {
                    AutoBausteinDialog.this.selectedSubtype = (BausteinVorschlag)sel.getFirstElement();
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)AutoBausteinDialog.this.viewer.getSelection();
                if (sel.size() == 1) {
                    AutoBausteinDialog.this.selectedSubtype = (BausteinVorschlag)sel.getFirstElement();
                }
                AutoBausteinDialog.this.close();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createListGroup(container);
        this.createButtonGroup(container);
        return container;
    }

    private void createButtonGroup(Composite parent) {
        Group container = new Group(parent, 2048);
        container.setText(Messages.AutoBausteinDialog_2);
        GridData gridData = new GridData(1808);
        container.setLayoutData((Object)gridData);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        container.setLayout((Layout)layout2);
        Button buttonNew = new Button((Composite)container, 8);
        buttonNew.setText(Messages.AutoBausteinDialog_3);
        GridData gridNew = new GridData(768);
        buttonNew.setLayoutData((Object)gridNew);
        buttonNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BausteinVorschlag neuerVorschlag = new BausteinVorschlag(Messages.AutoBausteinDialog_4, "");
                if ((neuerVorschlag = AutoBausteinDialog.this.showEditDialog(neuerVorschlag)) != null) {
                    AutoBausteinDialog.this.elements.add(neuerVorschlag);
                    AutoBausteinDialog.this.viewer.add((Object)neuerVorschlag);
                }
            }
        });
        Button buttonEdit = new Button((Composite)container, 8);
        buttonEdit.setText(Messages.AutoBausteinDialog_6);
        GridData grid2 = new GridData(768);
        buttonEdit.setLayoutData((Object)grid2);
        buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AutoBausteinDialog.this.viewer.getSelection().isEmpty()) {
                    Object selection = ((IStructuredSelection)AutoBausteinDialog.this.viewer.getSelection()).getFirstElement();
                    BausteinVorschlag vorschlag = (BausteinVorschlag)selection;
                    if ((vorschlag = AutoBausteinDialog.this.showEditDialog(vorschlag)) != null) {
                        AutoBausteinDialog.this.viewer.refresh((Object)vorschlag);
                    }
                }
            }
        });
        Button buttonDel = new Button((Composite)container, 8);
        buttonDel.setText(Messages.AutoBausteinDialog_7);
        GridData grid3 = new GridData(768);
        buttonDel.setLayoutData((Object)grid3);
        buttonDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel;
                if (MessageDialog.openConfirm((Shell)AutoBausteinDialog.this.getParentShell(), (String)Messages.AutoBausteinDialog_8, (String)Messages.AutoBausteinDialog_9) && (sel = (IStructuredSelection)AutoBausteinDialog.this.viewer.getSelection()).size() == 1) {
                    BausteinVorschlag selection = (BausteinVorschlag)sel.getFirstElement();
                    RemoveGenericElement command = new RemoveGenericElement((ITypedElement)selection);
                    try {
                        ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        AutoBausteinDialog.this.selectedSubtype = null;
                        AutoBausteinDialog.this.elements.remove(selection);
                        AutoBausteinDialog.this.viewer.remove((Object)selection);
                    }
                    catch (CommandException e1) {
                        ExceptionUtil.log(e1, Messages.AutoBausteinDialog_10);
                    }
                }
            }
        });
    }

    protected BausteinVorschlag showEditDialog(BausteinVorschlag vorschlag) {
        EditBausteinVorgabeDialog dialog = new EditBausteinVorgabeDialog(this.getShell(), vorschlag);
        int okay = dialog.open();
        if (okay == 0) {
            vorschlag.setName(dialog.getName());
            vorschlag.setBausteine(dialog.getBausteine());
            SaveElement command = new SaveElement((ITypedElement)vorschlag);
            try {
                command = (SaveElement)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                return (BausteinVorschlag)command.getElement();
            }
            catch (CommandException e1) {
                ExceptionUtil.log(e1, Messages.AutoBausteinDialog_11);
            }
        }
        return null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellWidth = 640;
        int shellHeight = 480;
        newShell.setText(Messages.AutoBausteinDialog_12);
        newShell.setSize(640, 480);
    }

    public BausteinVorschlag getSelectedSubtype() {
        return this.selectedSubtype;
    }
}

