/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Permission;
import sernet.verinice.rcp.ImageColumnProvider;
import sernet.verinice.service.account.AccountLoader;
import sernet.verinice.service.commands.crud.LoadPermissions;

public class AccessControlEditDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(AccessControlEditDialog.class);
    private static final int MARGIN_WIDTH_DEFAULT = 10;
    private static final int MARGIN_HEIGHT_DEFAULT = 10;
    private static final int COLSPAN_DEFAULT = 5;
    private List<CnATreeElement> elements = new ArrayList<CnATreeElement>();
    private Set<Permission> permissionSet;
    private Set<Permission> permissionSetAdd;
    private Set<Permission> permissionSetRemove;
    private String[] roleArray;
    private boolean isOverride;
    private boolean isUpdateChildren;
    private TableViewer viewer;
    private Text filter;
    private Combo comboRole;
    private Button buttonRead;
    private Button buttonWrite;
    private Button buttonInherit;
    private Button buttonAdd;
    private Button[] radioButtonMode = new Button[2];
    SelectionListener removeListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            try {
                AccessControlEditDialog.this.removePermission();
            }
            catch (Exception e1) {
                LOG.error((Object)"Error while removing permission.", (Throwable)e1);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    SelectionListener radioListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            AccessControlEditDialog.this.isOverride = AccessControlEditDialog.this.radioButtonMode[1].getSelection();
            AccessControlEditDialog.this.showInformation();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public AccessControlEditDialog(Shell parent, IStructuredSelection selection) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        for (Object next : selection) {
            if (!(next instanceof CnATreeElement)) continue;
            CnATreeElement nextElement = (CnATreeElement)next;
            this.elements.add(nextElement);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AccessControlEditDialog_6);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AccessControlEditDialog_6);
        Composite composite = this.createComposite(parent);
        this.createSettingsComposite(composite);
        this.createRolesComposite(composite);
        return composite;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layoutRoot = (GridLayout)composite.getLayout();
        layoutRoot.marginWidth = 10;
        layoutRoot.marginHeight = 10;
        GridData gd = this.generateGridData(512, Boolean.TRUE, Boolean.TRUE, 4, 4, null);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    private Composite createSettingsComposite(Composite composite) {
        Composite containerSettings = new Composite(composite, 0);
        GridLayout layoutSettings = this.generateGridLayout(2, false, 10, 10);
        containerSettings.setLayout((Layout)layoutSettings);
        GridData gridData = this.generateGridData(null, null, null, null, null, 5);
        containerSettings.setLayoutData((Object)gridData);
        this.radioButtonMode[0] = this.generateButton(containerSettings, 16, Messages.AccessControlEditDialog_9, Boolean.TRUE, this.radioListener);
        this.radioButtonMode[1] = this.generateButton(containerSettings, 16, Messages.AccessControlEditDialog_10, null, this.radioListener);
        this.showInformation();
        this.buttonInherit = this.generateButton(containerSettings, 32, Messages.AccessControlEditDialog_11, Boolean.FALSE, null);
        gridData = this.generateGridData(null, Boolean.TRUE, null, 4, null, null);
        this.buttonInherit.setLayoutData((Object)gridData);
        return containerSettings;
    }

    private Composite createRolesComposite(Composite composite) {
        Composite containerRoles = new Composite(composite, 0);
        GridLayout layout = this.generateGridLayout(5, false, 10, 10);
        containerRoles.setLayout((Layout)layout);
        GridData gd2 = this.generateGridData(512, Boolean.TRUE, Boolean.TRUE, 4, 4, null);
        containerRoles.setLayoutData((Object)gd2);
        Label labelFilter = new Label(containerRoles, 0);
        labelFilter.setText("Filter");
        Label labelRole = new Label(containerRoles, 0);
        labelRole.setText(Messages.AccessControlEditDialog_12);
        labelRole.setLayoutData((Object)this.generateGridData(0, true, false, 4, 2, 4));
        this.createFilter(containerRoles);
        this.comboRole = new Combo(containerRoles, 12);
        this.comboRole.setItems(this.getRoles());
        this.comboRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = AccessControlEditDialog.this.comboRole.getText();
                AccessControlEditDialog.this.syncTable(AccessControlEditDialog.this.comboRole.getText());
                AccessControlEditDialog.this.switchButtons(text != null && !text.trim().isEmpty());
            }
        });
        this.buttonRead = this.generateButton(containerRoles, 32, Messages.AccessControlEditDialog_13, Boolean.FALSE, null);
        this.buttonWrite = this.generateButton(containerRoles, 32, Messages.AccessControlEditDialog_14, Boolean.FALSE, null);
        this.buttonRead.setEnabled(false);
        this.buttonWrite.setEnabled(false);
        SelectionListener addListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AccessControlEditDialog.this.addPermission();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.buttonAdd = this.generateButton(containerRoles, 8, Messages.AccessControlEditDialog_15, null, addListener);
        this.buttonAdd.setEnabled(false);
        GridData gridData = this.generateGridData(null, Boolean.TRUE, null, 131072, null, null);
        this.buttonAdd.setLayoutData((Object)gridData);
        this.createViewer(containerRoles);
        Button buttonRemove = this.generateButton(containerRoles, 8, Messages.AccessControlEditDialog_16, null, this.removeListener);
        gridData = this.generateGridData(null, null, null, 131072, null, 5);
        buttonRemove.setLayoutData((Object)gridData);
        return containerRoles;
    }

    private void createFilter(Composite containerRoles) {
        this.filter = new Text(containerRoles, 2048);
        this.filter.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                AccessControlEditDialog.this.filterRoleCombo();
                AccessControlEditDialog.this.switchButtons(AccessControlEditDialog.this.comboRole.getText() != null && !AccessControlEditDialog.this.comboRole.getText().isEmpty());
            }
        });
        this.filter.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                AccessControlEditDialog.this.filterFocusLost();
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void filterFocusLost() {
        String comboText;
        String filterText = this.filter.getText();
        if (filterText == null || filterText.isEmpty()) {
            Object firstElement;
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            String tableText = "";
            if (selection != null && selection.size() > 0 && (firstElement = selection.getFirstElement()) != null) {
                tableText = ((Permission)firstElement).getRole();
            }
            this.comboRole.setItems(this.getRoles());
            if (!"".equals(tableText) && ArrayUtils.contains((Object[])this.getRoles(), (Object)tableText)) {
                this.syncCombo(tableText);
            }
        }
        this.switchButtons((comboText = this.comboRole.getText()) != null && !comboText.isEmpty());
    }

    private void switchButtons(boolean enabled) {
        this.buttonRead.setEnabled(enabled);
        this.buttonWrite.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
    }

    private TableViewer createViewer(Composite parent) {
        int gridDataHorizontalSpan = 5;
        int style = 770;
        style = style | 0x10000 | 0x800;
        this.viewer = new TableViewer(parent, style);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        CnATreeElement firstElement = this.elements.get(0);
        this.loadPermission(firstElement);
        this.refreshTable();
        GridData gridData = this.generateGridData(0, true, true, 4, 4, 5);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.addSelectionChangedListener(event -> {
            Set<Permission> selectedPermissions = this.getSelectedPermissions();
            if (!selectedPermissions.isEmpty()) {
                this.syncComboAndCheckboxes(selectedPermissions.iterator().next());
            }
        });
        return this.viewer;
    }

    private void createColumns() {
        String[] titles = new String[]{Messages.AccessControlEditDialog_20, Messages.AccessControlEditDialog_21, Messages.AccessControlEditDialog_22};
        int[] bounds = new int[]{170, 50, 50};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Permission)element).getRole();
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1]);
        col.setLabelProvider((CellLabelProvider)new ImageColumnProvider(){

            @Override
            public Image getImage(Object element) {
                return AccessControlEditDialog.this.getYesNoImage(((Permission)element).isReadAllowed(), true);
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2]);
        col.setLabelProvider((CellLabelProvider)new ImageColumnProvider(){

            @Override
            public Image getImage(Object element) {
                return AccessControlEditDialog.this.getYesNoImage(((Permission)element).isWriteAllowed(), true);
            }
        });
    }

    private void filterRoleCombo() {
        String filterText = this.filter.getText();
        String selected = this.comboRole.getText();
        String[] allRoles = this.getRoles();
        ArrayList<String> roles = new ArrayList<String>(allRoles.length);
        String[] stringArray = allRoles;
        int n = allRoles.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (role.toLowerCase().contains(filterText.toLowerCase())) {
                roles.add(role);
            }
            ++n2;
        }
        this.comboRole.setItems(roles.toArray(new String[roles.size()]));
        this.selectCombo(selected);
        if (this.comboRole.getItems().length == 1) {
            this.comboRole.select(0);
        }
        if ((selected = this.comboRole.getText()) != null) {
            this.syncTable(selected);
        }
    }

    protected void syncTable(String role) {
        int i = 0;
        Permission p = (Permission)this.viewer.getElementAt(i);
        while (p != null) {
            if (p.getRole().equals(role)) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)p), true);
            }
            p = (Permission)this.viewer.getElementAt(++i);
        }
    }

    private void syncCombo(String tableRole) {
        int i = 0;
        try {
            String cRole = this.comboRole.getItem(i);
            while (cRole != null) {
                if (cRole.equals(tableRole)) {
                    this.comboRole.select(i);
                    break;
                }
                cRole = this.comboRole.getItem(++i);
            }
        }
        catch (IllegalArgumentException cRole) {
            // empty catch block
        }
        String selection = this.comboRole.getText();
        this.switchButtons(selection != null && !selection.isEmpty());
    }

    protected void syncComboAndCheckboxes(Permission permission) {
        this.setPermissionInCombo(permission);
        this.setPermissionInCheckboxes(permission);
    }

    protected void setPermissionInCombo(Permission permission) {
        String role = permission.getRole();
        this.selectCombo(role);
    }

    private void selectCombo(String role) {
        String[] items = this.comboRole.getItems();
        boolean set = false;
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(role)) {
                this.comboRole.select(i);
                set = true;
            }
            ++i;
        }
        if (!set) {
            ArrayList<String> list = new ArrayList<String>(0);
            list.add("");
            list.addAll(this.removeEmptyEntries(Arrays.asList(this.comboRole.getItems())));
            this.comboRole.setItems(list.toArray(new String[list.size()]));
            this.comboRole.select(0);
        }
    }

    private List<String> removeEmptyEntries(List<String> list) {
        ArrayList<String> filteredList = new ArrayList<String>(0);
        for (String s : list) {
            if (s.isEmpty()) continue;
            filteredList.add(s);
        }
        return filteredList;
    }

    protected void setPermissionInCheckboxes(Permission permission) {
        this.switchButtons(this.comboRole.getText() != null && !this.comboRole.getText().isEmpty());
        this.buttonRead.setSelection(permission.isReadAllowed());
        this.buttonWrite.setSelection(permission.isWriteAllowed());
    }

    private void refreshTable() {
        ArrayList<Permission> permissionList = new ArrayList<Permission>(this.permissionSet);
        Collections.sort(permissionList);
        try {
            this.viewer.setInput((Object)permissionList.toArray());
        }
        catch (Exception t) {
            LOG.error((Object)"Error while setting table data", (Throwable)t);
        }
    }

    protected void showInformation() {
        if (this.isOverride()) {
            this.setMessage(Messages.AccessControlEditDialog_8);
        } else {
            this.setMessage(Messages.AccessControlEditDialog_7);
        }
    }

    protected Set<Permission> getSelectedPermissions() {
        HashSet<Permission> selectedPermission = new HashSet<Permission>();
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                selectedPermission.add((Permission)iterator.next());
            }
        }
        return selectedPermission;
    }

    private String[] getRoles() {
        if (this.roleArray == null) {
            boolean isLocalAdmin = this.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
            List accountsAndGroups = isLocalAdmin ? AccountLoader.loadAccountsAndGroupNamesForLocalAdmin() : AccountLoader.loadLoginAndGroupNames();
            this.roleArray = accountsAndGroups.toArray(new String[accountsAndGroups.size()]);
        }
        return this.roleArray;
    }

    protected void addPermission() {
        CnATreeElement element = null;
        if (this.elements != null && !this.elements.isEmpty()) {
            element = this.elements.get(0);
        }
        if (element != null) {
            Permission p = Permission.createPermission((CnATreeElement)element, (String)this.comboRole.getText(), (boolean)this.buttonRead.getSelection(), (boolean)this.buttonWrite.getSelection());
            this.permissionSet.remove(p);
            this.permissionSet.add(p);
            this.permissionSetAdd.remove(p);
            this.permissionSetAdd.add(p);
            this.refreshTable();
        }
    }

    protected void removePermission() {
        int[] selectionIndices;
        int[] nArray = selectionIndices = this.viewer.getTable().getSelectionIndices();
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Permission p = (Permission)this.viewer.getElementAt(i);
            this.viewer.getTable().getItem(i).setBackground(SWTResourceManager.getColor((int)230, (int)230, (int)230));
            this.viewer.getTable().getItem(i).setForeground(SWTResourceManager.getColor((int)180, (int)180, (int)180));
            this.viewer.getTable().getItem(i).setImage(1, this.getYesNoImage(p.isReadAllowed(), false));
            this.viewer.getTable().getItem(i).setImage(2, this.getYesNoImage(p.isWriteAllowed(), false));
            ++n2;
        }
        this.permissionSetAdd.removeAll(this.getSelectedPermissions());
        this.permissionSetRemove.addAll(this.getSelectedPermissions());
    }

    private Set<Permission> loadPermission(CnATreeElement firstElement) {
        LoadPermissions lp = new LoadPermissions(firstElement);
        try {
            lp = (LoadPermissions)ServiceFactory.lookupCommandService().executeCommand((ICommand)lp);
        }
        catch (CommandException e) {
            throw new RuntimeException(e);
        }
        this.permissionSet = Permission.clonePermissionSet((CnATreeElement)firstElement, (Set)lp.getPermissions());
        this.permissionSetAdd = Permission.clonePermissionSet((CnATreeElement)firstElement, (Set)lp.getPermissions());
        this.permissionSetRemove = new HashSet<Permission>();
        return this.permissionSet;
    }

    protected Image getYesNoImage(boolean value, boolean enabled) {
        if (value) {
            if (enabled) {
                return ImageCache.getInstance().getImage("16-em-check.png");
            }
            return ImageCache.getInstance().getImage("ok-disabled.png");
        }
        if (enabled) {
            return ImageCache.getInstance().getImage("16-em-cross.png");
        }
        return ImageCache.getInstance().getImage("progress_rem.gif");
    }

    private GridLayout generateGridLayout(int columns, boolean makeColumnsEqualWidth, int marginWidth, int marginHeight) {
        GridLayout layout = new GridLayout(columns, makeColumnsEqualWidth);
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        return layout;
    }

    private GridData generateGridData(Integer style, Boolean grabExcessHorizontalSpace, Boolean grabExcessVerticalSpace, Integer horizontalAlignment, Integer verticalAlignment, Integer horizontalSpan) {
        GridData data = style != null ? new GridData(style.intValue()) : new GridData();
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace != null ? grabExcessHorizontalSpace : data.grabExcessHorizontalSpace;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace != null ? grabExcessVerticalSpace : data.grabExcessVerticalSpace;
        data.horizontalAlignment = horizontalAlignment != null ? horizontalAlignment : data.horizontalAlignment;
        data.verticalAlignment = verticalAlignment != null ? verticalAlignment : data.verticalAlignment;
        data.horizontalSpan = horizontalSpan != null ? horizontalSpan : data.horizontalSpan;
        return data;
    }

    private Button generateButton(Composite composite, Integer style, String text, Boolean selection, SelectionListener listener) {
        Button button = new Button(composite, style.intValue());
        button.setText(text != null ? text : button.getText());
        button.setSelection(selection != null ? selection.booleanValue() : button.getSelection());
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    protected void okPressed() {
        boolean openConfirm;
        if (this.buttonInherit.getSelection() && !(openConfirm = MessageDialog.openConfirm((Shell)this.getParentShell(), (String)Messages.AccessControlEditDialog_0, (String)Messages.AccessControlEditDialog_2))) {
            return;
        }
        this.isOverride = this.radioButtonMode[1].getSelection();
        this.isUpdateChildren = this.buttonInherit.getSelection();
        super.okPressed();
    }

    public List<CnATreeElement> getElements() {
        return this.elements;
    }

    public Set<Permission> getPermissionSetAdd() {
        return this.permissionSetAdd;
    }

    public Set<Permission> getPermissionSetRemove() {
        return this.permissionSetRemove;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public boolean isUpdateChildren() {
        return this.isUpdateChildren;
    }

    private IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }
}

