/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.actions.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.NaturalizeCommand;

public class NaturalizeAction
extends RightsEnabledAction
implements ISelectionChangedListener {
    private static final Logger LOG = Logger.getLogger(NaturalizeAction.class);
    public static final String ID = "sernet.gs.ui.rcp.main.actions.NaturalizeAction";
    public static final String TYPE_ID = "naturalizeAction";
    private List<CnATreeElement> selectedElementList = new LinkedList<CnATreeElement>();
    private ICommandService commandService;

    public NaturalizeAction(IViewSite site) {
        super("naturalize", Messages.NaturalizeAction_0);
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("noaliens.png"));
        this.setToolTipText(Messages.NaturalizeAction_1);
        site.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    public void doRun() {
        int maxChangedElements = 10;
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Activator.inheritVeriniceContextState();
                        if (NaturalizeAction.this.selectedElementList != null && !NaturalizeAction.this.selectedElementList.isEmpty()) {
                            HashSet<String> uuidSet = new HashSet<String>(NaturalizeAction.this.selectedElementList.size());
                            HashMap<String, CnATreeElement> uuidElementMap = new HashMap<String, CnATreeElement>(NaturalizeAction.this.selectedElementList.size());
                            for (CnATreeElement element : NaturalizeAction.this.selectedElementList) {
                                if (element == null || element.getSourceId() == null) continue;
                                uuidSet.add(element.getUuid());
                                uuidElementMap.put(element.getUuid(), element);
                            }
                            NaturalizeCommand command = new NaturalizeCommand(uuidSet);
                            command = (NaturalizeCommand)NaturalizeAction.this.getCommandService().executeCommand((ICommand)command);
                            List changedElements = command.getChangedElements();
                            if (changedElements != null) {
                                if (changedElements.size() < 10) {
                                    for (CnATreeElement elementFromServer : changedElements) {
                                        CnATreeElement element = (CnATreeElement)uuidElementMap.get(elementFromServer.getUuid());
                                        element.setSourceId(elementFromServer.getSourceId());
                                        element.setExtId(elementFromServer.getExtId());
                                        CnAElementFactory.getModel(element).childChanged(element);
                                    }
                                } else {
                                    CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                                }
                            }
                        }
                    }
                    catch (CommandException e) {
                        LOG.error((Object)"Error while naturalizing element", (Throwable)e);
                        throw new RuntimeException("Error while naturalizing element", e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Error while naturalizing element", (Throwable)e);
            ExceptionUtil.log(e, Messages.NaturalizeAction_2);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        boolean enabled = false;
        this.selectedElementList.clear();
        for (Object o : event.getStructuredSelection()) {
            if (o instanceof CnATreeElement && CnAElementHome.getInstance().isWriteAllowed((CnATreeElement)o)) {
                this.selectedElementList.add((CnATreeElement)o);
                enabled = true;
                continue;
            }
            this.selectedElementList.clear();
            enabled = false;
            break;
        }
        this.setEnabled(enabled && this.checkRights());
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }
}

