/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.actions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.model.Baustein;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.actions.Messages;
import sernet.gs.ui.rcp.main.bsi.views.BSIKatalogInvisibleRoot;
import sernet.gs.ui.rcp.main.common.model.BuildInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.model.bsi.Server;
import sernet.verinice.model.common.CnATreeElement;

public class GSMBausteinZuordnungAction
extends RightsEnabledAction
implements ISelectionListener {
    private static final Logger LOG = Logger.getLogger(GSMBausteinZuordnungAction.class);
    public static final String ID = "sernet.gs.ui.rcp.main.gsmbausteinzuordnungaction";
    private final IWorkbenchWindow window;
    private static final String GSMTYP_MAPPING_FILE = "gsm_baustein.properties";
    private static final String SUBTYP_MAPPING_FILE = "subtyp-baustein.properties";
    private Properties gsmtypproperties;
    private Properties subtypproperties;

    public GSMBausteinZuordnungAction(IWorkbenchWindow window) {
        super("bausteinzuordnung", Messages.GSMBausteinZuordnungAction_1);
        this.window = window;
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("autobaustein.png"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    @Override
    public void doRun() {
        this.loadtemplates();
        final IStructuredSelection selection = (IStructuredSelection)this.window.getSelectionService().getSelection("sernet.gs.ui.rcp.main.views.bsimodelview");
        if (selection == null) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    for (Object o : selection) {
                        if (!(o instanceof Server)) continue;
                        Server server = (Server)o;
                        monitor.beginTask(Messages.GSMBausteinZuordnungAction_4, -1);
                        GSMBausteinZuordnungAction.this.loadModulForServer(server);
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.GSMBausteinZuordnungAction_3);
        }
    }

    private void loadModulForServer(Server serverelement) {
        try {
            String[] bausteine = this.getSplitBausteine(serverelement);
            if (bausteine == null || bausteine.length == 0) {
                this.showInfoMessage();
                return;
            }
            RetrieveInfo ri = RetrieveInfo.getChildrenInstance().setChildrenProperties(true).setParent(true);
            serverelement = (Server)Retriever.retrieveElement((CnATreeElement)serverelement, (RetrieveInfo)ri);
            String[] stringArray = bausteine;
            int n = bausteine.length;
            int n2 = 0;
            while (n2 < n) {
                String bst = stringArray[n2];
                Baustein baustein = BSIKatalogInvisibleRoot.getInstance().getBausteinByKapitel(bst);
                if (baustein == null) {
                    LOG.error((Object)("Kein Baustein gefunden fuer Nr.: " + bst));
                } else if (!serverelement.containsBausteinUmsetzung(baustein.getId())) {
                    try {
                        CnAElementFactory.getInstance().saveNew((CnATreeElement)serverelement, "bstumsetzung", new BuildInput<Baustein>(baustein), false);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error by saving.", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while assigning modules", (Throwable)e);
            ExceptionUtil.log(e, Messages.GSMBausteinZuordnungAction_6);
        }
    }

    private void showInfoMessage() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)GSMBausteinZuordnungAction.this.window.getShell(), (String)"Info", (String)Messages.GSMBausteinZuordnungAction_5);
            }
        });
    }

    private void loadtemplates() {
        this.gsmtypproperties = new Properties();
        this.subtypproperties = new Properties();
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(GSMTYP_MAPPING_FILE);
        InputStream stream2 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(SUBTYP_MAPPING_FILE);
        try {
            this.gsmtypproperties.load(stream);
            this.subtypproperties.load(stream2);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    private List<String> tagList(Server server) {
        ArrayList<String> gsmtaglist = new ArrayList<String>();
        String property = "";
        Collection tags = server.getTags();
        String tagstoString = tags.toString();
        String tag = tagstoString.substring(1, tagstoString.length() - 1);
        String[] splittags = tag.split(",\\s*");
        try {
            int split = 0;
            while (split < splittags.length) {
                String name = splittags[split];
                Set<Map.Entry<Object, Object>> entrySet = this.gsmtypproperties.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    String gsmkey = entry.getKey().toString();
                    String gsmproperty = entry.getValue().toString();
                    if (!name.equals(gsmkey)) continue;
                    property = gsmproperty;
                }
                gsmtaglist.add(property);
                ++split;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while assigning modules", (Throwable)e);
            ExceptionUtil.log(e, Messages.GSMBausteinZuordnungAction_3);
        }
        return gsmtaglist;
    }

    private List<String> readBausteine(Server server) {
        List<String> gsmlist = this.tagList(server);
        ArrayList<String> bausteinlist = new ArrayList<String>();
        Set<Map.Entry<Object, Object>> subtypentrySet = this.subtypproperties.entrySet();
        for (Map.Entry<Object, Object> subtypentry : subtypentrySet) {
            String subtyp = subtypentry.getKey().toString();
            String subtypproperty = subtypentry.getValue().toString();
            String[] subproperty = subtypproperty.split(",\\s*");
            int split = 0;
            while (split < subproperty.length) {
                String property = subproperty[split];
                for (String namesEntry : gsmlist) {
                    if (!namesEntry.equals(subtyp)) continue;
                    String value = property;
                    bausteinlist.add(value);
                }
                ++split;
            }
        }
        return bausteinlist;
    }

    private String[] getSplitBausteine(Server server) {
        List<String> bausteinlist = this.readBausteine(server);
        Object[] objList = bausteinlist.toArray();
        return (String[])Arrays.copyOf(objList, objList.length, String[].class);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection input) {
        if (this.isServerRunning()) {
            this.setEnabled(this.checkRights());
            if (input instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)input;
                for (Object o : selection) {
                    if (o instanceof Server) continue;
                    this.setEnabled(false);
                    return;
                }
                if (this.checkRights()) {
                    this.setEnabled(true);
                }
                return;
            }
        }
        this.setEnabled(false);
    }
}

