/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.actions.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.model.common.CnALink;

public class DeleteLinkActionDelegate
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (!this.checkRights()) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)((Shell)this.targetPart.getAdapter(Shell.class)), (String)Messages.DeleteLinkActionDelegate_0, (String)Messages.DeleteLinkActionDelegate_1)) {
            return;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
        IStructuredSelection selection = (IStructuredSelection)this.targetPart.getSite().getSelectionProvider().getSelection();
        for (Object sel : selection) {
            if (!(sel instanceof CnALink)) continue;
            CnALink link = (CnALink)sel;
            try {
                CnAElementHome.getInstance().remove(link);
                if (CnAElementFactory.isModelLoaded()) {
                    CnAElementFactory.getLoadedModel().linkRemoved(link);
                }
                CnAElementFactory.getInstance().getISO27kModel().linkRemoved(link);
                if (!CnAElementFactory.isBpModelLoaded()) continue;
                CnAElementFactory.getInstance().getBpModel().linkRemoved(link);
            }
            catch (Exception e) {
                ExceptionUtil.log(e, Messages.DeleteLinkActionDelegate_2);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object sel = ((IStructuredSelection)selection).getFirstElement();
        if (sel instanceof CnALink) {
            boolean b = CnAElementHome.getInstance().isDeleteAllowed((CnALink)sel);
            if (action.isEnabled()) {
                action.setEnabled(b);
            }
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "editlinks";
    }
}

