/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.springframework.dao.DataIntegrityViolationException;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.actions.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bp.DeductionImplementationUtil;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bp.elements.Safeguard;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27kElement;
import sernet.verinice.model.iso27k.IISO27kGroup;
import sernet.verinice.rcp.RightsEnabledHandler;
import sernet.verinice.service.commands.LoadConfiguration;
import sernet.verinice.service.commands.crud.LoadReportElements;
import sernet.verinice.service.commands.crud.PrepareObjectWithAccountDataForDeletion;

public class DeleteHandler
extends RightsEnabledHandler {
    private static final Logger LOG = Logger.getLogger(DeleteHandler.class);
    protected static final String DEFAULT_ERR_MSG = "Error while deleting element.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return this.execute(selection);
    }

    public Object execute(IStructuredSelection selection) {
        block7: {
            this.changeSelection((ISelection)selection);
            Activator.inheritVeriniceContextState();
            if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.DeleteActionDelegate_0, (String)NLS.bind((String)Messages.DeleteActionDelegate_1, (Object)selection.size()))) break block7;
            return null;
        }
        try {
            List<CnATreeElement> deleteList = this.createList(selection.toList());
            this.closeOpenEditors(deleteList);
            if (!deleteList.isEmpty() && deleteList.get(0) instanceof IISO27kElement) {
                this.doDeleteIso(deleteList);
            } else {
                this.doDelete(deleteList);
            }
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)e);
            ExceptionUtil.log(e.getCause(), Messages.DeleteActionDelegate_16);
        }
        catch (InterruptedException e) {
            LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)e);
            ExceptionUtil.log(e, Messages.DeleteActionDelegate_17);
        }
        catch (Exception e) {
            LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)e);
            ExceptionUtil.log(e, Messages.DeleteActionDelegate_17);
        }
        return null;
    }

    private void closeOpenEditors(List<CnATreeElement> deleteList) throws PartInitException {
        Set<IEditorReference> editorsToCloseSet = this.getRelevantEditors(deleteList);
        ArrayList<IEditorReference> editorsToCloseList = new ArrayList<IEditorReference>(editorsToCloseSet.size());
        editorsToCloseList.addAll(editorsToCloseSet);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editorsToCloseList.toArray(new IEditorReference[editorsToCloseList.size()]), true);
    }

    private Set<IEditorReference> getRelevantEditors(List<CnATreeElement> deleteList) throws PartInitException {
        HashSet<IEditorReference> closeableEditors = new HashSet<IEditorReference>();
        for (CnATreeElement elementToDelete : deleteList) {
            if (!elementToDelete.isScope()) {
                Optional<IEditorReference> reference = this.findOpenEditor(elementToDelete);
                reference.ifPresent(closeableEditors::add);
                if (!Safeguard.isSafeguard((CnATreeElement)elementToDelete)) continue;
                this.addEditorsForLinkedRequirements(elementToDelete, closeableEditors);
                continue;
            }
            closeableEditors.addAll(this.findOpenEditors(elementToDelete.getScopeId()));
        }
        return closeableEditors;
    }

    private void addEditorsForLinkedRequirements(CnATreeElement elementToDelete, Set<IEditorReference> closeableEditors) throws PartInitException {
        CnATreeElement safeguard = elementToDelete;
        if (!Retriever.areLinksInitizialized((CnATreeElement)safeguard, (boolean)true)) {
            RetrieveInfo retrieveInfo = new RetrieveInfo().setLinksUp(true).setLinksUpProperties(true);
            safeguard = Retriever.retrieveElement((CnATreeElement)safeguard, (RetrieveInfo)retrieveInfo);
        }
        for (CnALink link : safeguard.getLinksUp()) {
            CnATreeElement requirement;
            if (!DeductionImplementationUtil.isRelevantLinkForImplementationStateDeduction((CnALink)link) || !DeductionImplementationUtil.isDeductiveImplementationEnabled((CnATreeElement)(requirement = link.getDependant()))) continue;
            Optional<IEditorReference> editor = this.findOpenEditor(requirement);
            editor.ifPresent(closeableEditors::add);
        }
    }

    private Set<IEditorReference> findOpenEditors(int scopeId) throws PartInitException {
        HashSet<IEditorReference> closeableEditors = new HashSet<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BSIElementEditorInput bsiElementEditorInput;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorInput o = editorReference.getEditorInput();
            if (o instanceof BSIElementEditorInput && scopeId == (bsiElementEditorInput = (BSIElementEditorInput)o).getCnAElement().getScopeId()) {
                closeableEditors.add(editorReference);
            }
            ++n2;
        }
        return closeableEditors;
    }

    private Optional<IEditorReference> findOpenEditor(CnATreeElement element) throws PartInitException {
        IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BSIElementEditorInput bsiElementEditorInput;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorInput o = editorReference.getEditorInput();
            if (o instanceof BSIElementEditorInput && element.equals((Object)(bsiElementEditorInput = (BSIElementEditorInput)o).getCnAElement())) {
                return Optional.of(editorReference);
            }
            ++n2;
        }
        return Optional.empty();
    }

    protected void doDelete(List<CnATreeElement> deleteList) throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new DeleteElements(deleteList));
    }

    protected void doDeleteIso(final List<CnATreeElement> deleteList) throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Object sel = null;
                try {
                    Activator.inheritVeriniceContextState();
                    monitor.beginTask(Messages.DeleteActionDelegate_11, deleteList.size());
                    monitor.setTaskName(Messages.DeleteActionDelegate_14);
                    DeleteHandler.removeElements(deleteList);
                }
                catch (DataIntegrityViolationException dive) {
                    DeleteHandler.deleteElementWithAccountAsync(sel);
                }
                catch (Exception e) {
                    LOG.error((Object)DeleteHandler.DEFAULT_ERR_MSG, (Throwable)e);
                    ExceptionUtil.log(e, Messages.DeleteActionDelegate_15);
                }
            }
        });
    }

    protected List<CnATreeElement> createList(List<CnATreeElement> elementList) {
        ArrayList<CnATreeElement> tempList = new ArrayList<CnATreeElement>();
        ArrayList<CnATreeElement> insertList = new ArrayList<CnATreeElement>();
        if (elementList.size() > 1) {
            for (CnATreeElement element : elementList) {
                this.createList(element, tempList, insertList);
            }
        } else {
            insertList.add(elementList.get(0));
        }
        return insertList;
    }

    private void createList(CnATreeElement element, List<CnATreeElement> tempList, List<CnATreeElement> insertList) {
        if (!tempList.contains(element)) {
            tempList.add(element);
            insertList.add(element);
            if (element instanceof IISO27kGroup && element.getChildren() != null) {
                element = Retriever.checkRetrieveChildren((CnATreeElement)element);
                for (CnATreeElement child : element.getChildren()) {
                    this.createList(child, tempList, insertList);
                }
            }
        } else {
            insertList.remove(element);
        }
    }

    protected static void deleteElementWithAccountAsync(CnATreeElement element) {
        Display.getDefault().asyncExec(() -> {
            try {
                DeleteHandler.deleteElementWithAccount(element);
            }
            catch (CommandException e1) {
                LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)e1);
                ExceptionUtil.log(e1, Messages.DeleteActionDelegate_15);
            }
            catch (DataIntegrityViolationException de) {
                LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)de);
            }
            catch (Exception e2) {
                LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)e2);
                ExceptionUtil.log(e2, Messages.DeleteActionDelegate_15);
            }
        });
    }

    protected static void deleteElementWithAccount(CnATreeElement element) throws CommandException {
        PrepareObjectWithAccountDataForDeletion command = null;
        if (DeleteHandler.loadConfiguration(element)) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.DeleteActionDelegate_0, (String)Messages.DeleteActionDelegate_18)) {
                command = new PrepareObjectWithAccountDataForDeletion(element);
                ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            } else {
                return;
            }
        }
        DeleteHandler.removeElements(Set.of(element));
    }

    protected static void removeElements(Collection<CnATreeElement> elementsToRemove) throws CommandException {
        CnAElementHome.getInstance().remove(elementsToRemove);
        elementsToRemove.forEach(elementToRemove -> {
            CnAElementFactory.getModel(elementToRemove).databaseChildRemoved(elementToRemove);
            CnAElementFactory.getInstance().getCatalogModel().databaseChildRemoved(elementToRemove);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean loadConfiguration(CnATreeElement elmt) {
        String[] types = new String[]{"person", "person-iso"};
        ICommandService service = ServiceFactory.lookupCommandService();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            try {
                LoadReportElements command = new LoadReportElements(type, elmt.getDbId());
                command = (LoadReportElements)service.executeCommand((ICommand)command);
                for (CnATreeElement person : command.getElements()) {
                    LoadConfiguration command2 = new LoadConfiguration(person);
                    if ((command2 = (LoadConfiguration)service.executeCommand((ICommand)command2)).getConfiguration() == null) continue;
                    return true;
                }
            }
            catch (CommandException e) {
                LOG.error((Object)"Error determing existence of configuration objects", (Throwable)e);
            }
            ++n2;
        }
        return false;
    }

    private void changeSelection(ISelection selection) {
        boolean allowed = this.checkRights();
        boolean isWriteAllowed = true;
        Object sel = ((IStructuredSelection)selection).getFirstElement();
        if (allowed && sel instanceof CnATreeElement) {
            CnATreeElement element = (CnATreeElement)sel;
            isWriteAllowed = CnAElementHome.getInstance().isDeleteAllowed(element);
        }
        if (this.isEnabled()) {
            this.setEnabled(isWriteAllowed && allowed);
        }
    }

    public String getRightID() {
        return "deleteitem";
    }

    private static final class DeleteElements
    implements IRunnableWithProgress {
        private final List<CnATreeElement> deleteList;

        private DeleteElements(List<CnATreeElement> deleteList) {
            this.deleteList = deleteList;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            CnATreeElement sel = null;
            try {
                try {
                    Activator.inheritVeriniceContextState();
                    monitor.beginTask(Messages.DeleteActionDelegate_14, -1);
                    boolean reloadBpModel = this.deleteList.stream().anyMatch(IBpElement.class::isInstance);
                    DeleteHandler.removeElements(this.deleteList);
                    if (!reloadBpModel) return;
                    BpModel bpModel = CnAElementFactory.getInstance().getBpModel();
                    bpModel.modelReload(bpModel);
                    return;
                }
                catch (DataIntegrityViolationException dive) {
                    DeleteHandler.deleteElementWithAccountAsync(sel);
                    if (monitor == null) return;
                    monitor.done();
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)DeleteHandler.DEFAULT_ERR_MSG, (Throwable)e);
                    ExceptionUtil.log(e, Messages.DeleteActionDelegate_15);
                    if (monitor == null) return;
                    monitor.done();
                    return;
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }
}

