/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import sernet.gs.model.Baustein;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.actions.Messages;
import sernet.gs.ui.rcp.main.bsi.dialogs.AutoBausteinDialog;
import sernet.gs.ui.rcp.main.bsi.views.BSIKatalogInvisibleRoot;
import sernet.gs.ui.rcp.main.common.model.BuildInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.common.CnATreeElement;

public class BausteinZuordnungAction
extends RightsEnabledAction
implements ISelectionListener {
    private static final Logger LOG = Logger.getLogger(BausteinZuordnungAction.class);
    public static final String ID = "sernet.gs.ui.rcp.main.bausteinzuordnungaction";
    private final IWorkbenchWindow window;

    public BausteinZuordnungAction(IWorkbenchWindow window) {
        super("bausteinzuordnung", Messages.BausteinZuordnungAction_1);
        this.window = window;
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("autobaustein.png"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.setToolTipText(Messages.BausteinZuordnungAction_2);
    }

    @Override
    public void doRun() {
        IStructuredSelection selection = (IStructuredSelection)this.window.getSelectionService().getSelection("sernet.gs.ui.rcp.main.views.bsimodelview");
        if (selection == null) {
            return;
        }
        List<IBSIStrukturElement> selectedElements = this.getSelectedElements(selection);
        AutoBausteinDialog dialog = new AutoBausteinDialog(this.window.getShell());
        if (dialog.open() != 0 || dialog.getSelectedSubtype() == null) {
            return;
        }
        try {
            String[] modulesNumberArray;
            String[] stringArray = modulesNumberArray = dialog.getSelectedSubtype().getSplitBausteine();
            int n = modulesNumberArray.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleNumber = stringArray[n2];
                Baustein module = BSIKatalogInvisibleRoot.getInstance().getBausteinByKapitel(moduleNumber);
                if (module == null) {
                    LOG.debug((Object)("No mudule found for nr.: " + moduleNumber));
                } else {
                    this.processModule(module, selectedElements);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while adding modules.", (Throwable)e);
            ExceptionUtil.log(e, Messages.BausteinZuordnungAction_4);
        }
    }

    protected void processModule(Baustein module, List<IBSIStrukturElement> selectedElements) {
        for (IBSIStrukturElement target : selectedElements) {
            if (!(target instanceof CnATreeElement)) continue;
            this.addModule(module, (CnATreeElement)target);
        }
    }

    protected void addModule(Baustein nodule, CnATreeElement element) {
        CnATreeElement elementInitialized = element;
        if (!element.getChildren().isEmpty()) {
            RetrieveInfo ri = RetrieveInfo.getPropertyChildrenInstance();
            ri.setChildrenProperties(true);
            ri.setParent(true);
            elementInitialized = Retriever.retrieveElement((CnATreeElement)element, (RetrieveInfo)ri);
        }
        if (!elementInitialized.containsBausteinUmsetzung(nodule.getId())) {
            try {
                CnAElementFactory.getInstance().saveNew(elementInitialized, "bstumsetzung", new BuildInput<Baustein>(nodule), false);
            }
            catch (Exception e) {
                LOG.error((Object)"Error by saving.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected List<IBSIStrukturElement> getSelectedElements(IStructuredSelection selection) {
        ArrayList<IBSIStrukturElement> selectedElements = new ArrayList<IBSIStrukturElement>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof IBSIStrukturElement)) continue;
            selectedElements.add((IBSIStrukturElement)o);
        }
        return selectedElements;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection input) {
        if (this.isServerRunning()) {
            this.setEnabled(this.checkRights());
        }
        if (input instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)input;
            if (selection.size() < 1) {
                this.setEnabled(false);
                return;
            }
            for (Object o : selection.toList()) {
                if (o instanceof IBSIStrukturElement) continue;
                this.setEnabled(false);
                return;
            }
            if (this.checkRights()) {
                this.setEnabled(true);
            }
            return;
        }
        this.setEnabled(false);
    }
}

