/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.actions;

import java.io.File;
import java.util.Calendar;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.actions.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.views.FileView;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.model.bsi.Addition;
import sernet.verinice.model.bsi.Attachment;
import sernet.verinice.model.common.CnATreeElement;

public class AddFileActionDelegate
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        try {
            Object sel = ((IStructuredSelection)this.targetPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
            if (sel instanceof CnATreeElement) {
                CnATreeElement element = (CnATreeElement)sel;
                FileDialog fd = new FileDialog(this.targetPart.getSite().getShell());
                fd.setText(Messages.AddFileActionDelegate_0);
                fd.setFilterPath(System.getProperty("user.home"));
                String selected = fd.open();
                if (selected != null && selected.length() > 0) {
                    File file = new File(selected);
                    if (file.isDirectory()) {
                        return;
                    }
                    Attachment attachment = new Attachment();
                    attachment.setCnATreeElement(element);
                    attachment.setCnAElementTitel(element.getTitle());
                    attachment.setTitel(file.getName());
                    attachment.setDate(Calendar.getInstance().getTime());
                    attachment.setFilePath(selected);
                    attachment.setFileSize(String.valueOf(file.length()));
                    attachment.addListener(new Addition.INoteChangedListener(){

                        public void noteChanged() {
                            IViewPart page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("sernet.gs.ui.rcp.main.bsi.views.FileView");
                            if (page != null) {
                                ((FileView)page).loadFiles();
                            }
                        }
                    });
                    EditorFactory.getInstance().openEditor(attachment);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.AddFileActionDelegate_2);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights() && this.isCnATreeElementEditable(selection));
    }

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "addfile";
    }

    private boolean isCnATreeElementEditable(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof CnATreeElement) {
            return CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)element);
        }
        return false;
    }
}

