/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions.helper;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IRightsServiceClient;
import sernet.verinice.interfaces.PasswordException;
import sernet.verinice.interfaces.UsernameExistsException;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.service.commands.SaveConfiguration;

public class UpdateConfigurationHelper
implements IRunnableWithProgress {
    private final Logger LOG = Logger.getLogger(UpdateConfigurationHelper.class);
    private final Configuration configuration;
    private IRightsServiceClient rightsService;
    private ICommandService commandService;

    public UpdateConfigurationHelper(Configuration configuration) {
        this.configuration = configuration;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Activator.inheritVeriniceContextState();
        try {
            boolean updatePassword = this.updateNameAndPassword(this.configuration.getUserNew(), this.configuration.getPassNew());
            SaveConfiguration command = new SaveConfiguration(this.configuration, updatePassword);
            command = (SaveConfiguration)this.getCommandService().executeCommand((ICommand)command);
            this.getRightService().reload();
        }
        catch (UsernameExistsException e) {
            String logMessage = "Configuration can not be saved. Username exists: " + e.getUsername();
            String messageTitle = Messages.ConfigurationAction_7;
            String userMessage = NLS.bind((String)Messages.ConfigurationAction_7, (Object)e.getUsername());
            this.handleException((Exception)((Object)e), logMessage, messageTitle, userMessage);
        }
        catch (PasswordException e) {
            String logMessage = "Configuration can not be saved. " + e.getMessage();
            String messageTitle = Messages.ConfigurationAction_6;
            String userMessage = e.getMessage();
            this.handleException((Exception)((Object)e), logMessage, messageTitle, userMessage);
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error while saving configuration.", (Throwable)e);
            ExceptionUtil.log(e, Messages.ConfigurationAction_5);
        }
    }

    private void handleException(Exception e, String logMessage, final String messageTitle, final String userMessage) {
        this.LOG.info((Object)logMessage);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"stacktrace: ", (Throwable)e);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)messageTitle, (String)userMessage);
            }
        });
    }

    boolean updateNameAndPassword(String newName, String newPassword) {
        boolean updated = false;
        String oldName = this.configuration.getUser();
        if (this.isNewName(oldName, newName) && (newPassword == null || newPassword.isEmpty()) && this.getAuthService().isHandlingPasswords()) {
            throw new PasswordException(Messages.ConfigurationAction_9);
        }
        this.configuration.setUser(newName);
        if (newPassword != null && !newPassword.isEmpty()) {
            this.configuration.setPass(newPassword);
            updated = true;
        }
        return updated;
    }

    private boolean isNewName(String oldName, String name) {
        boolean result = false;
        result = oldName != null ? (name == null ? true : !oldName.equals(name)) : name != null;
        return result;
    }

    private IRightsServiceClient getRightService() {
        if (this.rightsService == null) {
            this.rightsService = (IRightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    private IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }
}

