/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;

public abstract class ViewAndWindowAction
extends RightsEnabledAction
implements ISelectionListener,
ISelectionChangedListener {
    private IWorkbenchWindow window;
    private IViewSite site;

    protected ViewAndWindowAction(String rightID, String text) {
        super(rightID, text);
    }

    protected Shell getShell() {
        return this.window == null ? this.site.getShell() : this.window.getShell();
    }

    protected void setWindow(IWorkbenchWindow window) {
        if (this.site != null) {
            throw new IllegalStateException("Cannot set window when site is set");
        }
        this.window = window;
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    protected void setSite(IViewSite site) {
        if (this.window != null) {
            throw new IllegalStateException("Cannot set site when window is set");
        }
        this.site = site;
        site.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private ISelection getCurrentSelection() {
        return this.window == null ? this.site.getSelectionProvider().getSelection() : this.window.getSelectionService().getSelection();
    }

    protected abstract void selectionChanged(IStructuredSelection var1);

    protected abstract void doRun(IStructuredSelection var1);

    @Override
    public final void doRun() {
        ISelection currentSelection = this.getCurrentSelection();
        if (currentSelection instanceof IStructuredSelection) {
            this.doRun((IStructuredSelection)currentSelection);
        }
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection structuredSelection = event.getStructuredSelection();
        this.selectionChanged(structuredSelection);
    }

    public final void selectionChanged(IWorkbenchPart part, ISelection input) {
        if (input instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)input);
        } else {
            this.setEnabled(false);
        }
    }
}

