/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import sernet.gs.ui.rcp.main.actions.ShowCheatSheetAction;

public abstract class ShowPerspectiveIntroAction
implements IIntroAction {
    private static final Logger LOG = Logger.getLogger(ShowPerspectiveIntroAction.class);

    public void run(IIntroSite arg0, Properties arg1) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPerspectiveDescriptor activePerspective = workbenchWindow.getActivePage().getPerspective();
        if (activePerspective == null || !activePerspective.getId().equals(this.getPerspectiveId())) {
            Display.getCurrent().asyncExec(() -> {
                try {
                    workbenchWindow.getWorkbench().showPerspective(this.getPerspectiveId(), workbenchWindow);
                }
                catch (WorkbenchException e) {
                    LOG.error((Object)("Can not switch to perspective: " + this.getPerspectiveId()), (Throwable)e);
                }
            });
        }
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
        ShowCheatSheetAction action = new ShowCheatSheetAction("Show security assessment cheat sheet", this.getCheatSheetId());
        action.run();
    }

    public abstract String getCheatSheetId();

    public abstract String getPerspectiveId();
}

