/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.ViewAndWindowAction;
import sernet.gs.ui.rcp.main.bsi.dialogs.KonsolidatorDialog;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.task.KonsolidatorCommand;

public class ShowKonsolidatorAction
extends ViewAndWindowAction {
    public static final String ID = "sernet.gs.ui.rcp.main.actions.showkonsolidatoraction";

    private ShowKonsolidatorAction(String label) {
        super("konsolidator", label);
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("konsolidator.png"));
        this.setToolTipText(Messages.ShowKonsolidatorAction_1);
    }

    public ShowKonsolidatorAction(IWorkbenchWindow window, String label) {
        this(label);
        this.setWindow(window);
    }

    public ShowKonsolidatorAction(IViewSite site, String label) {
        this(label);
        this.setSite(site);
    }

    @Override
    protected void doRun(IStructuredSelection selection) {
        Activator.inheritVeriniceContextState();
        final ArrayList<BausteinUmsetzung> selectedElements = new ArrayList<BausteinUmsetzung>();
        for (Object o : selection) {
            if (!(o instanceof BausteinUmsetzung)) continue;
            BausteinUmsetzung baustein = (BausteinUmsetzung)o;
            this.initParent(baustein);
            selectedElements.add(baustein);
        }
        final KonsolidatorDialog dialog = new KonsolidatorDialog(this.getShell(), selectedElements);
        if (dialog.open() != 0 || dialog.getSource() == null) {
            return;
        }
        if (!KonsolidatorDialog.askConsolidate(this.getShell())) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    monitor.setTaskName(Messages.ShowKonsolidatorAction_2);
                    monitor.beginTask(Messages.ShowKonsolidatorAction_3, selectedElements.size() + 1);
                    BausteinUmsetzung source = dialog.getSource();
                    try {
                        KonsolidatorCommand command = new KonsolidatorCommand(selectedElements, source);
                        command = (KonsolidatorCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        for (CnATreeElement element : command.getChangedElements()) {
                            CnAElementFactory.getLoadedModel().databaseChildChanged(element);
                        }
                    }
                    catch (CommandException e) {
                        ExceptionUtil.log(e, Messages.ShowKonsolidatorAction_4);
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException e) {
            ExceptionUtil.log(e, Messages.ShowKonsolidatorAction_5);
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.ShowKonsolidatorAction_6);
        }
    }

    private void initParent(BausteinUmsetzung baustein) {
        CnATreeElement withParent = Retriever.checkRetrieveParent((CnATreeElement)baustein);
        CnATreeElement parent = Retriever.checkRetrieveElement((CnATreeElement)withParent.getParent());
        baustein.setParent(parent);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        if (selection.size() < 2) {
            this.setEnabled(false);
            return;
        }
        String kapitel = null;
        for (Object o : selection) {
            if (o instanceof BausteinUmsetzung) {
                BausteinUmsetzung bst = (BausteinUmsetzung)o;
                if (kapitel == null) {
                    kapitel = bst.getKapitel();
                    continue;
                }
                if (bst.getKapitel().equals(kapitel)) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(false);
            return;
        }
        if (this.checkRights()) {
            this.setEnabled(true);
        }
    }
}

