/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.ViewAndWindowAction;
import sernet.gs.ui.rcp.main.bsi.dialogs.BulkEditDialog;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.swt.widgets.IHuiControlFactory;
import sernet.verinice.bp.rcp.risk.ui.RiskUiUtils;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bp.DeductionImplementationUtil;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.elements.Safeguard;
import sernet.verinice.model.bpm.TodoViewItem;
import sernet.verinice.model.bsi.DocumentReference;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27kElement;
import sernet.verinice.service.bp.risk.RiskDeductionUtil;
import sernet.verinice.service.commands.UpdateMultipleElementEntities;

public class ShowBulkEditAction
extends ViewAndWindowAction {
    private static final Logger logger = Logger.getLogger(ShowBulkEditAction.class);
    private List<Integer> dbIDs;
    private ArrayList<CnATreeElement> selectedElements;
    private EntityType entType = null;
    public static final String ID = "sernet.gs.ui.rcp.main.actions.showbulkeditaction";

    private ShowBulkEditAction(String label) {
        super("bulkedit", label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("application_cascade.png"));
        this.setToolTipText(Messages.ShowBulkEditAction_1);
    }

    public ShowBulkEditAction(IWorkbenchWindow window, String label) {
        this(label);
        this.setWindow(window);
    }

    public ShowBulkEditAction(IViewSite site, String label) {
        this(label);
        this.setSite(site);
    }

    @Override
    protected void doRun(IStructuredSelection selection) {
        Activator.inheritVeriniceContextState();
        if (!this.isAllowed(selection)) {
            return;
        }
        this.dbIDs = new ArrayList<Integer>(selection.size());
        this.selectedElements = new ArrayList();
        this.entType = null;
        this.readSelection(selection);
        Map<String, IHuiControlFactory> overrides = RiskUiUtils.createHuiControlFactories(this.selectedElements.get(0));
        BulkEditDialog dialog = new BulkEditDialog(this.getShell(), this.entType, overrides);
        if (dialog.open() != 0) {
            return;
        }
        final Entity dialogEntity = dialog.getEntity();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ShowBulkEditAction.this.doEdit(dialogEntity, monitor);
                }
            });
        }
        catch (InterruptedException e) {
            ExceptionUtil.log(e, Messages.ShowBulkEditAction_5);
        }
        catch (Exception e) {
            logger.error((Object)"Error on bulk edit", (Throwable)e);
            ExceptionUtil.log(e, Messages.ShowBulkEditAction_6);
        }
    }

    private void doEdit(Entity dialogEntity, IProgressMonitor monitor) throws InterruptedException {
        Activator.inheritVeriniceContextState();
        if (!this.selectedElements.isEmpty()) {
            this.editElements(this.selectedElements, dialogEntity, monitor);
        }
        monitor.done();
        this.refreshListeners();
    }

    private void refreshListeners() {
        boolean isIsoElement = false;
        for (CnATreeElement cnATreeElement : this.selectedElements) {
            isIsoElement = cnATreeElement instanceof IISO27kElement;
            if (isIsoElement) break;
        }
        if (CnAElementFactory.getLoadedModel() != null) {
            CnAElementFactory.getLoadedModel().refreshAllListeners((Object)"source bulk edit");
        }
        if (isIsoElement) {
            CnAElementFactory.getInstance().getISO27kModel().refreshAllListeners((Object)"source bulk edit");
        }
        if (CnAElementFactory.isBpModelLoaded()) {
            CnAElementFactory.getInstance().getBpModel().refreshAllListeners((Object)"source bulk edit");
        }
    }

    private void readSelection(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof TodoViewItem) {
            for (TodoViewItem item : selection) {
                this.dbIDs.add(item.getDbId());
            }
            this.entType = HUITypeFactory.getInstance().getEntityType("mnums");
        } else {
            for (Object o : selection) {
                CnATreeElement elmt = null;
                if (o instanceof CnATreeElement) {
                    elmt = (CnATreeElement)o;
                } else if (o instanceof DocumentReference) {
                    DocumentReference ref = (DocumentReference)o;
                    elmt = ref.getCnaTreeElement();
                }
                if (elmt == null) continue;
                this.entType = HUITypeFactory.getInstance().getEntityType(elmt.getEntity().getEntityType());
                this.selectedElements.add(elmt);
                logger.debug((Object)("Adding to bulk edit: " + elmt.getTitle()));
            }
        }
    }

    private boolean isAllowed(IStructuredSelection selection) {
        for (Object next : selection) {
            boolean writeallowed;
            if (!(next instanceof CnATreeElement) || (writeallowed = CnAElementHome.getInstance().isWriteAllowed((CnATreeElement)next))) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ShowBulkEditAction_2, (String)NLS.bind((String)Messages.ShowBulkEditAction_3, (Object)((CnATreeElement)next).getTitle()));
            this.setEnabled(false);
            return false;
        }
        return true;
    }

    private void editElements(List<CnATreeElement> selectedElements, Entity dialogEntity, IProgressMonitor monitor) {
        monitor.setTaskName(Messages.ShowBulkEditAction_9);
        monitor.beginTask(Messages.ShowBulkEditAction_10, selectedElements.size() + 1);
        ArrayList<CnATreeElement> elementsToSave = new ArrayList<CnATreeElement>(selectedElements.size());
        for (CnATreeElement elmt : selectedElements) {
            boolean elementIsThreat = elmt instanceof BpThreat;
            if (elementIsThreat) {
                elmt = Retriever.retrieveElement((CnATreeElement)elmt, (RetrieveInfo)RetrieveInfo.getPropertyInstance().setLinksUp(true));
            }
            Entity editEntity = elmt.getEntity();
            editEntity.copyEntity(dialogEntity);
            if (elementIsThreat) {
                RiskDeductionUtil.deduceRisk((BpThreat)((BpThreat)elmt));
            }
            elementsToSave.add(elmt);
            elmt.getEntity().trackChange(ServiceFactory.lookupAuthService().getUsername());
            monitor.worked(1);
        }
        try {
            monitor.setTaskName(Messages.ShowBulkEditAction_11);
            monitor.beginTask(Messages.ShowBulkEditAction_12, -1);
            UpdateMultipleElementEntities command = new UpdateMultipleElementEntities(elementsToSave);
            command = (UpdateMultipleElementEntities)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            List changedElements = command.getChangedElements();
            for (CnATreeElement cnATreeElement : changedElements) {
                CnAElementFactory.getModel(cnATreeElement).childChanged(cnATreeElement);
                this.updateRelatedProperties(cnATreeElement);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while bulk update", (Throwable)e);
            ExceptionUtil.log(e, Messages.ShowBulkEditAction_13);
        }
    }

    private void updateRelatedProperties(CnATreeElement cnATreeElement) {
        if (cnATreeElement instanceof Safeguard) {
            this.updateSafeguardRelatedProperties((Safeguard)cnATreeElement);
        }
    }

    private void updateSafeguardRelatedProperties(Safeguard safeguard) {
        CnATreeElement fetchedSafeguard = Retriever.retrieveElement((CnATreeElement)safeguard, (RetrieveInfo)new RetrieveInfo().setProperties(true).setLinksUp(true).setLinksUpProperties(true));
        Set linksUp = fetchedSafeguard.getLinksUp();
        for (CnALink cnALink : linksUp) {
            CnATreeElement requirement;
            if (!DeductionImplementationUtil.isRelevantLinkForImplementationStateDeduction((CnALink)cnALink) || !DeductionImplementationUtil.isDeductiveImplementationEnabled((CnATreeElement)(requirement = cnALink.getDependant()))) continue;
            CnAElementFactory.getModel(requirement).childChanged(requirement);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection structuredSelection) {
        IStructuredSelection selection = structuredSelection;
        boolean selectionEmpty = selection.isEmpty();
        if (!selectionEmpty && selection.getFirstElement() instanceof TodoViewItem) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (iter.next() instanceof TodoViewItem) continue;
                this.setEnabled(false);
                return;
            }
            if (this.checkRights()) {
                this.setEnabled(true);
            }
            return;
        }
        CnATreeElement elmt = null;
        if (!selectionEmpty && selection.getFirstElement() instanceof DocumentReference) {
            elmt = ((DocumentReference)selection.getFirstElement()).getCnaTreeElement();
        } else if (!selectionEmpty && selection.getFirstElement() instanceof CnATreeElement && ((CnATreeElement)selection.getFirstElement()).getEntity() != null) {
            elmt = (CnATreeElement)selection.getFirstElement();
        }
        if (elmt != null) {
            String type = elmt.getEntity().getEntityType();
            for (Object o : selection) {
                if (o instanceof CnATreeElement) {
                    elmt = (CnATreeElement)o;
                    continue;
                }
                if (!(o instanceof DocumentReference)) continue;
                DocumentReference ref = (DocumentReference)o;
                elmt = ref.getCnaTreeElement();
            }
            if (elmt == null || elmt.getEntity() == null || !elmt.getEntity().getEntityType().equals(type)) {
                this.setEnabled(false);
                return;
            }
            if (this.checkRights()) {
                this.setEnabled(true);
            }
        }
    }
}

