/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.ConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.ViewAndWindowAction;
import sernet.gs.ui.rcp.main.bsi.dialogs.PersonBulkEditDialog;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.Entity;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.PasswordException;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.CreateConfiguration;
import sernet.verinice.service.commands.LoadConfiguration;
import sernet.verinice.service.commands.task.ConfigurationBulkEditUpdate;

public class ShowBulkEditAccountsAction
extends ViewAndWindowAction {
    private static final Logger logger = Logger.getLogger(ShowBulkEditAccountsAction.class);
    private List<Integer> dbIDs;
    public static final String ID = "sernet.gs.ui.rcp.main.actions.showbulkeditaccountsaction";
    private static final Set<String> SUPPORTED_ELEMENT_TYPES = Stream.of("person", "person-iso", "bp_person").collect(Collectors.toSet());

    private ShowBulkEditAccountsAction(String label) {
        super("accountsettings", label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("accounts_bulk.png"));
        this.setToolTipText(Messages.EditMultipleAccountsTogether);
    }

    public ShowBulkEditAccountsAction(IWorkbenchWindow window, String label) {
        this(label);
        this.setWindow(window);
    }

    public ShowBulkEditAccountsAction(IViewSite site, String label) {
        this(label);
        this.setSite(site);
    }

    @Override
    protected void doRun(IStructuredSelection selection) {
        Activator.inheritVeriniceContextState();
        Optional<CnATreeElement> nonWritableElement = this.findNonWritableElement(selection);
        if (nonWritableElement.isPresent()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ShowBulkEditAction_2, (String)NLS.bind((String)Messages.ShowBulkEditAction_3, (Object)nonWritableElement.get().getTitle()));
            this.setEnabled(false);
            return;
        }
        this.dbIDs = new ArrayList<Integer>(selection.size());
        this.readSelection(selection);
        final PersonBulkEditDialog dialog = new PersonBulkEditDialog(this.getShell(), Messages.ShowBulkEditAction_14);
        if (dialog.open() != 0) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ShowBulkEditAccountsAction.this.doEdit(dialog, monitor);
                }
            });
        }
        catch (InterruptedException e) {
            ExceptionUtil.log(e, Messages.ShowBulkEditAction_5);
        }
        catch (Exception e) {
            logger.error((Object)"Error on bulk edit", (Throwable)e);
            ExceptionUtil.log(e, Messages.ShowBulkEditAction_6);
        }
    }

    private void doEdit(PersonBulkEditDialog dialog, IProgressMonitor monitor) throws InterruptedException {
        Activator.inheritVeriniceContextState();
        try {
            String pw1 = dialog.getPassword();
            String pw2 = dialog.getPassword2();
            this.editPersons(this.dbIDs, dialog.getEntity(), monitor, pw1, pw2);
        }
        catch (CommandException e) {
            throw new InterruptedException(e.getLocalizedMessage());
        }
        monitor.done();
    }

    private void readSelection(IStructuredSelection selection) {
        for (CnATreeElement cElmt : selection) {
            LoadConfiguration command = new LoadConfiguration(cElmt);
            try {
                command = (LoadConfiguration)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                if (command.getConfiguration() != null) {
                    this.dbIDs.add(command.getConfiguration().getDbId());
                    continue;
                }
                CreateConfiguration command2 = new CreateConfiguration(cElmt);
                command2 = (CreateConfiguration)ServiceFactory.lookupCommandService().executeCommand((ICommand)command2);
                this.dbIDs.add(command2.getConfiguration().getDbId());
            }
            catch (CommandException e) {
                logger.error((Object)"Error while retrieving configuration", (Throwable)e);
                ExceptionUtil.log(e, Messages.ShowBulkEditAction_6);
            }
        }
    }

    private Optional<CnATreeElement> findNonWritableElement(IStructuredSelection selection) {
        for (Object next : selection) {
            if (!(next instanceof CnATreeElement)) continue;
            CnATreeElement element = (CnATreeElement)next;
            boolean writeallowed = CnAElementHome.getInstance().isWriteAllowed(element);
            if (writeallowed) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    private void editPersons(List<Integer> dbIDs, Entity dialogEntity, IProgressMonitor monitor, String newPassword, String newPassword2) throws CommandException {
        monitor.setTaskName(Messages.ShowBulkEditAction_7);
        monitor.beginTask(Messages.ShowBulkEditAction_8, -1);
        boolean changePassword = false;
        if (newPassword != null && !newPassword.isEmpty()) {
            if (!newPassword.equals(newPassword2)) {
                throw new PasswordException(Messages.ConfigurationAction_10);
            }
            changePassword = true;
        }
        ConfigurationBulkEditUpdate command = new ConfigurationBulkEditUpdate(dbIDs, dialogEntity, changePassword, newPassword);
        command = (ConfigurationBulkEditUpdate)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        if (!command.getFailedUpdates().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.ShowBulkEditAction_15).append(":\n");
            for (String username : command.getFailedUpdates()) {
                sb.append(username).append("\n");
            }
            ExceptionUtil.log(new ConfigurationException(Messages.ShowBulkEditAction_16), String.valueOf(Messages.ShowBulkEditAction_16) + "\n" + sb.toString());
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        boolean selectionEmpty = selection.isEmpty();
        if (selectionEmpty || !(selection.getFirstElement() instanceof CnATreeElement)) {
            this.setEnabled(false);
            return;
        }
        String firstElementType = ((CnATreeElement)selection.getFirstElement()).getTypeId();
        if (!SUPPORTED_ELEMENT_TYPES.contains(firstElementType)) {
            this.setEnabled(false);
            return;
        }
        for (Object item : selection.toList()) {
            if (item instanceof CnATreeElement && ((CnATreeElement)item).getTypeId().equals(firstElementType)) continue;
            this.setEnabled(false);
            return;
        }
        if (!this.checkRights()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

