/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.ViewAndWindowAction;
import sernet.gs.ui.rcp.main.bsi.dialogs.AccessControlEditDialog;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Permission;
import sernet.verinice.service.commands.UpdatePermissions;

public class ShowAccessControlEditAction
extends ViewAndWindowAction {
    private static final String ERROR_MESSAGE = "Error while setting access rights.";
    private static final Logger LOG = Logger.getLogger(ShowAccessControlEditAction.class);
    public static final String ID = "sernet.gs.ui.rcp.main.actions.showaccesscontroleditaction";
    private List<CnATreeElement> elements = new ArrayList<CnATreeElement>();
    private Set<Permission> permissionSetAdd;
    private Set<Permission> permissionSetRemove;
    private boolean isOverride;
    private boolean isUpdateChildren;

    private ShowAccessControlEditAction(String label) {
        super("accesscontrol", label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("16-security-lock.png"));
        this.setToolTipText(Messages.ShowAccessControlEditAction_1);
    }

    public ShowAccessControlEditAction(IWorkbenchWindow window, String label) {
        this(label);
        this.setWindow(window);
    }

    public ShowAccessControlEditAction(IViewSite site, String label) {
        this(label);
        this.setSite(site);
    }

    @Override
    protected void doRun(IStructuredSelection structuredSelection) {
        Activator.inheritVeriniceContextState();
        if (structuredSelection == null || structuredSelection.isEmpty()) {
            return;
        }
        AccessControlEditDialog dialog = new AccessControlEditDialog(this.getShell(), structuredSelection);
        if (dialog.open() != 0) {
            return;
        }
        this.elements = dialog.getElements();
        this.permissionSetAdd = dialog.getPermissionSetAdd();
        this.permissionSetRemove = dialog.getPermissionSetRemove();
        this.isOverride = dialog.isOverride();
        this.isUpdateChildren = dialog.isUpdateChildren();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(Messages.ShowAccessControlEditAction_0, -1);
                            Activator.inheritVeriniceContextState();
                            ShowAccessControlEditAction.this.updatePermissions();
                        }
                        catch (CommandException e) {
                            LOG.error((Object)ShowAccessControlEditAction.ERROR_MESSAGE, (Throwable)e);
                            throw new RuntimeException(ShowAccessControlEditAction.ERROR_MESSAGE, e);
                        }
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
            ExceptionUtil.log(e, ERROR_MESSAGE);
        }
    }

    private void updatePermissions() throws CommandException {
        for (CnATreeElement element : this.elements) {
            UpdatePermissions up = new UpdatePermissions(element, this.permissionSetAdd, this.permissionSetRemove, this.isUpdateChildren, this.isOverride);
            ServiceFactory.lookupCommandService().executeCommand((ICommand)up);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        boolean statisfiedConditions;
        boolean bl = statisfiedConditions = selection.getFirstElement() instanceof CnATreeElement && CnAElementHome.getInstance().isOpen();
        if (!statisfiedConditions) {
            this.setEnabled(false);
            return;
        }
        if (!this.checkRights()) {
            this.setEnabled(false);
            return;
        }
        boolean isLocalAdmin = this.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
        if (isLocalAdmin) {
            boolean isWriteAllowed = this.isWriteAllowed((ISelection)selection);
            this.setEnabled(isLocalAdmin && isWriteAllowed);
        } else {
            this.setEnabled(true);
        }
    }

    private boolean isWriteAllowed(ISelection selection) {
        boolean isWriteAllowed = false;
        IStructuredSelection sel = (IStructuredSelection)selection;
        for (Object o : sel) {
            if (!(o instanceof CnATreeElement)) continue;
            CnATreeElement element = (CnATreeElement)o;
            isWriteAllowed = CnAElementHome.getInstance().isWriteAllowed(element);
            if (!isWriteAllowed) break;
        }
        return isWriteAllowed;
    }

    private IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }
}

