/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.IInternalServerStartListener;
import sernet.verinice.interfaces.InternalServerEvent;
import sernet.verinice.interfaces.RightEnabledUserInteraction;

public abstract class RightsEnabledAction
extends Action
implements RightEnabledUserInteraction {
    private final String rightID;
    private boolean serverRunning = true;

    public RightsEnabledAction(String rightID) {
        this.rightID = rightID;
        this.setEnabledViaRightID();
    }

    public RightsEnabledAction(String rightID, String text) {
        super(text);
        this.rightID = rightID;
        this.setEnabledViaRightID();
    }

    public RightsEnabledAction(String rightID, String text, int style) {
        super(text, style);
        this.rightID = rightID;
        this.setEnabledViaRightID();
    }

    public final void run() {
        if (this.checkRights()) {
            this.doRun();
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.RightsEnabledAction_0, (String)Messages.RightsEnabledAction_1);
        }
    }

    public abstract void doRun();

    public final boolean checkRights() {
        if (this.getRightID() == null) {
            return true;
        }
        if (this.getRightID().isEmpty()) {
            return false;
        }
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public final String getRightID() {
        return this.rightID;
    }

    private void setEnabledViaRightID() {
        if (Activator.getDefault().isStandalone() && !Activator.getDefault().getInternalServer().isRunning()) {
            this.serverRunning = false;
            this.addInternalServerStartListener();
        } else {
            this.setEnabled(this.checkRights());
        }
    }

    private void addInternalServerStartListener() {
        IInternalServerStartListener listener = new IInternalServerStartListener(){

            public void statusChanged(InternalServerEvent e) {
                if (e.isStarted()) {
                    RightsEnabledAction.this.serverRunning = true;
                    RightsEnabledAction.this.setEnabled(RightsEnabledAction.this.checkRights());
                }
            }
        };
        Activator.getDefault().getInternalServer().addInternalServerStatusListener(listener);
    }

    public final boolean isServerRunning() {
        return this.serverRunning;
    }
}

