/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.iso27k.ISO27KModel;

public class ReloadAction
extends Action {
    public static final String ID = "sernet.gs.ui.rcp.main.reloadaction";

    public ReloadAction(IWorkbenchWindow window, String label) {
        this.setText(label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("arrow_refresh.png"));
        this.setEnabled(false);
        CnAElementFactory.getInstance().addLoadListener(new IModelLoadListener(){

            @Override
            public void closed(BSIModel model) {
                ReloadAction.this.setEnabled(false);
            }

            @Override
            public void loaded(BSIModel model) {
                ReloadAction.this.setEnabled(true);
            }

            @Override
            public void loaded(ISO27KModel model) {
                ReloadAction.this.setEnabled(true);
            }

            @Override
            public void loaded(BpModel model) {
                ReloadAction.this.setEnabled(true);
            }

            @Override
            public void loaded(CatalogModel model) {
            }
        });
    }

    public void run() {
        Activator.inheritVeriniceContextState();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(Messages.ReloadAction_2, -1);
                            CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                        }
                        catch (Exception e) {
                            ExceptionUtil.log(e, Messages.ReloadAction_1);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            progressService.run(true, true, operation);
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.log(e, Messages.ReloadAction_1);
        }
        catch (InterruptedException e) {
            ExceptionUtil.log(e, Messages.ReloadAction_1);
        }
    }
}

