/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;

public class OpenViewAction
extends RightsEnabledAction {
    private final IWorkbenchWindow window;
    private final String viewId;

    public OpenViewAction(IWorkbenchWindow window, String label, String viewId, String imageDesc) {
        this(window, label, viewId, imageDesc, null);
    }

    public OpenViewAction(IWorkbenchWindow window, String label, String viewId, String imageDesc, String rightID) {
        super(rightID, label);
        this.window = window;
        this.viewId = viewId;
        this.setId("ACTION_" + viewId);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor(imageDesc));
    }

    @Override
    public void doRun() {
        if (this.window != null) {
            try {
                this.window.getActivePage().showView(this.viewId);
            }
            catch (PartInitException e) {
                ExceptionUtil.log(e, Messages.OpenMultipleViewAction_2);
            }
        }
    }
}

