/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.OpenMultipleViewAction;
import sernet.gs.ui.rcp.main.service.ServiceFactory;

public class OpenSearchViewAction
extends OpenMultipleViewAction {
    private final IWorkbenchWindow window;
    private final String viewId;
    private int instance = 0;

    public OpenSearchViewAction(IWorkbenchWindow window, String label) {
        super(window, label, "sernet.verinice.rcp.search.SearchView", "search.png", "searchview");
        this.window = window;
        this.viewId = "sernet.verinice.rcp.search.SearchView";
        this.syncEnabledWithPreference();
    }

    @Override
    public void doRun() {
        this.syncEnabledWithPreference();
        if (this.window != null) {
            try {
                this.window.getActivePage().showView(this.viewId, String.valueOf(this.instance++), 1);
            }
            catch (PartInitException e) {
                ExceptionUtil.log(e, Messages.OpenMultipleViewAction_2);
            }
        }
    }

    private void syncEnabledWithPreference() {
        if (Activator.getDefault().isStandalone()) {
            this.syncEnabledStandalone();
        } else {
            this.syncEnabledServer();
        }
    }

    private void syncEnabledServer() {
        try {
            int searchServiceImplementation = ServiceFactory.lookupSearchService().getImplementationtype();
            if (searchServiceImplementation == 0) {
                this.setEnabled(false);
            } else if (this.checkRights() && 1 == searchServiceImplementation) {
                this.setEnabled(true);
            }
        }
        catch (Exception e) {
            Logger.getLogger(OpenSearchViewAction.class).error((Object)"Can't connect to searchService, disabling searchView", (Throwable)e);
            this.setEnabled(false);
        }
    }

    private void syncEnabledStandalone() {
        DisableSearchActionListener listener = new DisableSearchActionListener(this);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)listener);
        this.addPropertyChangeListener(listener);
        this.setEnabled(!Activator.getDefault().getPreferenceStore().getBoolean("search_disable"));
    }

    private final class DisableSearchActionListener
    implements IPropertyChangeListener {
        final OpenSearchViewAction action;

        public DisableSearchActionListener(OpenSearchViewAction action) {
            this.action = action;
        }

        public void propertyChange(PropertyChangeEvent event) {
            boolean disabled = Activator.getDefault().getPreferenceStore().getBoolean("search_disable");
            if ("search_disable".equals(event.getProperty())) {
                if (OpenSearchViewAction.this.checkRights() && disabled) {
                    this.action.setEnabled(false);
                } else if (OpenSearchViewAction.this.checkRights() && !disabled) {
                    this.action.setEnabled(true);
                }
            }
        }
    }
}

