/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.gsimport.IProgress;
import sernet.gs.ui.rcp.gsimport.ImportNotesTask;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;

public class ImportGstoolNotesAction
extends RightsEnabledAction {
    public static final String ID = "sernet.gs.ui.rcp.main.importgstoolnotesaction";
    private final IWorkbenchWindow window;

    public ImportGstoolNotesAction(IWorkbenchWindow window, String label) {
        super("gsnotesimport", label);
        this.window = window;
        this.setId(ID);
        this.setEnabled(true);
    }

    @Override
    public void doRun() {
        try {
            boolean confirm = MessageDialog.openConfirm((Shell)this.window.getShell(), (String)Messages.ImportGstoolNotesAction_0, (String)Messages.ImportGstoolNotesAction_1);
            if (!confirm) {
                return;
            }
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    ImportNotesTask importTask = new ImportNotesTask();
                    try {
                        importTask.execute(1, new IProgress(){

                            @Override
                            public void done() {
                                monitor.done();
                            }

                            @Override
                            public void worked(int work) {
                                monitor.worked(work);
                            }

                            @Override
                            public void beginTask(String name, int totalWork) {
                                monitor.beginTask(name, totalWork);
                            }

                            @Override
                            public void subTask(String name) {
                                monitor.subTask(name);
                            }
                        });
                    }
                    catch (Exception e) {
                        ExceptionUtil.log(e, "Fehler beim Importieren.");
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.log(e.getCause(), "Notiz-Import aus dem Gstool fehlgeschlagen.");
        }
        catch (InterruptedException e) {
            ExceptionUtil.log(e, "Notiz-Import aus dem Gstool fehlgeschlagen.");
        }
    }
}

