/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.service.TimeFormatter;
import sernet.gs.ui.rcp.gsimport.GstoolImportCanceledException;
import sernet.gs.ui.rcp.gsimport.IProgress;
import sernet.gs.ui.rcp.gsimport.ImportNotesTask;
import sernet.gs.ui.rcp.gsimport.ImportRisikoanalysenTask;
import sernet.gs.ui.rcp.gsimport.ImportTask;
import sernet.gs.ui.rcp.gsimport.ValidateTask;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.dialogs.GSImportDialog;

public class ImportGstoolAction
extends RightsEnabledAction {
    private static final Logger LOG = Logger.getLogger(ImportGstoolAction.class);
    public static final String ID = "sernet.gs.ui.rcp.main.importgstoolaction";
    private GSImportDialog dialog;
    private Shell shell;
    private String sourceId;

    public ImportGstoolAction(IWorkbenchWindow window, String label) {
        super("gstoolimport", label);
        this.setId(ID);
        this.setEnabled(true);
    }

    @Override
    public void doRun() {
        try {
            this.shell = Display.getCurrent().getActiveShell();
            this.dialog = new GSImportDialog(this.shell);
            if (this.dialog.open() != 0) {
                return;
            }
            this.validateNonBlocking();
            this.importZielobjekteNonBlocking();
            if (this.dialog.isNotizen()) {
                this.importNotesNonBlocking();
            }
            if (this.dialog.isRisikoanalysen()) {
                this.importRiskAnalysesNonBlocking();
            }
        }
        catch (InvocationTargetException e) {
            this.handleInvocationTargetException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void validate(IProgressMonitor monitor) {
        Activator.inheritVeriniceContextState();
        ValidateTask validateTask = new ValidateTask(this.shell);
        long taskStart = System.currentTimeMillis();
        validateTask.execute(1, new EclipseProgressMonitorDelegator(monitor));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time for validating:\t" + TimeFormatter.getHumanRedableTime((long)(System.currentTimeMillis() - taskStart))));
        }
    }

    private void importZielobjekte(IProgressMonitor monitor) {
        Activator.inheritVeriniceContextState();
        ImportTask importTask = new ImportTask(this.dialog.isBausteine(), this.dialog.isMassnahmenPersonen(), this.dialog.isZielObjekteZielobjekte(), this.dialog.isSchutzbedarf(), this.dialog.isRollen(), this.dialog.isKosten(), this.dialog.isUmsetzung(), this.dialog.isBausteinPersonen());
        long importTaskStart = System.currentTimeMillis();
        importTask.execute(1, new EclipseProgressMonitorDelegator(monitor));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time for ImportTask:\t" + String.valueOf((System.currentTimeMillis() - importTaskStart) / 1000L) + " seconds"));
        }
        this.sourceId = importTask.getSourceId();
    }

    private void importNotes(IProgressMonitor monitor) {
        Activator.inheritVeriniceContextState();
        long importNotesStart = System.currentTimeMillis();
        ImportNotesTask importTask = new ImportNotesTask();
        importTask.execute(1, new EclipseProgressMonitorDelegator(monitor));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time for ImportNotesTask:\t" + String.valueOf((System.currentTimeMillis() - importNotesStart) / 1000L) + " seconds"));
        }
    }

    private void importRiskAnalyses(IProgressMonitor monitor) {
        Activator.inheritVeriniceContextState();
        long importRAStart = System.currentTimeMillis();
        ImportRisikoanalysenTask importTask = new ImportRisikoanalysenTask(this.sourceId);
        importTask.execute(1, new EclipseProgressMonitorDelegator(monitor));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time for ImportRATask:\t" + String.valueOf((System.currentTimeMillis() - importRAStart) / 1000L) + " seconds"));
        }
    }

    private void handleInvocationTargetException(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof GstoolImportCanceledException) {
            LOG.warn((Object)"Import from GSTOOL was canceled, cause: ", cause);
        } else if (cause != null) {
            this.handleException(cause);
        } else {
            this.handleException(e);
        }
    }

    private void handleException(Throwable cause) {
        ExceptionUtil.log(cause, "Import aus dem Gstool fehlgeschlagen.");
    }

    private void validateNonBlocking() throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ImportGstoolAction.this.validate(monitor);
            }
        });
    }

    private void importZielobjekteNonBlocking() throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ImportGstoolAction.this.importZielobjekte(monitor);
            }
        });
    }

    private void importNotesNonBlocking() throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ImportGstoolAction.this.importNotes(monitor);
            }
        });
    }

    private void importRiskAnalysesNonBlocking() throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ImportGstoolAction.this.importRiskAnalyses(monitor);
            }
        });
    }

    private final class EclipseProgressMonitorDelegator
    implements IProgress {
        private final IProgressMonitor monitor;

        private EclipseProgressMonitorDelegator(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void done() {
            this.monitor.done();
        }

        @Override
        public void worked(int work) {
            this.monitor.worked(work);
        }

        @Override
        public void beginTask(String name, int totalWork) {
            this.monitor.beginTask(name, totalWork);
        }

        @Override
        public void subTask(String name) {
            this.monitor.subTask(name);
        }
    }
}

