/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import de.sernet.sync.sync.SyncRequest;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.wiring.BundleWiring;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.wizards.ImportCSVWizard;
import sernet.gs.ui.rcp.main.bsi.wizards.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Domain;
import sernet.verinice.service.commands.CnATypeMapper;
import sernet.verinice.service.commands.SyncCommand;
import sernet.verinice.service.commands.SyncParameter;
import sernet.verinice.service.commands.SyncParameterException;

public class ImportCSVAction
extends RightsEnabledAction {
    private static final Logger LOG = Logger.getLogger(ImportCSVAction.class);
    public static final String ID = "sernet.gs.ui.rcp.main.importcsvaction";
    private SyncRequest sr = null;
    private boolean insert;
    private boolean update;
    private boolean delete;
    private String entityType;

    public ImportCSVAction(String label) {
        super("importcsv", label);
        this.setId(ID);
    }

    @Override
    public void doRun() {
        ImportCSVWizard wizard = new ImportCSVWizard();
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        int resultFromWizardDialog = wizardDialog.open();
        if (resultFromWizardDialog == 1) {
            return;
        }
        this.sr = wizard.getSyncRequest();
        this.insert = wizard.getInsertState();
        this.update = wizard.getUpdateState();
        this.delete = wizard.getDeleteState();
        this.entityType = wizard.getEntityType();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.ImportCSVAction_1, -1);
                        Activator.inheritVeriniceContextState();
                        try {
                            ImportCSVAction.this.doImport();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while importing CSV data.", (Throwable)e);
                            throw new RuntimeException("Error while importing CSV data.", e);
                        }
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Error while importing CSV data.", (Throwable)e);
            ExceptionUtil.log(e, Messages.ImportCSVWizard_1);
        }
    }

    protected void doImport() throws CommandException, SyncParameterException, JAXBException {
        ClassLoader classLoader = ((BundleWiring)Activator.getDefault().getBundle().adapt(BundleWiring.class)).getClassLoader();
        JAXBContext context = JAXBContext.newInstance((String)SyncRequest.class.getPackage().getName(), (ClassLoader)classLoader);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        context.createMarshaller().marshal((Object)this.sr, (OutputStream)bos);
        SyncCommand command = new SyncCommand(new SyncParameter(this.insert, this.update, this.delete, false, SyncParameter.EXPORT_FORMAT_XML_PURE), bos.toByteArray());
        command = (SyncCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        Set importedElementUUIDs = command.getImportedElementUUIDs();
        Set importRootObjectUUIDs = command.getImportRootObjectUUIDs();
        Set<CnATreeElement> importRootObjectSet = CnAElementHome.getInstance().loadElementsByUUID(importRootObjectUUIDs, new RetrieveInfo().setParent(true).setChildren(true));
        Set<CnATreeElement> changedElements = CnAElementHome.getInstance().loadElementsByUUID(importedElementUUIDs, new RetrieveInfo().setProperties(true).setParent(true).setChildren(true));
        if (command.getDeleted() != 0) {
            Domain domain = CnATypeMapper.getDomainFromTypeId((String)this.entityType);
            switch (domain) {
                case BASE_PROTECTION_OLD: {
                    CnAElementFactory.getInstance().reloadBsiModelFromDatabase();
                    break;
                }
                case BASE_PROTECTION: {
                    CnAElementFactory.getInstance().reloadBpModelFromDatabase();
                    break;
                }
                case ISM: {
                    CnAElementFactory.getInstance().reloadIsoModelFromDatabase();
                    break;
                }
                default: {
                    LOG.error((Object)("Unsupported domain " + domain + ", reloading all models"));
                    CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                    break;
                }
            }
        } else {
            this.updateModels(importRootObjectSet, changedElements);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("use_automatic_validation")) {
            this.createValidations(changedElements);
        }
    }

    private void updateModels(Set<CnATreeElement> importRootObjectSet, Set<CnATreeElement> changedElements) {
        block4: {
            block3: {
                if (importRootObjectSet == null || importRootObjectSet.isEmpty()) break block3;
                for (CnATreeElement importRootObject : importRootObjectSet) {
                    CnAElementFactory.getModel(importRootObject).childAdded(importRootObject.getParent(), importRootObject);
                    CnAElementFactory.getModel(importRootObject).databaseChildAdded(importRootObject);
                    if (changedElements == null) continue;
                    for (CnATreeElement cnATreeElement : changedElements) {
                        CnAElementFactory.getModel(cnATreeElement).childAdded(cnATreeElement.getParent(), cnATreeElement);
                        CnAElementFactory.getModel(cnATreeElement).databaseChildAdded(cnATreeElement);
                    }
                }
                break block4;
            }
            if (changedElements == null) break block4;
            for (CnATreeElement cnATreeElement : changedElements) {
                CnAElementFactory.getModel(cnATreeElement).childChanged(cnATreeElement);
                CnAElementFactory.getModel(cnATreeElement).databaseChildChanged(cnATreeElement);
            }
        }
    }

    private void createValidations(Set<CnATreeElement> elmts) {
        for (CnATreeElement elmt : elmts) {
            ServiceFactory.lookupValidationService().createValidationForSingleElement(elmt);
        }
        if (!elmts.isEmpty()) {
            CnAElementFactory.getModel((CnATreeElement)elmts.toArray()[0]).validationAdded(((CnATreeElement)elmts.toArray()[0]).getScopeId());
        }
    }
}

