/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.Server;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.task.GSMKonsolidatorCommand;

public class GSMBasicSecurityCheckAction
extends RightsEnabledAction
implements ISelectionListener {
    public static final String ID = "sernet.gs.ui.rcp.main.actions.gsmbasicsecuritycheckaction";
    private static final Logger LOG = Logger.getLogger(GSMBasicSecurityCheckAction.class);
    private final IWorkbenchWindow window;
    private String gsmresult = "GSM Result";

    public GSMBasicSecurityCheckAction(IWorkbenchWindow window, String label) {
        super("konsolidator", label);
        this.window = window;
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("konsolidator.png"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.setToolTipText(Messages.GSMBasicSecurityCheckAction_1);
    }

    @Override
    public void doRun() {
        try {
            this.runSecurityCheck();
            CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while security check.", (Throwable)e);
            ExceptionUtil.log(e, Messages.GSMBasicSecurityCheckAction_6);
        }
    }

    public void runSecurityCheck() {
        Activator.inheritVeriniceContextState();
        final IStructuredSelection selection = (IStructuredSelection)this.window.getSelectionService().getSelection("sernet.gs.ui.rcp.main.views.bsimodelview");
        if (selection == null) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    for (Object o : selection) {
                        if (!(o instanceof Server)) continue;
                        Server serverelement = (Server)o;
                        monitor.beginTask(Messages.GSMBasicSecurityCheckAction_2, -1);
                        GSMBasicSecurityCheckAction.this.konsolidiereModule(serverelement);
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException e) {
            ExceptionUtil.log(e, Messages.GSMBasicSecurityCheckAction_5);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while security check", (Throwable)e);
            ExceptionUtil.log(e, Messages.GSMBasicSecurityCheckAction_6);
        }
    }

    private void konsolidiereModule(Server serverelement) {
        ArrayList<Server> selectedServers = new ArrayList<Server>();
        ArrayList<BausteinUmsetzung> bausteine = new ArrayList<BausteinUmsetzung>();
        BausteinUmsetzung source = null;
        BausteinUmsetzung baustein = null;
        RetrieveInfo ris = RetrieveInfo.getChildrenInstance().setChildrenProperties(true).setParent(true);
        serverelement = (Server)Retriever.retrieveElement((CnATreeElement)serverelement, (RetrieveInfo)ris);
        selectedServers.add(serverelement);
        try {
            for (CnATreeElement bausteineLst : serverelement.getChildren()) {
                baustein = (BausteinUmsetzung)bausteineLst;
                bausteine.add(baustein);
                String gsmname = baustein.getTitle().trim();
                if (!gsmname.equals(this.gsmresult)) continue;
                source = baustein;
            }
            if (source != null) {
                this.konsolidiereMassnahmen(bausteine, source);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while security check", (Throwable)e);
            ExceptionUtil.log(e, Messages.GSMBasicSecurityCheckAction_6);
        }
    }

    private void konsolidiereMassnahmen(List<BausteinUmsetzung> bausteine, BausteinUmsetzung source) {
        try {
            GSMKonsolidatorCommand command = new GSMKonsolidatorCommand(bausteine, source);
            if (source == null) {
                this.showInfoMessage();
            }
            ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.GSMBasicSecurityCheckAction_4);
        }
    }

    private void showInfoMessage() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)GSMBasicSecurityCheckAction.this.window.getShell(), (String)"Info", (String)Messages.GSMBasicSecurityCheckAction_7);
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection input) {
        if (this.isServerRunning()) {
            this.setEnabled(this.checkRights());
            if (input instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)input;
                for (Object serverelement : selection) {
                    if (serverelement instanceof Server) continue;
                    this.setEnabled(false);
                    return;
                }
                if (this.checkRights()) {
                    this.setEnabled(true);
                }
                return;
            }
            this.setEnabled(false);
        }
    }
}

