/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.helper.UpdateConfigurationHelper;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IRightsServiceClient;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.NonModalWizardDialog;
import sernet.verinice.rcp.account.AccountWizard;
import sernet.verinice.service.commands.LoadConfiguration;

public class ConfigurationAction
extends Action
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    static final Logger LOG = Logger.getLogger(ConfigurationAction.class);
    public static final String ID = "sernet.gs.ui.rcp.main.personconfiguration";
    Configuration configuration;
    private ICommandService commandService;
    private IRightsServiceClient rightsService;

    public ConfigurationAction() {
    }

    public ConfigurationAction(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run() {
        if (!this.checkRights()) {
            this.configuration = null;
            return;
        }
        Activator.inheritVeriniceContextState();
        if (this.configuration == null) {
            this.loadConfiguration();
        }
        if (this.configuration == null) {
            return;
        }
        TitleAreaDialog dialog = this.createWizard();
        if (dialog.open() != 0) {
            this.configuration = null;
            return;
        }
        try {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new UpdateConfigurationHelper(this.configuration));
            }
            catch (Exception e) {
                LOG.error((Object)"Error while saving configuration.", (Throwable)e);
                ExceptionUtil.log(e, Messages.ConfigurationAction_5);
                this.configuration = null;
            }
        }
        finally {
            this.configuration = null;
        }
    }

    private TitleAreaDialog createWizard() {
        AccountWizard wizard = new AccountWizard(this.configuration);
        NonModalWizardDialog wizardDialog = new NonModalWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        return wizardDialog;
    }

    public void run(IAction action) {
        this.run();
    }

    private void loadConfiguration() {
        IWorkbenchWindow window1 = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IStructuredSelection selection = (IStructuredSelection)window1.getSelectionService().getSelection();
        if (selection == null) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof CnATreeElement)) continue;
                CnATreeElement person = (CnATreeElement)o;
                LOG.debug((Object)("Loading configuration for user " + person.getTitle()));
                LoadConfiguration command = new LoadConfiguration(person);
                command = (LoadConfiguration)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                this.configuration = command.getConfiguration();
                if (this.configuration != null) continue;
                this.configuration = Configuration.createDefaultAccount();
                this.configuration.setPerson(person);
            }
            catch (CommandException e) {
                ExceptionUtil.log(e, Messages.ConfigurationAction_2);
            }
            catch (RuntimeException e) {
                ExceptionUtil.log(e, Messages.ConfigurationAction_3);
            }
        }
    }

    public IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (action.isEnabled()) {
            boolean b = CnAElementHome.getInstance().isOpen() && ServiceFactory.isPermissionHandlingNeeded();
            action.setEnabled(b && this.checkRights());
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public boolean checkRights() {
        return ((RightsServiceClient)VeriniceContext.get((String)"rightsService")).isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "accountsettings";
    }

    IRightsServiceClient getRightService() {
        if (this.rightsService == null) {
            this.rightsService = (IRightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }
}

