/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.bsi.dialogs.PasswordDialog;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.service.auth.AuthenticationHelper;
import sernet.verinice.service.commands.crud.ChangeOwnPassword;

public class ChangeOwnPasswordAction
extends Action {
    public static final String ID = "sernet.gs.ui.rcp.main.actions.changeownpasswordaction";
    private final IWorkbenchWindow window;

    public ChangeOwnPasswordAction(IWorkbenchWindow window, String label) {
        this.window = window;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("user_suit.png"));
        this.setToolTipText(Messages.ChangeOwnPasswordAction_0);
        this.setEnabled(!Activator.getDefault().isStandalone());
    }

    public void run() {
        ServiceFactory.lookupAuthService();
        if (!ServiceFactory.isPermissionHandlingNeeded()) {
            this.setEnabled(false);
            return;
        }
        boolean isAdmin = AuthenticationHelper.getInstance().currentUserHasRole(new String[]{"ROLE_ADMIN"});
        if (isAdmin) {
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)Messages.ChangeOwnPasswordAction_1, (String)Messages.ChangeOwnPasswordAction_2);
            return;
        }
        Activator.inheritVeriniceContextState();
        PasswordDialog passwordDialog = new PasswordDialog(this.window.getShell());
        if (passwordDialog.open() == 0) {
            ChangeOwnPassword command = new ChangeOwnPassword(passwordDialog.getPassword());
            try {
                ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            }
            catch (CommandException e) {
                ExceptionUtil.log(e, Messages.ChangeOwnPasswordAction_3);
            }
        }
    }
}

