/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.actions;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.service.commands.AssignResponsiblePersonCommand;

public class AssignResponsiblePersonAction
extends RightsEnabledAction
implements ISelectionListener {
    public static final String ID = "sernet.gs.ui.rcp.main.actions.assignresponsiblepersonaction";
    private static final Logger LOG = Logger.getLogger(AssignResponsiblePersonAction.class);
    private final IWorkbenchWindow window;
    private static final String DEFAULT_ERR_MSG = "Error while creating relation.";

    public AssignResponsiblePersonAction(IWorkbenchWindow window, String label) {
        super("relations", label);
        this.window = window;
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("user_suit.png"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.setToolTipText("");
    }

    @Override
    public void doRun() {
        Activator.inheritVeriniceContextState();
        final IStructuredSelection selection = (IStructuredSelection)this.window.getSelectionService().getSelection("sernet.gs.ui.rcp.main.views.bsimodelview");
        if (selection == null) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Activator.inheritVeriniceContextState();
                        AssignResponsiblePersonCommand command = new AssignResponsiblePersonCommand(selection.toList());
                        command = (AssignResponsiblePersonCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        if (command.getchanedElements().size() > 0) {
                            AssignResponsiblePersonAction.this.showInfoMessage(command.getchanedElements().size(), selection.toList().size());
                        } else {
                            AssignResponsiblePersonAction.this.showMessage();
                        }
                        if (command.getlinkedElements().size() > 0) {
                            AssignResponsiblePersonAction.this.showAnotherInfoMessage(command.getlinkedElements().size());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while command", (Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)DEFAULT_ERR_MSG, (Throwable)e);
        }
    }

    private void showInfoMessage(final Integer differenz, final Integer summe) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)AssignResponsiblePersonAction.this.window.getShell(), (String)"Info", (String)NLS.bind((String)Messages.AssignResponsiblePersonAction_1, (Object)differenz, (Object)summe));
            }
        });
    }

    private void showAnotherInfoMessage(final Integer anzahl) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)AssignResponsiblePersonAction.this.window.getShell(), (String)"Info", (String)(anzahl + " " + Messages.AssignResponsiblePersonAction_2));
            }
        });
    }

    private void showMessage() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)AssignResponsiblePersonAction.this.window.getShell(), (String)"Info", (String)Messages.AssignResponsiblePersonAction_3);
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection input) {
        if (this.isServerRunning()) {
            this.setEnabled(this.checkRights());
            if (input instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)input;
                for (Object element : selection) {
                    if (element instanceof MassnahmenUmsetzung) continue;
                    this.setEnabled(false);
                    return;
                }
                if (this.checkRights()) {
                    this.setEnabled(true);
                }
                return;
            }
            this.setEnabled(false);
        }
    }
}

