/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import sernet.gs.ui.rcp.main.Activator;
import sernet.verinice.model.iso27k.ImportIsoGroup;

public final class ImageCache {
    private static final Logger LOG = Logger.getLogger(ImageCache.class);
    public static final String ICON_DIRECTORY = "icons/";
    public static final String UNKNOWN = "generic_element.gif";
    public static final String UNKNOW_NEW = "generic_element_new.png";
    public static final String UNKNOWN_GROUP = "generic_elements.gif";
    public static final String PLUS = "plus.png";
    public static final String MINUS = "minus.png";
    public static final String UNKNOWN_GROUP_NEW = "generic_elements_new.png";
    public static final String PRODUCT_LG = "product_lg.gif";
    public static final String GEBAEUDE = "building.png";
    public static final String RAUM = "door_open.png";
    public static final String PERSON = "user_suit.png";
    public static final String SERVER = "server_database.png";
    public static final String TELEFON = "phone.png";
    public static final String NETWORK = "drive_network.png";
    public static final String SHIELD = "shield.png";
    public static final String TOOL = "24-tool-a.png";
    public static final String GROUP_ADD = "group_add.png";
    public static final String GROUP_EDIT = "group_edit.png";
    public static final String GROUP_DEL = "group_delete.png";
    public static final String EXPORT_ICON = "export.gif";
    public static final String WRENCH = "wrench.png";
    public static final String EXPLORER = "tree_explorer.gif";
    public static final String ARROW_IN = "arrow_in.png";
    public static final String ARROW_OUT = "arrow_out.png";
    public static final String COPY = "copy.png";
    public static final String BAUSTEIN_UMSETZUNG = "16-cube-blue.png";
    public static final String BAUSTEIN_UMSETZUNG_A = "baustein_a.png";
    public static final String BAUSTEIN_UMSETZUNG_B = "baustein_b.png";
    public static final String BAUSTEIN_UMSETZUNG_C = "baustein_c.png";
    public static final String MASSNAHMEN_UMSETZUNG_UNBEARBEITET = "exclamation.png";
    public static final String MASSNAHMEN_UMSETZUNG_NEIN = "16-em-cross.png";
    public static final String MASSNAHMEN_UMSETZUNG_JA = "16-em-check.png";
    public static final String MASSNAHMEN_UMSETZUNG_ENTBEHRLICH = "progress_rem.gif";
    public static final String MASSNAHMEN_UMSETZUNG_TEILWEISE = "16-clock.png";
    public static final String RISIKO_MASSNAHMEN_UMSETZUNG = "16-message-warn.png";
    public static final String BAUSTEIN = "16-cube-blue.png";
    public static final String STUFE_NONE = "stufe_none.png";
    public static final String STUFE_A = "stufe_a.png";
    public static final String STUFE_B = "stufe_b.png";
    public static final String STUFE_C = "stufe_c.png";
    public static final String STUFE_Z = "stufe_z.png";
    public static final String STUFE_W = "stufe_w.png";
    public static final String ANWENDUNG = "application_osx.png";
    public static final String CLIENT = "computer.png";
    public static final String FILTER = "filter_tsk.gif";
    public static final String FILTER_ACTIVE = "filter_tsk_active.gif";
    public static final String REPORT = "report.png";
    public static final String VIEW_BROWSER = "tag.png";
    public static final String VIEW_MASSNAHMEN = "gs.png";
    public static final String VIEW_BSIMODEL = "tree_explorer.gif";
    public static final String VIEW_ISMVIEW = "sweetie-verinice/png/16-arrow-branch-bgr.png";
    public static final String VIEW_TODO = "24-em-check.png";
    public static final String VIEW_AUDIT = "pruefplan-toolbar.png";
    public static final String VIEW_NOTE = "note.png";
    public static final String VIEW_TASK = "tasks.gif";
    public static final String VIEW_TASK_COMPARE_CHANGES = "history_rep.gif";
    public static final String VIEW_VALIDATION = "quickfix_warning_obj.gif";
    public static final String VIEW_GSMAPPING = "plugin_depend.gif";
    public static final String VIEW_BASE_PROTECTION = "base-protection/base_protection_view.png";
    public static final String VIEW_CATALOG = "catalog-view.png";
    public static final String EXPANDALL = "expandall.gif";
    public static final String COLLAPSEALL = "collapseall.gif";
    public static final String OPEN_EDIT = "edtsrclkup_co.gif";
    public static final String CASCADE = "application_cascade.png";
    public static final String ACCOUNTS_BULK = "accounts_bulk.png";
    public static final String SECURITY = "16-security-lock.png";
    public static final String KONSOLIDATOR = "konsolidator.png";
    public static final String GEFAEHRDUNG = "dialog-warning.png";
    public static final String SONSTIT = "sonstit.png";
    public static final String LINKS = "link.png";
    public static final String CHART_PIE = "chart_pie.png";
    public static final String CHART_BAR = "chart_bar.png";
    public static final String CHART_CURVE = "chart_curve.png";
    public static final String VIEW_DOCUMENT = "script.png";
    public static final String AUTOBAUSTEIN = "autobaustein.png";
    public static final String RELOAD = "arrow_refresh.png";
    public static final String LINK_DOWN = "link_down.png";
    public static final String LINK_UP = "link_up.png";
    public static final String NOTE = "note.png";
    public static final String NOTE_NEW = "note-new.png";
    public static final String DELETE = "delete.png";
    public static final String EDIT = "edit.png";
    public static final String SAVE = "save.png";
    public static final String ATTACH = "attach.png";
    public static final String VIEW = "view.png";
    public static final String MIME_ARCHIVE = "mime-archive.png";
    public static final String MIME_AUDIO = "mime-audio.png";
    public static final String MIME_DOCUMENT = "mime-document.png";
    public static final String MIME_HTML = "mime-html.png";
    public static final String MIME_PDF = "mime-pdf.png";
    public static final String MIME_PRESENTATION = "mime-presentation.png";
    public static final String MIME_SPREADSHEET = "mime-spreadsheet.png";
    public static final String MIME_TEXT = "mime-text.png";
    public static final String MIME_UNKNOWN = "mime-unknown.png";
    public static final String MIME_VIDEO = "mime-video.png";
    public static final String MIME_XML = "mime-xml.png";
    public static final String MIME_IMAGE = "mime-image.png";
    public static final String GROUP_VIEW = "group.png";
    public static final String LINKED = "linked.gif";
    public static final String UNLINKED = "unlinked.gif";
    public static final String LOAD_MORE = "load-more.gif";
    public static final String UNKNOWN_FILE_TYPE = "question.gif";
    public static final String PRIORITY_LOW = "priority-4.gif";
    public static final String PRIORITY_NORMAL = "priority-2.gif";
    public static final String PRIORITY_HIGH = "priority-1.gif";
    public static final String SEARCH = "search.png";
    public static final String VLT = "document-table.png";
    public static final String CONVERT = "convert.png";
    public static final String ISO27K_ASSET = "sweetie-verinice/png/16-asset-grey.png";
    public static final String ISO27K_ASSETGROUP = "sweetie-verinice/png/assetgroup.png";
    public static final String ISO27K_THREAT = "sweetie-verinice/png/16-lightening.png";
    public static final String ISO27K_VULNERABILITY = "sweetie-verinice/png/16-shield-blue-broken.png";
    public static final String ISO27K_INCIDENT_SCENARIO = "dialog-warning.png";
    public static final String ISO27K_INCIDENT = "sweetie-verinice/png/16-arrow-incident-red.png";
    public static final String ISO27K_REQUIREMENT = "sweetie-verinice/png/16-paper-gavel-alt.png";
    public static final String ISO27K_EXCEPTION = "sweetie-verinice/png/16-paper-excerpt-yellow.png";
    public static final String ISO27K_AUDIT = "sweetie-verinice/png/16-clipboard-audit.png";
    public static final String ISO27K_AUDITGROUP = "sweetie-verinice/png/auditgroup.png";
    public static final String ISO27K_INTERVIEW = "sweetie-verinice/png/16-clipboard-comment.png";
    public static final String ISO27K_IMRPOVEMENT_NOTE = "sweetie-verinice/png/16-clipboard-report-bar.png";
    public static final String ISO27K_EVIDENCE = "sweetie-verinice/png/16-clipboard-eye.png";
    public static final String ISO27K_RESPONSE = "sweetie-verinice/png/16-paper-arrow-green.png";
    public static final String ISO27K_DOCUMENT = "mime-document.png";
    public static final String ISO27K_RECORD = "mime-text.png";
    public static final String ISO27K_SCOPE = "tree_explorer.gif";
    public static final String ISO27K_PERSON = "user_suit.png";
    public static final String ISO27K_FOLDER = "folder.png";
    public static final String ISO27K_PROCESS = "sweetie-verinice/png/16-paper-workplan.png";
    public static final String ISO27K_IMPORT = "import.gif";
    public static final String ISO27K_CONTROL = "stufe_none.png";
    public static final String ISO27K_CONTROLGROUP = "sweetie-verinice/png/controlgroup.png";
    public static final String ISO27K_CONTROL_NO = "16-em-cross.png";
    public static final String ISO27K_CONTROL_YES = "16-em-check.png";
    public static final String ISO27K_SAMTTOPIC = "isa-topic.png";
    public static final String ISA_TOPIC = "isa-topic.png";
    public static final String BP_APPLICATION = "base-protection/application.png";
    public static final String BP_PERSON = "base-protection/bp_person.png";
    public static final String BP_REQUIREMENT = "base-protection/bp_requirement.png";
    public static final String BP_THREAT = "base-protection/bp_threat.png";
    public static final String BP_BUSINESS_PROCESS = "base-protection/business_process.png";
    public static final String BP_DEVICE = "base-protection/device.png";
    public static final String BP_ICS_SYSTEM = "base-protection/ics_system.png";
    public static final String BP_IT_NETWORK = "base-protection/it_network.png";
    public static final String BP_IT_SYSTEM = "base-protection/it_system.png";
    public static final String BP_NETWORK = "base-protection/network.png";
    public static final String BP_ROOM = "base-protection/room.png";
    public static final String BP_SAFEGUARD = "base-protection/safeguard.png";
    public static final String REPORT_DEPOSIT = "folder_table.png";
    public static final String ERROR_DECORATOR = "overlays/error_co.gif";
    public static final String ISO27K_RISK = "sweetie-verinice/png/16-paper-calculate-percent.png";
    public static final String NOALIENS = "noaliens.png";
    public static final String USERPROFILE = "userprofile.gif";
    public static final String USERPROFILE_64 = "userprofile_64.png";
    public static final String PROFILE = "profile.png";
    public static final String PROFILE_64 = "profile_64.png";
    public static final String USER_ADD = "user_add.png";
    public static final String USER_DISABLED = "user_disabled.png";
    public static final String OK_DISABLED = "ok-disabled.png";
    public static final String UPDATE_SITE = "update-site.png";
    public static final String CROSS = "16-em-cross.png";
    private static ImageCache instance;
    private static URL imagePath;
    private final Map<ImageDescriptor, Image> imageMap = new HashMap<ImageDescriptor, Image>();
    private static final Map<String, String> TYPE_ID_ICON_MAP;
    private Bundle bundle = Platform.getBundle((String)"sernet.gs.ui.rcp.main");

    static {
        TYPE_ID_ICON_MAP = new HashMap<String, String>();
        TYPE_ID_ICON_MAP.put("org", "tree_explorer.gif");
        TYPE_ID_ICON_MAP.put("asset", ISO27K_ASSET);
        TYPE_ID_ICON_MAP.put("assetgroup", ISO27K_ASSETGROUP);
        TYPE_ID_ICON_MAP.put("threat", ISO27K_THREAT);
        TYPE_ID_ICON_MAP.put("vulnerability", ISO27K_VULNERABILITY);
        TYPE_ID_ICON_MAP.put("incident_scenario", "dialog-warning.png");
        TYPE_ID_ICON_MAP.put("incident", ISO27K_INCIDENT);
        TYPE_ID_ICON_MAP.put("requirement", ISO27K_REQUIREMENT);
        TYPE_ID_ICON_MAP.put("exception", ISO27K_EXCEPTION);
        TYPE_ID_ICON_MAP.put("audit", ISO27K_AUDIT);
        TYPE_ID_ICON_MAP.put("auditgroup", ISO27K_AUDITGROUP);
        TYPE_ID_ICON_MAP.put("interview", ISO27K_INTERVIEW);
        TYPE_ID_ICON_MAP.put("finding", ISO27K_IMRPOVEMENT_NOTE);
        TYPE_ID_ICON_MAP.put("evidence", ISO27K_EVIDENCE);
        TYPE_ID_ICON_MAP.put("document", "mime-document.png");
        TYPE_ID_ICON_MAP.put("person-iso", "user_suit.png");
        TYPE_ID_ICON_MAP.put("control", "stufe_none.png");
        TYPE_ID_ICON_MAP.put("controlgroup", ISO27K_CONTROLGROUP);
        TYPE_ID_ICON_MAP.put("response", ISO27K_RESPONSE);
        TYPE_ID_ICON_MAP.put("process", ISO27K_PROCESS);
        TYPE_ID_ICON_MAP.put("record", "mime-text.png");
        TYPE_ID_ICON_MAP.put("samt_topic", "isa-topic.png");
        TYPE_ID_ICON_MAP.put(ImportIsoGroup.TYPE_ID, ISO27K_IMPORT);
        TYPE_ID_ICON_MAP.put("bp_application", BP_APPLICATION);
        TYPE_ID_ICON_MAP.put("bp_person", BP_PERSON);
        TYPE_ID_ICON_MAP.put("bp_requirement", BP_REQUIREMENT);
        TYPE_ID_ICON_MAP.put("bp_threat", BP_THREAT);
        TYPE_ID_ICON_MAP.put("bp_businessprocess", BP_BUSINESS_PROCESS);
        TYPE_ID_ICON_MAP.put("bp_device", BP_DEVICE);
        TYPE_ID_ICON_MAP.put("bp_icssystem", BP_ICS_SYSTEM);
        TYPE_ID_ICON_MAP.put("bp_itnetwork", BP_IT_NETWORK);
        TYPE_ID_ICON_MAP.put("bp_itsystem", BP_IT_SYSTEM);
        TYPE_ID_ICON_MAP.put("bp_network", BP_NETWORK);
        TYPE_ID_ICON_MAP.put("bp_room", BP_ROOM);
        TYPE_ID_ICON_MAP.put("bp_safeguard", BP_SAFEGUARD);
        TYPE_ID_ICON_MAP.put("bp_document", "mime-document.png");
        TYPE_ID_ICON_MAP.put("bp_incident", ISO27K_INCIDENT);
        TYPE_ID_ICON_MAP.put("bp_record", "mime-text.png");
        TYPE_ID_ICON_MAP.put("bp_import_group", ISO27K_IMPORT);
        TYPE_ID_ICON_MAP.put("itverbund", "tree_explorer.gif");
        TYPE_ID_ICON_MAP.put("anwendung", ANWENDUNG);
        TYPE_ID_ICON_MAP.put("gebaeude", GEBAEUDE);
        TYPE_ID_ICON_MAP.put("client", CLIENT);
        TYPE_ID_ICON_MAP.put("server", SERVER);
        TYPE_ID_ICON_MAP.put("sonstit", SONSTIT);
        TYPE_ID_ICON_MAP.put("tkkomponente", TELEFON);
        TYPE_ID_ICON_MAP.put("person", "user_suit.png");
        TYPE_ID_ICON_MAP.put("netzkomponente", NETWORK);
        TYPE_ID_ICON_MAP.put("raum", RAUM);
        TYPE_ID_ICON_MAP.put("anwendungenkategorie", ANWENDUNG);
        TYPE_ID_ICON_MAP.put("gebaeudekategorie", GEBAEUDE);
        TYPE_ID_ICON_MAP.put("clientskategorie", CLIENT);
        TYPE_ID_ICON_MAP.put("serverkategorie", SERVER);
        TYPE_ID_ICON_MAP.put("sonstitkategorie", SONSTIT);
        TYPE_ID_ICON_MAP.put("tkkategorie", TELEFON);
        TYPE_ID_ICON_MAP.put("personkategorie", "user_suit.png");
        TYPE_ID_ICON_MAP.put("netzkategorie", NETWORK);
        TYPE_ID_ICON_MAP.put("raeumekategorie", RAUM);
        TYPE_ID_ICON_MAP.put("bstumsetzung", "16-cube-blue.png");
        TYPE_ID_ICON_MAP.put("mnums", "stufe_none.png");
    }

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (instance == null) {
            instance = new ImageCache();
            imagePath = Activator.getDefault().getBundle().getEntry(ICON_DIRECTORY);
        }
        return instance;
    }

    public Image getImageForTypeId(String typeId) {
        Image image = this.getImage(UNKNOWN);
        if (typeId != null && TYPE_ID_ICON_MAP.get(typeId) != null) {
            image = this.getImage(TYPE_ID_ICON_MAP.get(typeId));
        }
        return image;
    }

    public String getImageURL(String typeId) {
        if (typeId != null && TYPE_ID_ICON_MAP.get(typeId) != null) {
            return TYPE_ID_ICON_MAP.get(typeId);
        }
        return UNKNOWN;
    }

    public ImageDescriptor getImageDescriptor(String url) {
        ImageDescriptor descriptor;
        try {
            descriptor = ImageDescriptor.createFromURL((URL)new URL(imagePath, url));
        }
        catch (MalformedURLException e) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return descriptor;
    }

    public Image getCustomImage(String url) {
        ImageDescriptor descriptor = null;
        descriptor = new File(url).isAbsolute() ? ImageDescriptor.createFromFile(null, (String)url) : ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)this.bundle, (IPath)new Path(url), null));
        if (descriptor.equals(ImageDescriptor.getMissingImageDescriptor())) {
            LOG.warn((Object)("Image not found: " + url));
            descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)this.bundle, (IPath)new Path(this.getIconPath(UNKNOWN)), null));
        }
        return this.getImage(descriptor);
    }

    public Image getImage(String url) {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)this.bundle, (IPath)new Path(this.getIconPath(url)), null));
        return this.getImage(descriptor);
    }

    private String getIconPath(String url) {
        return ICON_DIRECTORY + url;
    }

    public Image getImage(ImageDescriptor id) {
        if (id == null) {
            return null;
        }
        Image image = this.imageMap.get(id);
        if (image == null) {
            image = this.createImage(id);
        }
        return image;
    }

    private Image createImage(ImageDescriptor id) {
        Image image;
        try {
            image = id.createImage(false);
            if (image == null) {
                image = this.getImage(UNKNOWN);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while creating image: " + e.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Stacktrace: ", (Throwable)e);
            }
            image = this.getImage(UNKNOWN);
        }
        this.imageMap.put(id, image);
        return image;
    }

    public void dispose() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        this.imageMap.clear();
    }

    public Image getControlImplementationImage(String implemented) {
        if ("control_implemented_notedited".equals(implemented)) {
            return this.getImage(MASSNAHMEN_UMSETZUNG_UNBEARBEITET);
        }
        if ("control_implemented_na".equals(implemented)) {
            return this.getImage(MASSNAHMEN_UMSETZUNG_ENTBEHRLICH);
        }
        if ("control_implemented_no".equals(implemented)) {
            return this.getImage("16-em-cross.png");
        }
        if ("control_implemented_partly".equals(implemented)) {
            return this.getImage(MASSNAHMEN_UMSETZUNG_TEILWEISE);
        }
        if ("control_implemented_yes".equals(implemented)) {
            return this.getImage("16-em-check.png");
        }
        return this.getImage(MASSNAHMEN_UMSETZUNG_UNBEARBEITET);
    }

    public boolean hasDefaultImage(String typeID) {
        return TYPE_ID_ICON_MAP.containsKey(typeID);
    }
}

