/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.service.SecurityException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.Messages;
import sernet.verinice.rcp.Preferences;

public final class ExceptionUtil {
    private static final Logger LOG = Logger.getLogger(ExceptionUtil.class);
    private static final String WORKSPACE_PATH_DEFAULT = "<USER_HOME>/verinice/workspace";
    private static final String METADATA_LOG_FILE_PATH_RELATIVE = "/.metadata/.log";
    private static final String CLIENT_LOG_FILE_PATH_RELATIVE = "/log/verinice-client.log";
    private static final String METADATA_LOG_FILE_PATH_DEFAULT = "<USER_HOME>/verinice/workspace/.metadata/.log";
    private static final String CLIENT_LOG_FILE_PATH_DEFAULT = "<USER_HOME>/verinice/workspace/log/verinice-client.log";
    private static final String SERVER_LOG_FILE_PATH_DEFAULT = "/usr/share/tomcat6/logs/verinice-server.log";

    private ExceptionUtil() {
    }

    public static void log(Throwable e, String exceptionTitle) {
        LOG.error((Object)exceptionTitle, e);
        if (e instanceof SecurityException || e.getCause() instanceof SecurityException) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExceptionUtil_2, (String)Messages.ExceptionUtil_3);
                }
            });
            return;
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("cna_errorpopups")) {
            String message = ExceptionUtil.getMessage(exceptionTitle);
            ExceptionUtil.openErrorDialog(Messages.ExceptionUtilErrorPopupTitle, message);
        }
    }

    private static String getMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            exceptionMessage = "";
        }
        String clientLogFilePath = ExceptionUtil.getClientLogFilePath();
        String metadataLogFilePath = ExceptionUtil.getMetadataLogFilePath();
        if (Preferences.isStandalone()) {
            return NLS.bind((String)Messages.ExceptionUtilErrorMessageStandalone, (Object[])new Object[]{exceptionMessage, clientLogFilePath, metadataLogFilePath});
        }
        return NLS.bind((String)Messages.ExceptionUtilErrorMessageServerMode, (Object[])new Object[]{exceptionMessage, clientLogFilePath, metadataLogFilePath, SERVER_LOG_FILE_PATH_DEFAULT});
    }

    public static String getClientLogFilePath() {
        try {
            return ExceptionUtil.getClientLogFilePathNotFailsave();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting client log file path. Returning default path.", (Throwable)e);
            return ExceptionUtil.getClientLogFilePathDefault();
        }
    }

    private static String getClientLogFilePathNotFailsave() {
        String logFileName = ExceptionUtil.getClientLogFilePathDefault();
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender)) continue;
            FileAppender fileAppender = (FileAppender)appender;
            logFileName = fileAppender.getFile();
        }
        return logFileName;
    }

    public static String getClientLogFilePathDefault() {
        return CLIENT_LOG_FILE_PATH_DEFAULT;
    }

    public static String getMetadataLogFilePath() {
        try {
            return ExceptionUtil.getMetadataLogFilePathNotFailsave();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting metadata log file path. Returning default path.", (Throwable)e);
            return ExceptionUtil.getMetadataLogFilePathDefault();
        }
    }

    private static String getMetadataLogFilePathNotFailsave() {
        String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        return workspacePath + METADATA_LOG_FILE_PATH_RELATIVE;
    }

    public static String getMetadataLogFilePathDefault() {
        return METADATA_LOG_FILE_PATH_DEFAULT;
    }

    private static void openErrorDialog(final String exceptionTitle, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)exceptionTitle, (String)message);
            }
        });
    }
}

