/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;
import sernet.gs.ui.rcp.main.Activator;

public final class ConfigurationLogger {
    private static final Logger LOG = Logger.getLogger(ConfigurationLogger.class);
    private static final DateFormat DF = DateFormat.getDateTimeInstance(2, 2);
    public static final String PREF_PROXY_DATA_NODE = "proxyData";
    public static final String ECLIPSE_VMARGS = "eclipse.vmargs";
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    public static final String[] PREFERENCE_BLACKLIST = new String[]{"cna_dbpass", "cna_dbuser", "gs_cna_dbpass", "sa", "gs_cna_dbuser", "gs_cna_serverpass", "gs_cna_serveruser", "sun.java.command"};
    public static List<String> preferenceBlacklist = Arrays.asList(PREFERENCE_BLACKLIST);

    private ConfigurationLogger() {
    }

    public static synchronized void logStart() {
        String[] lines;
        IProduct product = Platform.getProduct();
        String aboutText = product.getProperty("aboutText");
        String application = "verinice";
        if (aboutText != null && (lines = aboutText.split("\\r?\\n")) != null && lines.length > 0) {
            application = lines[0];
        }
        LOG.info((Object)("Starting " + application + ", " + DF.format(System.currentTimeMillis())));
    }

    public static synchronized void logStop() {
        LOG.info((Object)("Application stopped, " + DF.format(System.currentTimeMillis())));
    }

    public static void logSystemProperties() {
        LOG.info((Object)"System properties: ");
        Properties properties = System.getProperties();
        Enumeration<Object> keys = properties.keys();
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            Object object = keys.nextElement();
            if (!(object instanceof String) || preferenceBlacklist.contains(object)) continue;
            keyList.add((String)object);
        }
        Collections.sort(keyList);
        for (String string : keyList) {
            if (ECLIPSE_VMARGS.equals(string)) {
                ConfigurationLogger.logVmArgsExceptD((String)properties.get(string));
                continue;
            }
            LOG.info((Object)(String.valueOf(string) + ": " + properties.get(string)));
        }
    }

    private static void logVmArgsExceptD(String vmArgs) {
        StringTokenizer st = new StringTokenizer(vmArgs, "-");
        while (st.hasMoreTokens()) {
            String prop = st.nextToken();
            if (prop == null || (prop = prop.trim()).toLowerCase().startsWith("d")) continue;
            LOG.info((Object)("-" + prop));
        }
    }

    public static void logApplicationProperties() {
        LOG.info((Object)"Application properties: ");
        org.eclipse.core.runtime.Preferences preferences = Activator.getDefault().getPluginPreferences();
        ConfigurationLogger.logPreferences(preferences);
    }

    public static void logProxyPreferences() {
        IEclipsePreferences rootNode = ConfigurationScope.INSTANCE.getNode("org.eclipse.core.net");
        ConfigurationLogger.logNodeProperties((Preferences)rootNode);
    }

    private static void logNodeProperties(Preferences node) {
        if (node == null) {
            return;
        }
        try {
            LOG.info((Object)(String.valueOf(node.name()) + " properties: "));
            ConfigurationLogger.logProperties(node);
            String[] childrenNames = node.childrenNames();
            int i = 0;
            while (i < childrenNames.length) {
                ConfigurationLogger.logNodeProperties(node.node(childrenNames[i]));
                ++i;
            }
        }
        catch (Exception t) {
            LOG.error((Object)"Error while logging preferences.", (Throwable)t);
        }
    }

    private static void logProperties(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        try {
            List<String> keyList = Arrays.asList(preferences.keys());
            Collections.sort(keyList);
            for (String key : keyList) {
                if (preferenceBlacklist.contains(key)) continue;
                LOG.info((Object)(String.valueOf(key) + ": " + preferences.get(key, "<NO VALUE SET>")));
            }
        }
        catch (Exception t) {
            LOG.error((Object)"Error while logging preferences.", (Throwable)t);
        }
    }

    private static void logPreferences(org.eclipse.core.runtime.Preferences preferences) {
        String[] keyArray = preferences.propertyNames();
        String[] defaultKeyArray = preferences.defaultPropertyNames();
        HashSet<String> keySet = new HashSet<String>();
        int i = 0;
        while (i < defaultKeyArray.length) {
            keySet.add(defaultKeyArray[i]);
            ++i;
        }
        i = 0;
        while (i < keyArray.length) {
            keySet.add(keyArray[i]);
            ++i;
        }
        ArrayList keyList = new ArrayList(keySet);
        Collections.sort(keyList);
        for (String key : keyList) {
            if (preferenceBlacklist.contains(key)) continue;
            String defaultValue = preferences.getDefaultString(key);
            String value = preferences.getString(key);
            if (value == null) {
                value = defaultValue;
            }
            LOG.info((Object)(String.valueOf(key) + ": " + value));
        }
    }
}

