/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import sernet.gs.service.VeriniceCharset;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.Messages;
import sernet.verinice.interfaces.report.IReportService;

public class CnAWorkspace {
    private static final String CONF = "conf";
    private static final Logger LOG = Logger.getLogger(CnAWorkspace.class);
    private static final String OFFICEDIR = "office";
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static File workDir;
    private static final int BUFF_SIZE = 100000;
    private static final byte[] BUFFER;
    public static final Object CONFIG_CURRENT_VERSION;
    protected static final String VERINICEDB = "verinicedb";
    protected static final String TEMPIMPORTDB = "tempGstoolImportDb";
    private static volatile CnAWorkspace instance;
    private final Preferences.IPropertyChangeListener prefChangeListener = event -> {
        if (event.getProperty().equals("gs_cna_dburl") || event.getProperty().equals("gs_cna_dbuser") || event.getProperty().equals("gs_cna_dbpass")) {
            IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
            try {
                String dbUrl = prefs.getString("gs_cna_dburl");
                this.createGstoolImportDatabaseConfig(dbUrl, prefs.getString("gs_cna_dbuser"), prefs.getString("gs_cna_dbpass"));
            }
            catch (Exception e) {
                ExceptionUtil.log(e, Messages.CnAWorkspace_0);
            }
        }
    };
    private File confDir;

    static {
        BUFFER = new byte[100000];
        CONFIG_CURRENT_VERSION = "1.12";
    }

    protected CnAWorkspace() {
    }

    public String createTempImportDbUrl() {
        String tmpDerbyUrl = "jdbc:derby:%s/verinicedb;create=true".replace("%s", CnAWorkspace.getInstance().getWorkdir().getAbsolutePath().replaceAll("\\\\", "/"));
        return tmpDerbyUrl.replace(VERINICEDB, TEMPIMPORTDB);
    }

    public String getTempImportDbDirName() {
        return CnAWorkspace.getInstance().getWorkdir() + File.separator + TEMPIMPORTDB;
    }

    public static synchronized CnAWorkspace getInstance() {
        if (instance == null) {
            instance = new CnAWorkspace();
            Activator.getDefault().getPluginPreferences().addPropertyChangeListener(CnAWorkspace.instance.prefChangeListener);
        }
        return instance;
    }

    public void prepare(boolean force) {
        this.prepareWorkDir();
        if (!force && this.confDir.exists() && this.confDir.isDirectory()) {
            this.createConfFile();
        }
        try {
            this.createConfDir();
            this.createConfDirFiles();
            this.createHtmlDir();
            this.createOfficeDir();
            this.createDatabaseConfig();
            this.createGstoolPropertyFiles();
        }
        catch (Exception e) {
            ExceptionUtil.log(e, NLS.bind((String)Messages.CnAWorkspace_4, (Object)this.confDir.getAbsolutePath()));
        }
    }

    public void createConfFile() {
        File confFile = new File(this.confDir, "configuration.version");
        if (confFile.exists()) {
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream fis = Files.newInputStream(confFile.toPath(), new OpenOption[0]);){
                    props.load(fis);
                    if (props.get("version").equals(CONFIG_CURRENT_VERSION)) {
                        LOG.debug((Object)("Arbeitsverzeichnis bereits vorhanden, wird nicht neu erzeugt: " + this.confDir.getAbsolutePath()));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public synchronized void prepareWorkDir() {
        URL url = Platform.getInstanceLocation().getURL();
        String path = url.getPath().replace("/", File.separator);
        workDir = new File(path);
        this.confDir = new File(url.getPath(), CONF);
    }

    public File getWorkdir() {
        return workDir;
    }

    public File getConfDir() {
        return new File(workDir, CONF);
    }

    private void createConfDirFiles() throws IOException {
        this.createTextFile(CONF + File.separator + "reports.properties_skeleton", workDir, CONF + File.separator + "reports.properties");
        this.createTextFile(CONF + File.separator + "configuration.version", workDir);
    }

    public void createConfDir() {
        URL url = Platform.getInstanceLocation().getURL();
        File dir = new File(url.getPath(), CONF);
        dir.mkdirs();
    }

    private void createOfficeDir() throws IOException {
        URL url = Platform.getInstanceLocation().getURL();
        File officeDir = new File(url.getPath(), OFFICEDIR);
        officeDir.mkdirs();
        this.createBinaryFile(OFFICEDIR + File.separator + "report.ods", workDir);
        this.createBinaryFile(OFFICEDIR + File.separator + "report.odt", workDir);
        this.createBinaryFile(OFFICEDIR + File.separator + "sernet.png", workDir);
    }

    private void createHtmlDir() throws IOException {
        URL url = Platform.getInstanceLocation().getURL();
        String html = "html";
        File htmlDir = new File(url.getPath(), html);
        htmlDir.mkdirs();
        this.createTextFile(String.valueOf(html) + File.separator + "screen.css", workDir);
        this.createTextFile(String.valueOf(html) + File.separator + "about.html", workDir);
        this.createBinaryFile("browserdefault.png", new File(workDir, html));
    }

    private void createGstoolPropertyFiles() throws IOException {
        this.createTextFile(CONF + File.separator + "gstool-types.properties", VeriniceCharset.CHARSET_ISO_8859_15, this.getConfDir(), "gstool-types.properties", VeriniceCharset.CHARSET_ISO_8859_15, null);
        this.createTextFile(CONF + File.separator + "gstool-subtypes.properties", VeriniceCharset.CHARSET_ISO_8859_15, this.getConfDir(), "gstool-subtypes.properties", VeriniceCharset.CHARSET_ISO_8859_15, null);
    }

    /*
     * Exception decompiling
     */
    private void createBinaryFile(String infile, File toDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createGstoolImportDatabaseConfig(String url, String user, String pass) throws IOException {
        int settingsSize = 5;
        HashMap<String, String> settings = new HashMap<String, String>(5);
        settings.put("url", url.replace("\\", "\\\\"));
        settings.put("user", user);
        settings.put("pass", pass);
        if (url.indexOf("odbc") > -1) {
            String dbUrl = this.createTempImportDbUrl();
            settings.put("url", dbUrl);
            settings.put("driver", "org.apache.derby.iapi.jdbc.AutoloadedDriver");
            settings.put("dialect", "sernet.verinice.hibernate.ByteArrayDerbyDialect");
        } else {
            settings.put("driver", "net.sourceforge.jtds.jdbc.Driver");
            settings.put("dialect", "org.hibernate.dialect.SQLServerDialect");
        }
        this.createTextFile(CONF + File.separator + "skel_hibernate-vampire.cfg.xml", workDir, CONF + File.separator + "hibernate-vampire.cfg.xml", settings);
    }

    public void createGstoolImportDatabaseConfig() throws IOException {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.createGstoolImportDatabaseConfig(prefs.getString("gs_cna_dburl"), prefs.getString("gs_cna_dbuser"), prefs.getString("gs_cna_dbpass"));
    }

    private void createTextFile(String infile, File toDir) throws IOException {
        this.createTextFile(infile, toDir, infile, null);
    }

    private void createTextFile(String infile, File toDir, String outfile) throws IOException {
        this.createTextFile(infile, toDir, outfile, null);
    }

    protected void createTextFile(String infile, File toDir, String outfile, Map<String, String> variables) throws IOException {
        this.createTextFile(infile, VeriniceCharset.CHARSET_DEFAULT, toDir, outfile, VeriniceCharset.CHARSET_DEFAULT, variables);
    }

    protected void createTextFile(String infile, Charset charsetInfile, File toDir, String outfile, Map<String, String> variables) throws IOException {
        this.createTextFile(infile, charsetInfile, toDir, outfile, VeriniceCharset.CHARSET_DEFAULT, variables);
    }

    protected void createTextFile(String infile, Charset charsetInfile, File toDir, String outfile, Charset charsetOutfile, Map<String, String> variables) throws IOException {
        String line;
        String infileResource = infile.replace('\\', '/');
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(infileResource);
        InputStreamReader inRead = new InputStreamReader(is, charsetInfile);
        BufferedReader bufRead = new BufferedReader(inRead);
        StringBuilder skelFile = new StringBuilder();
        Pattern var = Pattern.compile("\\{(.*)\\}");
        while ((line = bufRead.readLine()) != null) {
            Matcher match;
            line = line.replaceFirst("\n", LINE_SEP);
            if (variables != null && (match = var.matcher(line)).find()) {
                line = match.replaceFirst(variables.get(match.group(1)));
            }
            skelFile.append(String.valueOf(line) + LINE_SEP);
        }
        bufRead.close();
        inRead.close();
        is.close();
        this.backupFile(toDir, outfile);
        Throwable throwable = null;
        Object var15_16 = null;
        try (OutputStreamWriter outWrite = new OutputStreamWriter(Files.newOutputStream(new File(toDir, outfile).toPath(), new OpenOption[0]), charsetOutfile);){
            outWrite.write(skelFile.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void backupFile(File dir, String filepath) throws IOException {
        File file = new File(dir, filepath);
        if (file.exists()) {
            File outfile = new File(dir, String.valueOf(filepath) + ".bak");
            FileUtils.copyFile((File)file, (File)outfile);
        }
    }

    public synchronized void createDatabaseConfig() throws IOException {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        Activator.getDefault().getInternalServer().configureDatabase(prefs.getString("cna_dburl"), prefs.getString("cna_dbuser"), prefs.getString("cna_dbpass"), "org.apache.derby.iapi.jdbc.AutoloadedDriver", prefs.getString("cna_dbdialect"));
        Activator.getDefault().getInternalServer().configureSearch(prefs.getBoolean("search_disable"), prefs.getBoolean("search_index_on_startup"));
        this.createGstoolImportDatabaseConfig(prefs.getString("gs_cna_dburl"), prefs.getString("gs_cna_dbuser"), prefs.getString("gs_cna_dbpass"));
    }

    public void prepare() {
        this.prepare(false);
    }

    public boolean createReportTemplateDir(String reportFolder) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getWorkdir());
        sb.append(File.separatorChar);
        sb.append(reportFolder);
        sb.append(File.separatorChar);
        File reportDir = new File(sb.toString());
        if (!reportDir.exists()) {
            return reportDir.mkdirs();
        }
        return true;
    }

    public boolean createLocalReportTemplateDir(String reportFolder) {
        File reportDir = new File(reportFolder);
        if (!reportDir.exists()) {
            return reportDir.mkdirs();
        }
        return true;
    }

    public File getLocalReportTemplateDir() {
        return this.attachDirToWorkDir(IReportService.VERINICE_REPORTS_LOCAL);
    }

    public File getRemoteReportTemplateDir() {
        return this.attachDirToWorkDir("report_templates_remote");
    }

    private File attachDirToWorkDir(String dir) {
        return new File(this.getWorkdir(), dir);
    }
}

