/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.io.File;
import java.net.URI;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Preferences;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import sernet.gs.ui.rcp.main.Activator;

public class ClientPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final Logger LOG = Logger.getLogger(ClientPropertyPlaceholderConfigurer.class);
    private static ServerModeAccessor serverModeAccessor = new RCPServerModeAccessor();

    protected String resolvePlaceholder(String placeholder, Properties props) {
        if (placeholder.equals("verinice.serverURL")) {
            String server = null;
            if (this.isInternalServerMode()) {
                try {
                    String port = System.getProperty(ORG_OSGI_SERVICE_HTTP_PORT, "8080");
                    URI uri = new URI("http://localhost:" + port);
                    server = uri.toString();
                }
                catch (Throwable ex) {
                    LOG.error((Object)("cannot set the internal server uri: " + ex.getLocalizedMessage()), ex);
                }
            } else {
                server = ClientPropertyPlaceholderConfigurer.correctServerURI(this.getServerURI());
            }
            return server;
        }
        if (placeholder.equals("vnl_storage_folder")) {
            StringBuilder sb = new StringBuilder();
            sb.append(System.getProperty("osgi.instance.area"));
            if (!sb.toString().endsWith(File.pathSeparator)) {
                sb.append(File.pathSeparator);
            }
            sb.append("licenseFiles").append(File.pathSeparator);
            return sb.toString();
        }
        return props.getProperty(placeholder);
    }

    private boolean isInternalServerMode() {
        return serverModeAccessor.isInternalServerMode();
    }

    private String getServerURI() {
        return serverModeAccessor.getServerURI();
    }

    private static String correctServerURI(String uri) {
        int i = uri.length() - 1;
        while (i > 0 && uri.codePointAt(i) == 47) {
            --i;
        }
        String returnedUri = uri.substring(0, i + 1);
        LOG.debug((Object)("corrected server URI to: " + uri));
        return returnedUri;
    }

    public static void setRemoteServerMode(final String serverURI) {
        serverModeAccessor = new ServerModeAccessor(){

            @Override
            public boolean isInternalServerMode() {
                return false;
            }

            @Override
            public String getServerURI() {
                return serverURI;
            }
        };
    }

    private static class RCPServerModeAccessor
    implements ServerModeAccessor {
        private Preferences prefs = Activator.getDefault().getPluginPreferences();

        private RCPServerModeAccessor() {
        }

        @Override
        public boolean isInternalServerMode() {
            return this.prefs.getString("gs_cna_operationmode").equals("gs_cna_operationmode_standalone");
        }

        @Override
        public String getServerURI() {
            return this.prefs.getString("gs_cna_vnserver_uri");
        }
    }

    private static interface ServerModeAccessor {
        public boolean isInternalServerMode();

        public String getServerURI();
    }
}

