/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ViewIntroAdapterPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ApplicationActionBarAdvisor;
import sernet.gs.ui.rcp.main.Messages;
import sernet.gs.ui.rcp.main.actions.ShowCheatSheetAction;
import sernet.gs.ui.rcp.main.bsi.views.OpenCataloguesJob;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.IInternalServerStartListener;
import sernet.verinice.interfaces.updatenews.IUpdateNewsService;
import sernet.verinice.model.updateNews.UpdateNewsException;
import sernet.verinice.model.updateNews.UpdateNewsMessageEntry;
import sernet.verinice.rcp.PartListenerAdapter;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.UpdateNewsDialog;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final Logger LOG = Logger.getLogger(ApplicationWorkbenchWindowAdvisor.class);
    private static final Pattern VERINICE_VERSION = Pattern.compile("\\b\\d{1}?[\\.]\\d{2}[\\.]\\d{1}\\b");
    private IUpdateNewsService updateNewsService;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        int pointX = 1100;
        int pointY = 768;
        int perspectiveBarSize = 360;
        try {
            IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
            configurer.setInitialSize(new Point(1100, 768));
            configurer.setShowCoolBar(true);
            configurer.setShowStatusLine(true);
            configurer.setShowProgressIndicator(true);
            IPreferenceStore apiStore = PlatformUI.getPreferenceStore();
            apiStore.setValue("SHOW_TRADITIONAL_STYLE_TABS", false);
            configurer.setShowPerspectiveBar(true);
            configurer.setTitle(this.getCurrentUserName());
            apiStore.setValue("DOCK_PERSPECTIVE_BAR", "TOP_LEFT");
            apiStore.setValue("PERSPECTIVE_BAR_EXTRAS", this.getInitialPerspectiveBarList());
            apiStore.setValue("PERSPECTIVE_BAR_SIZE", 360);
        }
        catch (Exception t) {
            LOG.error((Object)"Error while configuring window.", (Throwable)t);
        }
    }

    private String getInitialPerspectiveBarList() {
        return "sernet.verinice.rcp.bp.BaseProtectionPerspective";
    }

    private String getCurrentUserName() {
        String titleString = "verinice";
        boolean standalone = Activator.getDefault().getPluginPreferences().getString("gs_cna_operationmode").equals("gs_cna_operationmode_standalone");
        if (!standalone) {
            IAuthService service = (IAuthService)VeriniceContext.get((String)"authService");
            titleString = String.valueOf(titleString) + ".PRO - " + service.getUsername();
        }
        return titleString;
    }

    public void postWindowOpen() {
        if (Activator.getDefault().getPluginPreferences().getBoolean("cna_derbywarning")) {
            Activator.getDefault().getPluginPreferences().setValue("cna_derbywarning", false);
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ApplicationWorkbenchWindowAdvisor_0, (String)Messages.ApplicationWorkbenchWindowAdvisor_1);
        }
        this.showFirstSteps();
        this.preloadDBMapper();
        this.checkOpenViews();
        this.closeUnallowedViews();
        this.showUpdateNews();
    }

    private void preloadDBMapper() {
        WorkspaceJob job = new WorkspaceJob(Messages.ApplicationWorkbenchWindowAdvisor_2){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Activator.inheritVeriniceContextState();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void showFirstSteps() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener2)new PartListenerAdapter(){

            @Override
            public void partClosed(IWorkbenchPartReference reference) {
                IWorkbenchPart part = reference.getPart(false);
                if (part instanceof ViewIntroAdapterPart && Activator.getDefault().getPluginPreferences().getBoolean("cna_derbywarning")) {
                    Preferences prefs = Activator.getDefault().getPluginPreferences();
                    prefs.setValue("cna_derbywarning", false);
                    ShowCheatSheetAction action = new ShowCheatSheetAction(Messages.ApplicationWorkbenchWindowAdvisor_3);
                    action.run();
                }
            }
        });
    }

    public void loadBsiCatalogues() {
        try {
            OpenCataloguesJob job = new OpenCataloguesJob(Messages.ApplicationWorkbenchWindowAdvisor_20);
            job.setUser(false);
            job.schedule();
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)Messages.ApplicationWorkbenchWindowAdvisor_22, (Throwable)e);
        }
    }

    public void closeUnallowedViews() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor descriptor) {
                super.perspectiveActivated(page, descriptor);
                ApplicationWorkbenchWindowAdvisor.this.checkOpenViews();
            }

            public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                super.perspectiveOpened(page, perspective);
                ApplicationWorkbenchWindowAdvisor.this.checkOpenViews();
            }
        });
    }

    private void checkOpenViews() {
        Activator.inheritVeriniceContextState();
        Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(window -> Stream.of(window.getPages())).flatMap(page -> Stream.of(page.getViewReferences())).forEach(ref -> {
            IViewPart part = ref.getView(true);
            if (part instanceof RightsEnabledView) {
                String rightID = ((RightsEnabledView)part).getRightID();
                if (Activator.getDefault().isStandalone() && !Activator.getDefault().getInternalServer().isRunning()) {
                    IInternalServerStartListener listener = e -> {
                        if (e.isStarted()) {
                            Display.getDefault().asyncExec(() -> this.hideView(rightID, (IViewReference)ref));
                        }
                    };
                    Activator.getDefault().getInternalServer().addInternalServerStatusListener(listener);
                } else {
                    this.hideView(rightID, (IViewReference)ref);
                }
            }
        });
    }

    private void hideView(String actionId, IViewReference viewReference) {
        Activator.inheritVeriniceContextState();
        if (!((RightsServiceClient)VeriniceContext.get((String)"rightsService")).isEnabled(actionId)) {
            Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(window -> Stream.of(window.getPages())).forEach(page -> Stream.of(page.getViewReferences()).forEach(ref -> page.hideView(viewReference)));
        }
    }

    private void showUpdateNews() {
        boolean showNewsDialog;
        boolean bl = showNewsDialog = !Activator.getDefault().getPreferenceStore().getBoolean("show_update_news_dialog");
        if (showNewsDialog) {
            this.handleOpenDialogByServerStatus();
        }
    }

    private void handleOpenDialogByServerStatus() {
        if (Activator.getDefault().isStandalone()) {
            if (!Activator.getDefault().getInternalServer().isRunning()) {
                IInternalServerStartListener listener = e -> {
                    if (e.isStarted()) {
                        this.openNewsDialog();
                    }
                };
                Activator.getDefault().getInternalServer().addInternalServerStatusListener(listener);
            } else if (Activator.getDefault().getInternalServer().isRunning()) {
                this.openNewsDialog();
            }
        }
    }

    private void openNewsDialog() {
        try {
            Activator.inheritVeriniceContextState();
            String newsRepo = this.getNewsRepository();
            UpdateNewsMessageEntry newsEntry = this.getUpdateNewsService().getNewsFromRepository(newsRepo);
            if (newsEntry != null) {
                this.openNewsDialog(newsEntry);
            }
        }
        catch (UpdateNewsException e) {
            LOG.error((Object)"Problem occurred during loading the verinice-update-news", (Throwable)e);
        }
        catch (Exception t) {
            LOG.error((Object)"Problem occurred", (Throwable)t);
        }
    }

    private void openNewsDialog(UpdateNewsMessageEntry newsEntry) throws UpdateNewsException {
        String text = newsEntry.getMessage(Locale.getDefault());
        String installedVersion = ApplicationWorkbenchWindowAdvisor.getApplicationVersionFromAboutText();
        LOG.debug((Object)("installed Version:\t" + installedVersion));
        boolean updateNecessary = this.getUpdateNewsService().isUpdateNecessary(installedVersion);
        LOG.debug((Object)("update necessary:\t" + updateNecessary));
        if (StringUtils.isNotEmpty((String)installedVersion) && this.getUpdateNewsService().isUpdateNecessary(installedVersion)) {
            this.openNewsDialog(text);
        }
    }

    private void openNewsDialog(String text) throws UpdateNewsException {
        URL updateSiteURL;
        try {
            updateSiteURL = new URL(this.getUpdateNewsService().getNewsFromRepository(this.getNewsRepository()).getUpdateSite());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Updatesite not parseable", (Throwable)e);
            throw new UpdateNewsException("Malformed URL of updatesite", (Throwable)e);
        }
        Display.getDefault().syncExec(() -> {
            Shell dialogShell = Display.getCurrent().getActiveShell();
            UpdateNewsDialog newsDialog = new UpdateNewsDialog(dialogShell, text, updateSiteURL);
            newsDialog.open();
        });
    }

    private String getNewsRepository() {
        String repo = Activator.getDefault().getPreferenceStore().getString("standalone_updatenews_url");
        String repoSetBySystem = System.getProperty("standalone_updatenews_url");
        if (StringUtils.isNotEmpty((String)repoSetBySystem)) {
            repo = repoSetBySystem;
        }
        return repo;
    }

    private static String getApplicationVersionFromAboutText() {
        String firstLine;
        Matcher matcher;
        String[] lines;
        IProduct product = Platform.getProduct();
        String aboutText = product.getProperty("aboutText");
        String version = "";
        if (aboutText != null && (lines = aboutText.split("\\r?\\n")) != null && lines.length > 0 && (matcher = VERINICE_VERSION.matcher(firstLine = lines[0])).find()) {
            version = matcher.group();
        }
        LOG.debug((Object)("Read versionnumber " + version + " from prodcut-description"));
        return version;
    }

    private IUpdateNewsService getUpdateNewsService() {
        if (this.updateNewsService == null) {
            this.updateNewsService = (IUpdateNewsService)VeriniceContext.get((String)"updateNewsService");
        }
        return this.updateNewsService;
    }
}

