/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.io.InvalidClassException;
import java.util.HashSet;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.springframework.remoting.RemoteAccessException;
import sernet.gs.ui.rcp.main.ApplicationWorkbenchWindowAdvisor;
import sernet.gs.ui.rcp.main.Messages;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "sernet.verinice.rcp.bp.BaseProtectionPerspective";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        this.activateProxyService();
    }

    private void activateProxyService() {
        ServiceReference ref;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        Object proxyService = null;
        if (bundle != null && (ref = bundle.getBundleContext().getServiceReference(IProxyService.class.getName())) != null) {
            proxyService = bundle.getBundleContext().getService(ref);
        }
        if (proxyService == null) {
            IDEWorkbenchPlugin.log((String)"Proxy service could not be found.");
        }
    }

    public void postStartup() {
        this.removeUnneededPrefPages();
    }

    public void eventLoopException(Throwable exception) {
        if (exception instanceof RemoteAccessException && exception.getCause() instanceof InvalidClassException) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExceptionUtilErrorPopupTitle, (String)Messages.ClientAndServerIncompatible));
        } else {
            super.eventLoopException(exception);
        }
    }

    private void removeUnneededPrefPages() {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        String[] prefPageIDsToRemove = new String[]{"org.eclipse.datatools.connectivity.ui.preferences.dataNode", "org.eclipse.birt.report.designer.ui.preferences", "org.eclipse.birt.chart.ui.swt.fieldassist.preferences.FieldAssistPreferencePage"};
        HashSet<String> idSet = new HashSet<String>();
        String[] stringArray = prefPageIDsToRemove;
        int n = prefPageIDsToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            idSet.add(s);
            ++n2;
        }
        stringArray = pm.getRootSubNodes();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String node = stringArray[n2];
            if (idSet.contains(node.getId())) {
                pm.remove((IPreferenceNode)node);
            }
            ++n2;
        }
    }
}

