/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenPerspectiveAction;
import org.eclipse.ui.actions.PerspectiveMenu;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ChangeToPerspectiveMenu;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.cheatsheets.actions.CheatSheetCategoryBasedSelectionAction;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.actions.ChangeOwnPasswordAction;
import sernet.gs.ui.rcp.main.actions.GSMBasicSecurityCheckAction;
import sernet.gs.ui.rcp.main.actions.ImportCSVAction;
import sernet.gs.ui.rcp.main.actions.ImportGstoolAction;
import sernet.gs.ui.rcp.main.actions.ImportGstoolNotesAction;
import sernet.gs.ui.rcp.main.actions.Messages;
import sernet.gs.ui.rcp.main.actions.OpenMultipleViewAction;
import sernet.gs.ui.rcp.main.actions.OpenSearchViewAction;
import sernet.gs.ui.rcp.main.actions.OpenViewAction;
import sernet.gs.ui.rcp.main.actions.ReloadAction;
import sernet.gs.ui.rcp.main.actions.ShowAccessControlEditAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAccountsAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAction;
import sernet.gs.ui.rcp.main.actions.ShowKonsolidatorAction;
import sernet.gs.ui.rcp.main.bsi.actions.BausteinZuordnungAction;
import sernet.gs.ui.rcp.main.bsi.actions.GSMBausteinZuordnungAction;
import sernet.gs.ui.rcp.main.preferences.ShowPreferencesAction;
import sernet.verinice.bp.rcp.converter.ItNetworkConverterAction;
import sernet.verinice.bpm.rcp.OpenTaskViewAction;
import sernet.verinice.iso27k.rcp.action.ImportPersonFromLdap;
import sernet.verinice.rcp.ProfileEditAction;
import sernet.verinice.rcp.ServerConnectionToggleAction;
import sernet.verinice.rcp.risk.RiskAnalysisAction;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final String WARNING_RESTRICTION = "restriction";
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private OpenViewAction openBSIViewAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeOthersAction;
    private OpenViewAction openBSIModelViewAction;
    private OpenViewAction openISMViewAction;
    private OpenViewAction openTodoViewAction;
    private OpenViewAction openAuditViewAction;
    private ReloadAction reloadAction;
    private ShowPreferencesAction showPreferencesAction;
    private OpenViewAction openBSIBrowserAction;
    private OpenViewAction openNoteAction;
    private OpenViewAction openFileAction;
    private OpenViewAction openRelationViewAction;
    private OpenViewAction openValidationViewAction;
    private OpenViewAction openGroupViewAction;
    private OpenMultipleViewAction openSearchViewAction;
    private OpenTaskViewAction openTaskViewAction;
    private OpenViewAction openAccountViewAction;
    private OpenViewAction openReportdepositViewAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ShowBulkEditAction bulkEditAction;
    private ShowBulkEditAccountsAction bulkEditAccountsAction;
    private ShowAccessControlEditAction accessControlEditAction;
    private ProfileEditAction profileEditAction;
    private ChangeOwnPasswordAction changeOwnPasswordAction;
    private ActionFactory.IWorkbenchAction introAction;
    private ShowKonsolidatorAction konsolidatorAction;
    private CheatSheetCategoryBasedSelectionAction showCheatSheetListAction;
    private ImportGstoolAction importGstoolAction;
    private ImportCSVAction importCSVAction;
    private ImportPersonFromLdap importPersonFromLdap;
    private ItNetworkConverterAction itNetworkConverterAction;
    private OpenViewAction openDocumentViewAction;
    private ImportGstoolNotesAction importGSNotesAction;
    private RiskAnalysisAction runRiskAnalysisAction;
    private ServerConnectionToggleAction serverConnectionToggleAction;
    private OpenViewAction openGSToolMappingViewAction;
    private OpenViewAction openBpViewAction;
    private OpenViewAction openCatalogViewAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        this.removeExtraneousActions();
        this.removeObsoletePerspectives();
    }

    protected void makeActions(IWorkbenchWindow window) {
        window.addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationActionBarAdvisor.this.enableOrDisableActionsForPerspective(perspective);
            }
        });
        this.exitAction = ActionFactory.QUIT.create(window);
        this.copyAction = ActionFactory.COPY.create(window);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.closeOthersAction = ActionFactory.CLOSE_OTHERS.create(window);
        this.openGroupViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_36, "sernet.verinice.rcp.accountgroup.GroupView", "group.png", "accountsettings");
        this.openBSIBrowserAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_0, "sernet.gs.ui.rcp.main.bsi.views.browserview", "tag.png", "bsibrowser");
        this.openNoteAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_1, "sernet.gs.ui.rcp.main.bsi.views.NoteView", "note.png", "notes");
        this.openFileAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_2, "sernet.gs.ui.rcp.main.bsi.views.FileView", "attach.png", "files");
        this.openRelationViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_4, "sernet.gs.ui.rcp.main.bsi.views.RelationView", "link.png", "relations");
        this.openBSIViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_5, "sernet.gs.ui.rcp.main.views.bsimassnahmenview", "gs.png", "bsimassnahmen");
        this.openBSIModelViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_6, "sernet.gs.ui.rcp.main.views.bsimodelview", "tree_explorer.gif", "bsimodelview");
        this.openISMViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_7, "sernet.verinice.iso27k.rcp.ISMView", "sweetie-verinice/png/16-arrow-branch-bgr.png", "ismview");
        this.openTodoViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_9, "sernet.gs.ui.rcp.main.bsi.views.todoview", "24-em-check.png", "todo");
        this.openDocumentViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_10, "sernet.gs.ui.rcp.main.documentview", "script.png", "documentview");
        this.openAuditViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_12, "sernet.gs.ui.rcp.main.bsi.views.auditview", "pruefplan-toolbar.png", "auditview");
        this.openTaskViewAction = new OpenTaskViewAction(window, "taskview");
        this.openValidationViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_35, "sernet.verinice.validation.CnAValidationView", "quickfix_warning_obj.gif", "cnavalidation");
        this.openAccountViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_38, "sernet.verinice.rcp.account.AccountView", "user_suit.png", "accountsettings");
        this.openReportdepositViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_41, "sernet.verinice.report.rcp.ReportDepositView", "folder_table.png", "reportdeposit");
        this.openSearchViewAction = new OpenSearchViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_42);
        this.openGSToolMappingViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_43, "sernet.gs.ui.rcp.gsimport.gstoolimportmappingview", "plugin_depend.gif", "gstoolimport");
        this.openBpViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_45, "sernet.verinice.bp.rcp.BaseProtectionView", "base-protection/base_protection_view.png", "baseprotectionview");
        this.reloadAction = new ReloadAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_14);
        this.importGstoolAction = new ImportGstoolAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_15);
        this.importCSVAction = new ImportCSVAction(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_30);
        this.importPersonFromLdap = new ImportPersonFromLdap(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_32);
        this.importGSNotesAction = new ImportGstoolNotesAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_27);
        this.itNetworkConverterAction = new ItNetworkConverterAction(window);
        this.showPreferencesAction = new ShowPreferencesAction();
        this.bulkEditAction = new ShowBulkEditAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_16);
        this.bulkEditAccountsAction = new ShowBulkEditAccountsAction(window, Messages.EditMultipleAccountsTogether);
        this.runRiskAnalysisAction = new RiskAnalysisAction(window);
        this.accessControlEditAction = new ShowAccessControlEditAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_17);
        this.profileEditAction = new ProfileEditAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_33);
        this.konsolidatorAction = new ShowKonsolidatorAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_18);
        GSMBasicSecurityCheckAction gsmbasicsecuritycheckAction = new GSMBasicSecurityCheckAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_34);
        BausteinZuordnungAction bausteinZuordnungAction = new BausteinZuordnungAction(window);
        GSMBausteinZuordnungAction gsmbausteinZuordnungAction = new GSMBausteinZuordnungAction(window);
        this.changeOwnPasswordAction = new ChangeOwnPasswordAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_31);
        this.showCheatSheetListAction = new CheatSheetCategoryBasedSelectionAction(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_20);
        this.serverConnectionToggleAction = new ServerConnectionToggleAction();
        this.introAction = ActionFactory.INTRO.create(window);
        this.openCatalogViewAction = new OpenViewAction(window, sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_CatalogView, "sernet.verinice.rcp.catalog.CatalogView", "catalog-view.png", "catalogview");
        Stream.of(new IAction[]{this.exitAction, this.copyAction, this.pasteAction, this.aboutAction, this.newWindowAction, this.saveAction, this.saveAsAction, this.closeAction, this.closeAllAction, this.closeOthersAction, this.openBSIBrowserAction, this.openNoteAction, this.openFileAction, this.openRelationViewAction, this.openBSIViewAction, this.openBSIModelViewAction, this.openISMViewAction, this.openTodoViewAction, this.openAuditViewAction, this.openTaskViewAction, this.openValidationViewAction, this.reloadAction, this.importGstoolAction, this.importCSVAction, this.importPersonFromLdap, this.importGSNotesAction, this.showPreferencesAction, this.bulkEditAction, this.bulkEditAccountsAction, this.runRiskAnalysisAction, this.accessControlEditAction, this.profileEditAction, this.konsolidatorAction, gsmbasicsecuritycheckAction, bausteinZuordnungAction, gsmbausteinZuordnungAction, this.openDocumentViewAction, this.introAction, this.openGroupViewAction, this.openReportdepositViewAction, this.openSearchViewAction, this.openGSToolMappingViewAction, this.openBpViewAction, this.openCatalogViewAction}).forEach(arg_0 -> ((ApplicationActionBarAdvisor)this).register(arg_0));
        Optional.ofNullable(window.getActivePage()).map(IWorkbenchPage::getPerspective).ifPresent(this::enableOrDisableActionsForPerspective);
    }

    private void enableOrDisableActionsForPerspective(IPerspectiveDescriptor perspective) {
        boolean isOldBpPerspective = "sernet.gs.ui.rcp.main.perspective".equals(perspective.getId());
        this.openAuditViewAction.setEnabled(isOldBpPerspective);
        this.openTodoViewAction.setEnabled(isOldBpPerspective);
        this.runRiskAnalysisAction.setEnabled(!isOldBpPerspective);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        IActionBarConfigurer configurer = this.getActionBarConfigurer();
        IWorkbenchWindow window = configurer.getWindowConfigurer().getWindow();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createWindowMenu(window));
        menuBar.add(this.createHelpMenu());
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        int statusItemCharWidth = 100;
        if (ApplicationActionBarAdvisor.isServerMode()) {
            StatusLineContributionItem statusItem = new StatusLineContributionItem("server-url", 100);
            statusItem.setText(String.valueOf(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_40) + this.getShortServerUrl());
            statusLine.add((IContributionItem)statusItem);
        }
    }

    private String getShortServerUrl() {
        int httpURLLength = 7;
        int httpsURLLength = 8;
        String url = this.getServerUrlPreference();
        if (url != null && !url.isEmpty()) {
            if (url.startsWith("http://")) {
                url = url.substring(7);
            } else if (url.startsWith("https://")) {
                url = url.substring(8);
            }
        }
        return url;
    }

    private IContributionItem createHelpMenu() {
        MenuManager helpMenu = new MenuManager(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_21, "help");
        helpMenu.add((IAction)this.introAction);
        helpMenu.add((IAction)this.showCheatSheetListAction);
        helpMenu.add((IAction)this.aboutAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        return helpMenu;
    }

    private IContributionItem createEditMenu() {
        MenuManager editMenu = new MenuManager(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_22, "edit");
        editMenu.add((IAction)this.bulkEditAction);
        editMenu.add((IAction)this.bulkEditAccountsAction);
        editMenu.add((IAction)this.runRiskAnalysisAction);
        editMenu.add((IAction)this.accessControlEditAction);
        editMenu.add((IAction)this.profileEditAction);
        editMenu.add((IAction)this.konsolidatorAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.copyAction);
        editMenu.add((IAction)this.pasteAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.changeOwnPasswordAction);
        editMenu.add((IAction)this.showPreferencesAction);
        return editMenu;
    }

    private IContributionItem createFileMenu() {
        MenuManager fileMenu = new MenuManager(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_23, "file");
        fileMenu.add((IAction)this.saveAction);
        fileMenu.add((IAction)this.saveAsAction);
        fileMenu.add((IAction)this.closeAction);
        fileMenu.add((IAction)this.closeAllAction);
        fileMenu.add((IAction)this.closeOthersAction);
        fileMenu.add((IContributionItem)new Separator("vn_menu_file"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.importGstoolAction);
        fileMenu.add((IAction)this.importGSNotesAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.importCSVAction);
        fileMenu.add((IAction)this.importPersonFromLdap);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.serverConnectionToggleAction);
        fileMenu.add((IAction)this.exitAction);
        return fileMenu;
    }

    private IContributionItem createWindowMenu(IWorkbenchWindow window) {
        MenuManager windowMenu = new MenuManager(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_24, "window");
        MenuManager viewsMenu = new MenuManager(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_25, "vn_menu_views");
        viewsMenu.add((IAction)this.openBSIModelViewAction);
        viewsMenu.add((IAction)this.openBSIViewAction);
        viewsMenu.add((IAction)this.openTodoViewAction);
        viewsMenu.add((IAction)this.openAuditViewAction);
        viewsMenu.add((IAction)this.openGSToolMappingViewAction);
        viewsMenu.add((IContributionItem)new Separator());
        viewsMenu.add((IAction)this.openBpViewAction);
        viewsMenu.add((IContributionItem)new Separator());
        viewsMenu.add((IAction)this.openISMViewAction);
        viewsMenu.add((IContributionItem)new Separator("additions"));
        viewsMenu.add((IContributionItem)new Separator());
        viewsMenu.add((IAction)this.openCatalogViewAction);
        viewsMenu.add((IAction)this.openDocumentViewAction);
        viewsMenu.add((IAction)this.openBSIBrowserAction);
        viewsMenu.add((IAction)this.openNoteAction);
        viewsMenu.add((IAction)this.openFileAction);
        viewsMenu.add((IAction)this.openRelationViewAction);
        viewsMenu.add((IAction)this.openValidationViewAction);
        viewsMenu.add((IAction)this.openSearchViewAction);
        viewsMenu.add((IContributionItem)new Separator());
        viewsMenu.add((IAction)this.openAccountViewAction);
        viewsMenu.add((IAction)this.openGroupViewAction);
        viewsMenu.add((IAction)this.openTaskViewAction);
        viewsMenu.add((IAction)this.openReportdepositViewAction);
        viewsMenu.add((IContributionItem)new Separator());
        viewsMenu.add((IContributionItem)new Separator());
        MenuManager perspectivesMenu = new MenuManager(sernet.gs.ui.rcp.main.Messages.ApplicationActionBarAdvisor_26, "vn_menu_perspectives");
        this.addPerspectiveMenu(window, perspectivesMenu, "sernet.verinice.iso27k.rcp.Iso27kPerspective");
        this.addPerspectiveMenu(window, perspectivesMenu, "sernet.gs.ui.rcp.main.perspective");
        this.addPerspectiveMenu(window, perspectivesMenu, "sernet.verinice.rcp.bp.BaseProtectionPerspective");
        perspectivesMenu.add((IContributionItem)new Separator("additions"));
        IContributionItem perspectiveList = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        perspectivesMenu.add(perspectiveList);
        windowMenu.add((IAction)this.newWindowAction);
        windowMenu.add((IAction)this.reloadAction);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IContributionItem)perspectivesMenu);
        windowMenu.add((IContributionItem)viewsMenu);
        Action toggleFilterByProceeding = new Action(sernet.gs.ui.rcp.main.Messages.FilterInformationNetworksByProceeding, 2){

            public void run() {
                super.run();
                boolean active = this.isChecked();
                ApplicationActionBarAdvisor.getPreferenceStore().setValue("filter_information_networks_by_proceeding", active);
            }
        };
        toggleFilterByProceeding.setChecked(ApplicationActionBarAdvisor.getPreferenceStore().getBoolean("filter_information_networks_by_proceeding"));
        windowMenu.add((IAction)toggleFilterByProceeding);
        return windowMenu;
    }

    private void addPerspectiveMenu(IWorkbenchWindow window, MenuManager perspectivesMenu, String perspectiveId) {
        perspectivesMenu.add((IAction)new OpenPerspectiveAction(window, window.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId), (PerspectiveMenu)new ChangeToPerspectiveMenu(window, perspectiveId)));
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager myToolbar = new ToolBarManager(coolBar.getStyle());
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)myToolbar, "vn_toolbar"));
        myToolbar.add((IAction)this.saveAction);
        myToolbar.add((IAction)this.saveAsAction);
        myToolbar.add((IContributionItem)new Separator("vn_toolbar_report"));
        myToolbar.add((IContributionItem)new Separator());
        myToolbar.add((IAction)this.bulkEditAction);
        myToolbar.add((IAction)this.bulkEditAccountsAction);
        myToolbar.add((IAction)this.accessControlEditAction);
        myToolbar.add((IAction)this.profileEditAction);
        myToolbar.add((IAction)this.konsolidatorAction);
        myToolbar.add((IAction)this.reloadAction);
        myToolbar.add((IAction)this.runRiskAnalysisAction);
        myToolbar.add((IAction)this.itNetworkConverterAction);
        myToolbar.add((IContributionItem)new Separator());
        myToolbar.add((IAction)this.openBSIViewAction);
        myToolbar.add((IAction)this.openBSIModelViewAction);
        myToolbar.add((IAction)this.openTodoViewAction);
        myToolbar.add((IAction)this.openAuditViewAction);
        myToolbar.add((IAction)this.openDocumentViewAction);
        myToolbar.add((IContributionItem)new Separator());
        myToolbar.add((IAction)this.openISMViewAction);
        myToolbar.add((IAction)this.openTaskViewAction);
        myToolbar.add((IContributionItem)new Separator());
        myToolbar.add((IAction)this.openCatalogViewAction);
        myToolbar.add((IAction)this.openAccountViewAction);
        myToolbar.add((IAction)this.openGroupViewAction);
        myToolbar.add((IAction)this.openReportdepositViewAction);
        myToolbar.add((IAction)this.openBSIBrowserAction);
        myToolbar.add((IAction)this.openNoteAction);
        myToolbar.add((IAction)this.openFileAction);
        myToolbar.add((IAction)this.openRelationViewAction);
        myToolbar.add((IAction)this.openValidationViewAction);
        myToolbar.add((IAction)this.openSearchViewAction);
    }

    private void removeExtraneousActions() {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        this.removeStandardAction(reg, "org.eclipse.ui.edit.text.actionSet.navigation");
        this.removeStandardAction(reg, "org.eclipse.ui.NavigateActionSet");
        this.removeStandardAction(reg, "org.eclipse.ui.edit.text.actionSet.openExternalFile");
        this.removeStandardAction(reg, "org.eclipse.ui.actionSet.openFiles");
        this.removeStandardAction(reg, "org.eclipse.ui.edit.text.actionSet.annotationNavigation");
        this.removeStandardAction(reg, "org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo");
        this.removeStandardAction(reg, "org.eclipse.ui.WorkingSetActionSet");
    }

    private void removeObsoletePerspectives() {
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            String perspectiveId = perspective.getId();
            if (perspectiveId.startsWith("<") && perspectiveId.endsWith(">")) {
                PlatformUI.getWorkbench().getPerspectiveRegistry().deletePerspective(perspective);
            }
            ++n2;
        }
    }

    private void removeStandardAction(ActionSetRegistry reg, String actionSetId) {
        IActionSetDescriptor[] actionSets = reg.getActionSets();
        int i = 0;
        while (i < actionSets.length) {
            if (actionSets[i].getId().equals(actionSetId)) {
                IExtension ext = actionSets[i].getConfigurationElement().getDeclaringExtension();
                reg.removeExtension(ext, new Object[]{actionSets[i]});
            }
            ++i;
        }
    }

    public static boolean isServerMode() {
        return "gs_cna_operationmode_withserver".equals(ApplicationActionBarAdvisor.getPreferenceStore().getString("gs_cna_operationmode"));
    }

    private String getServerUrlPreference() {
        return ApplicationActionBarAdvisor.getPreferenceStore().getString("gs_cna_vnserver_uri");
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

