/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import sernet.gs.ui.rcp.main.ClientPropertyPlaceholderConfigurer;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.ConfigurationLogger;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.Messages;
import sernet.gs.ui.rcp.main.bsi.model.BSIConfigFactory;
import sernet.gs.ui.rcp.main.bsi.model.BSIEntityResolverFactory;
import sernet.gs.ui.rcp.main.bsi.model.RcpLayoutConfig;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.logging.LoggerInitializer;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.IEntityResolverFactory;
import sernet.hui.common.connect.ResolverFactoryRegistry;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IBSIConfig;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IInternalServer;
import sernet.verinice.interfaces.IInternalServerStartListener;
import sernet.verinice.interfaces.ILayoutConfig;
import sernet.verinice.interfaces.ILogPathService;
import sernet.verinice.interfaces.IMain;
import sernet.verinice.interfaces.IReportLocalTemplateDirectoryService;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;
import sernet.verinice.interfaces.report.IReportService;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.rcp.Preferences;
import sernet.verinice.rcp.ReportTemplateSyncer;
import sernet.verinice.rcp.StartupImporter;
import sernet.verinice.rcp.jobs.VeriniceWorkspaceJob;
import sernet.verinice.service.commands.migration.DbVersion;
import sernet.verinice.service.model.IObjectModelService;
import sernet.verinice.service.parser.BSIConfigurationRemoteSource;
import sernet.verinice.service.parser.GSScraperUtil;

public class Activator
extends AbstractUIPlugin
implements IMain {
    private static final Logger LOG = Logger.getLogger(Activator.class);
    public static final String PLUGIN_ID = "sernet.gs.ui.rcp.main";
    private static final String PAX_WEB_SYMBOLIC_NAME = "org.ops4j.pax.web.pax-web-bundle";
    private static final String REPORT_SERVICE_SYMBOLIC_NAME = "sernet.verinice.report.service";
    private static final String LOCAL_UPDATE_SITE_URL = "/Verinice-Update-Site-2010";
    public static final String UPDATE_SITE_URL = "https://update.verinice.org/pub/verinice/update/subscription";
    public static final String DERBY_LOG_FILE_PROPERTY = "derby.stream.error.file";
    public static final String DERBY_LOG_FILE = "verinice-derby.log";
    private static Activator plugin;
    private static VeriniceContext.State state;
    private IInternalServer internalServer;
    private IVeriniceOdaDriver odaDriver;
    private BundleContext context;
    private boolean runsAsApplication = false;
    private boolean standalone = false;
    private ServiceTracker templateDirTracker;
    private ServiceTracker proxyTracker;
    private WorkspaceJob reindexJob;

    public Activator() {
        plugin = this;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return page;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        if (LOG.isInfoEnabled()) {
            Bundle bundle = context.getBundle();
            LOG.info((Object)("Starting bundle " + bundle.getSymbolicName() + " " + bundle.getVersion()));
        }
        context.registerService(IMain.class.getName(), (Object)this, null);
        LoggerInitializer loggerInitializer = LoggerInitializer.setupLogFilePath();
        context.registerService(ILogPathService.class.getName(), (Object)loggerInitializer, null);
        System.setProperty(DERBY_LOG_FILE_PROPERTY, String.valueOf(loggerInitializer.getLogDirectory()) + File.separatorChar + DERBY_LOG_FILE);
        this.templateDirTracker = new ServiceTracker(context, IReportLocalTemplateDirectoryService.class.getName(), null);
        this.templateDirTracker.open();
    }

    void startApplication() throws BundleException {
        this.runsAsApplication = true;
        Bundle bundle = Platform.getBundle((String)REPORT_SERVICE_SYMBOLIC_NAME);
        if (bundle == null) {
            LOG.warn((Object)"Report service bundle is not available!");
        } else {
            bundle.start();
        }
        CnAWorkspace.getInstance().prepareWorkDir();
        if (!this.prepareReportDirs()) {
            LOG.warn((Object)"ReportDirs are not created correclty");
        }
        if (!this.prepareVNLDir()) {
            LOG.warn((Object)"VNL-Dir was not created correctly");
        }
        if (Preferences.isServerMode()) {
            this.setSystemProxy();
        }
        this.standalone = Preferences.isStandalone();
        this.initializeInternalServer();
        this.configureInternalServer();
        CnAWorkspace.getInstance().prepare();
        try {
            ServiceFactory.openCommandService();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while connection to command service, forcing recreation of service factory configuration from preferences.", (Throwable)e);
            CnAWorkspace.getInstance().prepare(true);
        }
        state = ServiceFactory.getClientWorkObjects();
        VeriniceContext.setState((VeriniceContext.State)state);
        this.context.registerService(ICommandService.class.getName(), VeriniceContext.get((String)"commandService"), null);
        this.configureItbpCatalogLoader();
        GSScraperUtil.getInstance().getModel().setLayoutConfig((ILayoutConfig)new RcpLayoutConfig());
        ResolverFactoryRegistry.setResolverFactory((IEntityResolverFactory)new BSIEntityResolverFactory());
        Job repositoryJob = new Job("add-repository"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Activator.this.addUpdateRepository();
                }
                catch (URISyntaxException e) {
                    LOG.error((Object)"Error while adding update repository.");
                }
                return Status.OK_STATUS;
            }
        };
        repositoryJob.schedule();
        StartupImporter.importVna();
        ReportTemplateSyncer.sync();
        ConfigurationLogger.logSystemProperties();
        ConfigurationLogger.logApplicationProperties();
        ConfigurationLogger.logProxyPreferences();
        if (CnAElementFactory.isModelLoaded() || CnAElementFactory.isIsoModelLoaded()) {
            this.initObjectModelService();
        } else {
            IModelLoadListener loadListener = new IModelLoadListener(){

                @Override
                public void loaded(ISO27KModel model) {
                }

                @Override
                public void loaded(BSIModel model) {
                    Activator.this.initObjectModelService();
                    CnAElementFactory.getInstance().removeLoadListener(this);
                }

                @Override
                public void closed(BSIModel model) {
                }

                @Override
                public void loaded(BpModel model) {
                }

                @Override
                public void loaded(CatalogModel model) {
                }
            };
            CnAElementFactory.getInstance().addLoadListener(loadListener);
        }
    }

    public void configureInternalServer() {
        this.setGSCatalog();
        this.internalServer.configureDatabase(this.getPreferences().getString("cna_dburl"), this.getPreferences().getString("cna_dbuser"), this.getPreferences().getString("cna_dbpass"), "org.apache.derby.iapi.jdbc.AutoloadedDriver", this.getPreferences().getString("cna_dbdialect"));
        this.internalServer.configureSearch(this.getPreferences().getBoolean("search_disable"), this.getPreferences().getBoolean("search_index_on_startup"));
    }

    private void configureItbpCatalogLoader() {
        if (this.isStandalone()) {
            GSScraperUtil.getInstance().getModel().setBSIConfig(BSIConfigFactory.createStandaloneConfig());
        } else {
            GSScraperUtil.getInstance().getModel().setBSIConfig((IBSIConfig)new BSIConfigurationRemoteSource());
        }
    }

    private void initObjectModelService() {
        VeriniceWorkspaceJob job = new VeriniceWorkspaceJob("Load objectModelService", "error while loading objectModelService"){

            @Override
            protected void doRunInWorkspace() {
                Activator.inheritVeriniceContextState();
                IObjectModelService objectModelService = ServiceFactory.lookupObjectModelService();
                long time = System.currentTimeMillis();
                objectModelService.init();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("took " + (System.currentTimeMillis() - time) + " msec to load Service"));
                }
            }
        };
        JobScheduler.scheduleInitJob(job);
    }

    private void setGSCatalog() {
        try {
            if (Preferences.isBpCatalogLoadedFromZipFile()) {
                this.internalServer.setGSCatalogURL(this.propertyToURL("cna_bsizipfile"));
            } else {
                this.internalServer.setGSCatalogURL(this.propertyToURL("cna_bsiurl"));
            }
        }
        catch (MalformedURLException mfue) {
            LOG.warn((Object)"Error while setting base protection catalog pathes", (Throwable)mfue);
        }
    }

    public URL propertyToURL(String propertyKey) throws MalformedURLException {
        return new File(this.getPreferences().getString(propertyKey)).toURI().toURL();
    }

    private void initializeInternalServer() throws BundleException {
        if (this.standalone) {
            Bundle bundle = Platform.getBundle((String)"sernet.gs.server");
            if (bundle == null) {
                LOG.warn((Object)"verinice server bundle is not available. Assuming it is started separately.");
            } else if (bundle.getState() == 2 || bundle.getState() == 4) {
                LOG.debug((Object)"Manually starting GS Server");
                bundle.start();
            }
            ServiceReference sr = this.context.getServiceReference(IInternalServer.class.getName());
            if (sr == null) {
                throw new IllegalStateException("Cannot retrieve internal server service.");
            }
            this.internalServer = (IInternalServer)this.context.getService(sr);
        } else {
            this.internalServer = new ServerDummy();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Internal server is not used.");
            }
            try {
                Bundle paxWebBundle = Platform.getBundle((String)PAX_WEB_SYMBOLIC_NAME);
                if (paxWebBundle != null) {
                    paxWebBundle.stop();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while stopping pax-web http-service.", (Throwable)e);
            }
        }
    }

    private void setSystemProxy() {
        try {
            URI serverUri = new URI(this.getPreferences().getString("gs_cna_vnserver_uri"));
            IProxyService proxyService = this.getProxyService();
            IProxyData[] proxyDataForHost = proxyService.select(serverUri);
            if (proxyDataForHost == null || proxyDataForHost.length == 0) {
                this.clearSystemProxy();
            } else {
                this.setSystemProxy(proxyDataForHost);
            }
        }
        catch (Exception t) {
            LOG.error((Object)"Error while setting proxy.", (Throwable)t);
        }
    }

    private void setSystemProxy(IProxyData[] proxyDataForHost) {
        IProxyData[] iProxyDataArray = proxyDataForHost;
        int n = proxyDataForHost.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            if (data.getHost() != null) {
                System.setProperty("http.proxySet", "true");
                System.setProperty("http.proxyHost", data.getHost());
                System.setProperty("http.proxyPort", String.valueOf(data.getPort()));
                if (data.getUserId() != null && !data.getUserId().isEmpty()) {
                    System.setProperty("http.proxyName", data.getUserId());
                }
                if (data.getPassword() != null && !data.getPassword().isEmpty()) {
                    System.setProperty("http.proxyPassword", data.getPassword());
                }
            }
            ++n2;
        }
    }

    private void clearSystemProxy() {
        System.setProperty("http.proxySet", "false");
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("http.proxyName");
        System.clearProperty("http.proxyPassword");
    }

    private IPreferenceStore getPreferences() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void stop(BundleContext context) throws Exception {
        CnAElementHome.getInstance().close();
        plugin = null;
        if (this.proxyTracker != null) {
            this.proxyTracker.close();
        }
        this.joinReindexJob();
        super.stop(context);
    }

    private void joinReindexJob() throws InterruptedException {
        if (this.reindexJob != null) {
            this.reindexJob.cancel();
            this.reindexJob.join();
            this.reindexJob = null;
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IInternalServer getInternalServer() {
        return this.internalServer;
    }

    public IVeriniceOdaDriver getOdaDriver() {
        return this.odaDriver;
    }

    public static void checkDbVersion() throws CommandException {
        final boolean[] done = new boolean[1];
        int sleepTime = 1000;
        int maxStartTime = 30000;
        done[0] = false;
        Thread timeout = new Thread(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                while (!done[0]) {
                    try {
                        4.sleep(1000L);
                        long now = System.currentTimeMillis();
                        if (now - startTime <= 30000L) continue;
                        ExceptionUtil.log(new Exception(Messages.Activator_8), Messages.Activator_10);
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        timeout.start();
        try {
            DbVersion command = new DbVersion(0.97);
            ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            done[0] = true;
        }
        catch (CommandException e) {
            done[0] = true;
            throw e;
        }
        catch (RuntimeException re) {
            done[0] = true;
            throw re;
        }
    }

    private void addUpdateRepository() throws URISyntaxException {
        block6: {
            URI repoUri = null;
            String name = null;
            if (Preferences.isServerMode()) {
                repoUri = new URI(this.createUpdateSiteUrl(this.getPreferences().getString("gs_cna_vnserver_uri")));
                name = Messages.Activator_4;
            } else {
                repoUri = new URI(UPDATE_SITE_URL);
                name = Messages.Activator_43;
            }
            this.removeRepository();
            try {
                this.getMetadataRepositoryManager().addRepository(repoUri);
                this.getMetadataRepositoryManager().setRepositoryProperty(repoUri, "name", name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MetadataRepository added: " + repoUri));
                }
                this.getArtifactRepositoryManager().addRepository(repoUri);
                this.getArtifactRepositoryManager().setRepositoryProperty(repoUri, "name", name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ArtifactRepository added: " + repoUri));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not add repository: " + repoUri));
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)"stacktrace: ", (Throwable)e);
            }
        }
    }

    public IArtifactRepositoryManager getArtifactRepositoryManager() {
        ProvisioningUI ui = ProvUIActivator.getDefault().getProvisioningUI();
        return ProvUI.getArtifactRepositoryManager((ProvisioningSession)ui.getSession());
    }

    public IMetadataRepositoryManager getMetadataRepositoryManager() {
        ProvisioningUI ui = ProvUIActivator.getDefault().getProvisioningUI();
        return ProvUI.getMetadataRepositoryManager((ProvisioningSession)ui.getSession());
    }

    private void removeRepository() {
        URI[] uriArray = this.getMetadataRepositoryManager().getKnownRepositories(0);
        if (uriArray != null) {
            int i = 0;
            while (i < uriArray.length) {
                URI uri = uriArray[i];
                if (uri.toString().endsWith(LOCAL_UPDATE_SITE_URL) || UPDATE_SITE_URL.equals(uri.toString())) {
                    this.getArtifactRepositoryManager().removeRepository(uri);
                    this.getMetadataRepositoryManager().removeRepository(uri);
                }
                ++i;
            }
        }
    }

    private String createUpdateSiteUrl(String serverUrl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(serverUrl);
        stringBuilder.append(LOCAL_UPDATE_SITE_URL);
        return stringBuilder.toString();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void inheritVeriniceContextState() {
        VeriniceContext.setState((VeriniceContext.State)state);
    }

    public void updateServerURI(String uri) {
        if (!this.runsAsApplication) {
            LOG.info((Object)"verinice runs in designer mode - retrieving server configuration from ODA driver.");
            ClientPropertyPlaceholderConfigurer.setRemoteServerMode(uri);
            try {
                ServiceFactory.openCommandService();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
            state = ServiceFactory.getClientWorkObjects();
            VeriniceContext.setState((VeriniceContext.State)state);
            this.context.registerService(ICommandService.class.getName(), VeriniceContext.get((String)"commandService"), null);
            this.context.registerService(IObjectModelService.class.getName(), VeriniceContext.get((String)"objectModelService"), null);
        }
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.getProxyTracker().getService();
    }

    private ServiceTracker getProxyTracker() {
        if (this.proxyTracker == null) {
            this.proxyTracker = new ServiceTracker(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext(), IProxyService.class.getName(), null);
            this.proxyTracker.open();
        }
        return this.proxyTracker;
    }

    private boolean prepareReportDirs() {
        return CnAWorkspace.getInstance().createLocalReportTemplateDir(IReportService.VERINICE_REPORTS_LOCAL) && CnAWorkspace.getInstance().createReportTemplateDir("report_templates_remote");
    }

    private boolean prepareVNLDir() {
        String workspace = System.getProperty("osgi.instance.area");
        String vnlPath = FilenameUtils.concat((String)workspace, (String)"vnl");
        if (vnlPath.startsWith("file:")) {
            vnlPath = vnlPath.substring(5);
        }
        return CnAWorkspace.getInstance().createLocalReportTemplateDir(vnlPath);
    }

    public IReportLocalTemplateDirectoryService getIReportTemplateDirectoryService() {
        return (IReportLocalTemplateDirectoryService)this.templateDirTracker.getService();
    }

    public void setReindexJob(WorkspaceJob reindexJob) {
        this.reindexJob = reindexJob;
    }

    private static class ServerDummy
    implements IInternalServer {
        private ServerDummy() {
        }

        public void configureDatabase(String url, String user, String pass, String driver, String dialect) {
        }

        public void configureSearch(boolean disable, boolean indexOnStartup) {
        }

        public void start() {
        }

        public void stop() {
        }

        public boolean isRunning() {
            return true;
        }

        public void setGSCatalogURL(URL url) {
        }

        public void addInternalServerStatusListener(IInternalServerStartListener listener) {
        }

        public void removeInternalServerStatusListener(IInternalServerStartListener listener) {
        }
    }
}

