/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.gsimport.GstoolImportMappingElement;
import sernet.gs.ui.rcp.gsimport.GstoolTypeMapper;
import sernet.gs.ui.rcp.gsimport.Messages;
import sernet.hui.common.connect.HUITypeFactory;

public class UnknownTypeDialog
extends Dialog {
    private boolean result = false;
    private Set<String> unknownTypes;
    private Shell dialogShell;

    public UnknownTypeDialog(Shell parentShell, Set<String> unknownTypes) {
        super(parentShell);
        this.unknownTypes = unknownTypes;
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.dialogShell = new Shell(parent, 67696);
        this.dialogShell.setLayout((Layout)new GridLayout(1, false));
        this.dialogShell.setText(Messages.GstoolTypeValidator_0);
        this.dialogShell = (Shell)this.createDialogArea((Composite)this.dialogShell);
        this.dialogShell.setSize(500, 500);
        Display display = parent.getDisplay();
        this.dialogShell.open();
        while (!this.dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    public Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite introductionComposite = new Composite(container, 0);
        introductionComposite.setLayout((Layout)new GridLayout(1, false));
        introductionComposite.setLayoutData((Object)new GridData(256, 128, true, false));
        Label introTextLabel = new Label(introductionComposite, 64);
        introTextLabel.setLayoutData((Object)new GridData(256, 128, true, false));
        introTextLabel.setText(UnknownTypeDialog.getIntroductionString());
        final Composite scrolledContainer = new Composite(container, 0);
        scrolledContainer.setLayout((Layout)new GridLayout(1, true));
        scrolledContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        final ScrolledComposite scrolledComposite = new ScrolledComposite(scrolledContainer, 512);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite unknownTypesComposite = new Composite((Composite)scrolledComposite, 0);
        unknownTypesComposite.setLayout((Layout)new GridLayout(1, false));
        unknownTypesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayList<String> list = new ArrayList<String>(this.unknownTypes.size());
        list.addAll(this.unknownTypes);
        Collections.sort(list);
        int i = 0;
        while (i < list.size()) {
            Label unknownTypesLabel = new Label(unknownTypesComposite, 0);
            unknownTypesLabel.setText((String)list.get(i));
            ++i;
        }
        scrolledComposite.setContent((Control)unknownTypesComposite);
        scrolledComposite.setMinSize(200, 200);
        scrolledComposite.setSize(250, 250);
        scrolledComposite.setVisible(true);
        scrolledComposite.layout();
        container.layout();
        unknownTypesComposite.layout();
        scrolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                scrolledComposite.setMinSize(scrolledContainer.computeSize(-1, -1));
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.createButtonsForButtonBar(container);
        return parent;
    }

    private void addUnknownTypes() {
        for (String type : this.unknownTypes) {
            GstoolImportMappingElement mappingEntry = new GstoolImportMappingElement(type, "UNKNOWN");
            GstoolTypeMapper.addGstoolSubtypeToPropertyFile(mappingEntry);
        }
        this.result = true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite buttonComposite = new Composite(parent, 132096);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        buttonComposite.setLayoutData((Object)new GridData(131072, 1024, true, false));
        Button addTypeButton = new Button(buttonComposite, 131080);
        addTypeButton.setText(Messages.UnknownTypeDialog_1);
        addTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UnknownTypeDialog.this.addUnknownTypes();
                UnknownTypeDialog.this.cancelPressed();
            }
        });
        Button cancelButton = new Button(buttonComposite, 131080);
        cancelButton.setText(Messages.UnknownTypeDialog_3);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UnknownTypeDialog.this.cancelPressed();
            }
        });
        Button okButton = new Button(buttonComposite, 131080);
        okButton.setText(Messages.UnknownTypeDialog_0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UnknownTypeDialog.this.result = true;
                UnknownTypeDialog.this.dialogShell.close();
            }
        });
    }

    private void cancelPressed() {
        this.result = false;
        this.dialogShell.close();
    }

    private static String getIntroductionString() {
        String defaultTypeTitle = HUITypeFactory.getInstance().getMessage("sonstit");
        return NLS.bind((String)Messages.GstoolTypeValidator_1, (Object)defaultTypeTitle);
    }
}

