/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import com.heatonresearch.datamover.DataMover;
import com.heatonresearch.datamover.db.DerbyDatabase;
import com.heatonresearch.datamover.db.MDBFileDatabase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Preferences;
import org.hibernate.exception.SQLGrammarException;
import sernet.gs.model.Baustein;
import sernet.gs.reveng.MSchutzbedarfkategTxt;
import sernet.gs.reveng.MbBaust;
import sernet.gs.reveng.MbBaustGefaehr;
import sernet.gs.reveng.MbMassn;
import sernet.gs.reveng.MbZeiteinheitenTxt;
import sernet.gs.reveng.ModZobjBst;
import sernet.gs.reveng.ModZobjBstMass;
import sernet.gs.reveng.NZielobjekt;
import sernet.gs.reveng.NZielobjektId;
import sernet.gs.reveng.NZobSb;
import sernet.gs.reveng.importData.BausteinInformationTransfer;
import sernet.gs.reveng.importData.BausteineMassnahmenResult;
import sernet.gs.reveng.importData.ESAResult;
import sernet.gs.reveng.importData.GefaehrdungInformationTransfer;
import sernet.gs.reveng.importData.MassnahmeInformationTransfer;
import sernet.gs.reveng.importData.ZielobjektTypeResult;
import sernet.gs.service.GSServiceException;
import sernet.gs.service.TimeFormatter;
import sernet.gs.ui.rcp.gsimport.AbstractGstoolImportTask;
import sernet.gs.ui.rcp.gsimport.ElementListUpdater;
import sernet.gs.ui.rcp.gsimport.GstoolTypeMapper;
import sernet.gs.ui.rcp.gsimport.IProgress;
import sernet.gs.ui.rcp.gsimport.LinkCreater;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.model.BSIConfigFactory;
import sernet.gs.ui.rcp.main.bsi.model.CnAElementBuilder;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.NullMonitor;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CnATreeElementBuildException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IBSIConfig;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.NetzKomponente;
import sernet.verinice.model.bsi.Person;
import sernet.verinice.model.bsi.Schutzbedarf;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Link;
import sernet.verinice.service.commands.task.ImportCreateBausteinReferences2;
import sernet.verinice.service.commands.task.ImportCreateBausteine;
import sernet.verinice.service.commands.task.ImportIndividualMassnahmen;
import sernet.verinice.service.commands.task.ImportTransferSchutzbedarf;
import sernet.verinice.service.gstoolimport.TransferData;
import sernet.verinice.service.parser.BSIMassnahmenModel;
import sernet.verinice.service.parser.GSScraperUtil;
import sernet.verinice.service.parser.LoadBausteine;

public class ImportTask
extends AbstractGstoolImportTask {
    private static final Logger LOG = Logger.getLogger(ImportTask.class);
    private IProgress monitor;
    int numberOfElements;
    int numberImported;
    private TransferData transferData;
    private List<MbZeiteinheitenTxt> zeiten;
    private final Map<ModZobjBstMass, MassnahmenUmsetzung> alleMassnahmen;
    private final Map<NZielobjektId, CnATreeElement> alleZielobjekte = new HashMap<NZielobjektId, CnATreeElement>();
    private final Map<NZielobjektId, Person> allePersonenByNZielobjektId = new HashMap<NZielobjektId, Person>();
    private List<Baustein> allCatalogueBausteine;
    private final Map<String, NZielobjektId> itverbundZuordnung = new HashMap<String, NZielobjektId>();
    private final boolean importBausteine;
    private final boolean massnahmenPersonen;
    private final boolean bausteinPersonen;
    private final boolean zielObjekteZielobjekte;
    private final boolean schutzbedarf;
    private final boolean importRollen;
    private final boolean kosten;
    private final boolean importUmsetzung;
    private final Map<MbBaust, BausteinUmsetzung> alleBausteineToBausteinUmsetzungMap;
    private final Map<MbBaust, ModZobjBst> alleBausteineToZoBstMap;
    private final Map<BausteinUmsetzung, List<BausteineMassnahmenResult>> individualMassnahmenMap;
    private final Map<NZielobjektId, List<BausteineMassnahmenResult>> nZielObjektBausteineMassnahmenResultMap;
    private final Set<String> createdLinks;
    private String sourceId;

    public ImportTask(boolean bausteine, boolean massnahmenPersonen, boolean zielObjekteZielobjekte, boolean schutzbedarf, boolean importRollen, boolean kosten, boolean umsetzung, boolean bausteinPersonen) {
        this.importBausteine = bausteine;
        this.massnahmenPersonen = massnahmenPersonen;
        this.zielObjekteZielobjekte = zielObjekteZielobjekte;
        this.schutzbedarf = schutzbedarf;
        this.importRollen = importRollen;
        this.kosten = kosten;
        this.importUmsetzung = umsetzung;
        this.bausteinPersonen = bausteinPersonen;
        this.alleBausteineToBausteinUmsetzungMap = new HashMap<MbBaust, BausteinUmsetzung>();
        this.alleBausteineToZoBstMap = new HashMap<MbBaust, ModZobjBst>();
        this.alleMassnahmen = new HashMap<ModZobjBstMass, MassnahmenUmsetzung>();
        this.individualMassnahmenMap = new HashMap<BausteinUmsetzung, List<BausteineMassnahmenResult>>();
        this.nZielObjektBausteineMassnahmenResultMap = new HashMap<NZielobjektId, List<BausteineMassnahmenResult>>();
        this.createdLinks = new HashSet<String>();
    }

    @Override
    protected void executeTask(int importType, IProgress monitor) throws Exception {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        String sourceDbUrl = prefs.getString("gs_cna_dburl");
        if (sourceDbUrl.indexOf("odbc") > -1) {
            this.copyMDBToTempDB(sourceDbUrl);
        }
        this.allCatalogueBausteine = this.loadCatalogueBausteine();
        this.monitor = monitor;
        this.zeiten = this.getGstoolDao().findZeiteinheitenTxtAll();
        List findZielobjektTypAll = this.getGstoolDao().findZielobjektTypAll();
        LOG.debug((Object)"List of all ZO types in GSTOOL DB: ");
        for (ZielobjektTypeResult zielobjektTypeResult : findZielobjektTypAll) {
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(String.valueOf(zielobjektTypeResult.subtype) + "=" + zielobjektTypeResult.type));
        }
        this.transferData = new TransferData(this.getGstoolDao(), this.importRollen);
        this.sourceId = this.importZielobjekte();
    }

    private String importZielobjekte() throws Exception {
        int maxUuidLength = 6;
        String defaultSubTaskDescription = "Die Daten werden gespeichert.";
        String sourceId = UUID.randomUUID().toString().substring(0, 6);
        List<ZielobjektTypeResult> zielobjekte = this.findZielobjekte();
        this.numberOfElements = zielobjekte.size();
        this.numberImported = 0;
        if (this.importBausteine) {
            this.monitor.beginTask("Importiere Zielobjekte, Bausteine und Ma\u00dfnahmen...", this.numberOfElements);
        } else {
            this.monitor.beginTask("Importiere Zielobjekte...", this.numberOfElements);
        }
        ITVerbund itverbundForOrphans = null;
        List<ITVerbund> neueVerbuende = this.importItVerbuende(sourceId, zielobjekte);
        long startTime = System.currentTimeMillis();
        for (ZielobjektTypeResult zielobjektTypeResult : zielobjekte) {
            String typeId = GstoolTypeMapper.getVeriniceTypeOrDefault(zielobjektTypeResult.type, zielobjektTypeResult.subtype);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("GSTOOL type id " + zielobjektTypeResult.type + " : " + zielobjektTypeResult.subtype + " was translated to: " + typeId));
            }
            if (typeId.equals("itverbund")) continue;
            NZielobjekt zielobjekt = zielobjektTypeResult.zielobjekt;
            CnATreeElement element = null;
            if (!neueVerbuende.isEmpty()) {
                NZielobjektId origITVerbundZOID = this.itverbundZuordnung.get(zielobjekt.getGuid());
                ITVerbund itverbund = (ITVerbund)this.alleZielobjekte.get(origITVerbundZOID);
                if (itverbund == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ITVerbund not found for ZO: " + zielobjekt.getName() + ". Created in BSI"));
                    }
                    if (itverbundForOrphans == null) {
                        itverbundForOrphans = (ITVerbund)CnAElementFactory.getInstance().saveNew((CnATreeElement)CnAElementFactory.getLoadedModel(), "itverbund", null, false);
                        itverbundForOrphans.setTitel("---Waisenhaus: Zielobjekte ohne IT-Verbund-Zuordnung");
                        itverbundForOrphans.setSourceId(sourceId);
                        CnAElementHome.getInstance().update((CnATreeElement)itverbundForOrphans);
                    }
                    itverbund = itverbundForOrphans;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating ZO " + zielobjekt.getName() + " in ITVerbund " + itverbund.getTitle()));
                }
                itverbund.setSourceId(sourceId);
                element = CnAElementBuilder.getInstance().buildAndSave(itverbund, typeId);
            }
            if (element == null) continue;
            NZielobjektId identifier = zielobjekt.getId();
            this.alleZielobjekte.put(identifier, element);
            if (element instanceof Person) {
                Person person = (Person)element;
                Person previousValue = this.allePersonenByNZielobjektId.get(identifier);
                if (previousValue != null && previousValue != person) {
                    LOG.warn((Object)("Found Person " + person + " with NZielobjektId " + identifier + ", ignoring in favor of previous value " + previousValue));
                } else {
                    this.allePersonenByNZielobjektId.put(identifier, person);
                }
            }
            this.transferData.transfer(element, zielobjektTypeResult);
            element = this.importEsa(zielobjektTypeResult, element);
            element.setSourceId(sourceId);
            this.monitor.subTask(String.valueOf(this.numberImported) + "/" + this.numberOfElements + " - " + element.getTitle());
            this.createBausteine(sourceId, element, zielobjekt);
            CnAElementHome.getInstance().update(element);
            this.monitor.worked(1);
            ++this.numberImported;
        }
        long durationImportZO = System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        this.createIndividualMassnahmen();
        long durationImportIndividual = System.currentTimeMillis() - startTime;
        this.monitor.subTask("Die Daten werden gespeichert.");
        startTime = System.currentTimeMillis();
        this.importMassnahmenVerknuepfungen();
        long durationImportMnLinks = System.currentTimeMillis() - startTime;
        this.monitor.subTask("Die Daten werden gespeichert.");
        Collection<MassnahmenUmsetzung> allMnUms = this.alleMassnahmen.values();
        allMnUms.removeAll(Collections.singleton(null));
        ArrayList<Object> toUpdate = new ArrayList<CnATreeElement>();
        toUpdate.addAll(allMnUms);
        LOG.debug((Object)"Saving person links to measures.");
        this.monitor.beginTask("Verkn\u00fcpfe Ansprechpartner mit Ma\u00dfnahmen...", toUpdate.size());
        ElementListUpdater updater = new ElementListUpdater((List<CnATreeElement>)toUpdate, this.monitor);
        updater.setMaxNumberPerCommand(500);
        updater.execute();
        startTime = System.currentTimeMillis();
        this.importBausteinPersonVerknuepfungen();
        long durationImportBstPrsnLinks = System.currentTimeMillis() - startTime;
        this.monitor.subTask("Die Daten werden gespeichert.");
        toUpdate = new ArrayList();
        toUpdate.addAll(this.alleBausteineToBausteinUmsetzungMap.values());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Saving person links to modules.");
        }
        this.monitor.beginTask("Verkn\u00fcpfe Ansprechpartner mit Bausteinen...", toUpdate.size());
        updater = new ElementListUpdater((List<CnATreeElement>)toUpdate, this.monitor);
        updater.setMaxNumberPerCommand(500);
        updater.execute();
        startTime = System.currentTimeMillis();
        this.importZielobjektVerknuepfungen();
        long durationImportZoLinks = System.currentTimeMillis() - startTime;
        this.monitor.subTask("Die Daten werden gespeichert.");
        startTime = System.currentTimeMillis();
        this.importSchutzbedarf();
        long durationImportSB = System.currentTimeMillis() - startTime;
        this.monitor.subTask("Die Daten werden gespeichert.");
        int n = zielobjekte.size();
        this.monitor.beginTask("Lese Bausteinreferenzen...", n);
        int i = 1;
        startTime = System.currentTimeMillis();
        for (Map.Entry<NZielobjektId, CnATreeElement> entry : this.alleZielobjekte.entrySet()) {
            NZielobjektId zielobjektId = entry.getKey();
            CnATreeElement element = entry.getValue();
            this.monitor.subTask(String.valueOf(i) + "/" + n + " - " + element.getTitle());
            this.createBausteinReferences(element, zielobjektId);
            this.monitor.worked(1);
            ++i;
        }
        long durationImportBstRef = System.currentTimeMillis() - startTime;
        this.monitor.done();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Duration of importing zielobjekte:\t" + TimeFormatter.getHumanRedableTime((long)durationImportZO)));
            LOG.debug((Object)("Duration of importing individual ma\u00dfnahmen:\t" + TimeFormatter.getHumanRedableTime((long)durationImportIndividual)));
            LOG.debug((Object)("Duration of importing ma\u00dfnahmen links:\t" + TimeFormatter.getHumanRedableTime((long)durationImportMnLinks)));
            LOG.debug((Object)("Duration of importing links between bausteine and persons:\t" + TimeFormatter.getHumanRedableTime((long)durationImportBstPrsnLinks)));
            LOG.debug((Object)("Duration of importing links between zielobjekte:\t" + TimeFormatter.getHumanRedableTime((long)durationImportZoLinks)));
            LOG.debug((Object)("Duration of importing schutzbedarf:\t" + TimeFormatter.getHumanRedableTime((long)durationImportSB)));
            LOG.debug((Object)("Duration of importing links between zielobjekte and bausteine:\t" + TimeFormatter.getHumanRedableTime((long)durationImportBstRef)));
        }
        return sourceId;
    }

    private List<ITVerbund> importItVerbuende(String sourceId, List<ZielobjektTypeResult> zielobjekte) throws CommandException, CnATreeElementBuildException {
        ArrayList<ITVerbund> neueVerbuende = new ArrayList<ITVerbund>();
        for (ZielobjektTypeResult zielobjekt : zielobjekte) {
            if (!"itverbund".equals(GstoolTypeMapper.getVeriniceTypeOrDefault(zielobjekt.type, zielobjekt.subtype))) continue;
            ITVerbund itverbund = (ITVerbund)CnAElementFactory.getInstance().saveNew((CnATreeElement)CnAElementFactory.getLoadedModel(), "itverbund", null, false);
            itverbund.setSourceId(sourceId);
            neueVerbuende.add(itverbund);
            this.monitor.worked(1);
            ++this.numberImported;
            this.alleZielobjekte.put(zielobjekt.zielobjekt.getId(), (CnATreeElement)itverbund);
            TransferData.transfer((ITVerbund)itverbund, (ZielobjektTypeResult)zielobjekt);
            this.createBausteine(sourceId, (CnATreeElement)itverbund, zielobjekt.zielobjekt);
            List itvLinks = this.getGstoolDao().findLinksByZielobjektId(zielobjekt.zielobjekt.getId());
            for (NZielobjekt nZielobjekt : itvLinks) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Saving Zuordnung from ZO" + nZielobjekt.getName() + "(GUID " + nZielobjekt.getGuid() + ") to ITVerbund " + zielobjekt.zielobjekt.getName()));
                }
                this.itverbundZuordnung.put(nZielobjekt.getGuid(), zielobjekt.zielobjekt.getId());
            }
        }
        return neueVerbuende;
    }

    private Collection<MassnahmenUmsetzung> createIndividualMassnahmen() throws CommandException {
        HashMap<String, MassnahmeInformationTransfer> massnahmenInfos = new HashMap<String, MassnahmeInformationTransfer>();
        for (List<BausteineMassnahmenResult> bausteineMassnahmenResultList : this.individualMassnahmenMap.values()) {
            massnahmenInfos.putAll(this.createIndividualMassnahmenForBausteineMassnahmenResult(bausteineMassnahmenResultList));
        }
        ImportIndividualMassnahmen command = new ImportIndividualMassnahmen(this.individualMassnahmenMap, this.alleMassnahmen, this.allCatalogueBausteine, massnahmenInfos);
        command = (ImportIndividualMassnahmen)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        CnAElementHome.getInstance().update(new ArrayList(command.getChangedElements()));
        return command.getChangedElements();
    }

    private Map<String, MassnahmeInformationTransfer> createIndividualMassnahmenForBausteineMassnahmenResult(List<BausteineMassnahmenResult> bausteineMassnahmenResultList) {
        HashMap<String, MassnahmeInformationTransfer> massnahmenInfos = new HashMap<String, MassnahmeInformationTransfer>();
        for (BausteineMassnahmenResult bausteineMassnahmenResult : bausteineMassnahmenResultList) {
            String identifier = TransferData.createBausteineMassnahmenResultIdentifier((BausteineMassnahmenResult)bausteineMassnahmenResult);
            if (massnahmenInfos.containsKey(identifier)) continue;
            MassnahmeInformationTransfer massnahmeInformationTransfer = this.getGstoolDao().findTxtforMbMassn(bausteineMassnahmenResult.massnahme, GSScraperUtil.getInstance().getModel().getEncoding());
            massnahmenInfos.put(identifier, massnahmeInformationTransfer);
        }
        return massnahmenInfos;
    }

    private List<ZielobjektTypeResult> findZielobjekte() throws Exception {
        List zielobjekte;
        try {
            zielobjekte = this.getGstoolDao().findZielobjektTypAll();
        }
        catch (SQLGrammarException e) {
            SQLGrammarException sqlException = e;
            if (sqlException.getSQLException().getMessage().indexOf("GEF_OK") > -1) {
                ExceptionUtil.log(sqlException.getSQLException(), "Fehler beim Laden der Zielobjekte. M\u00f6glicherweise falsche Datenbankversion des GSTOOL? \nEs wird nur der Import der aktuellen Version (4.7) des GSTOOL unterst\u00fctzt.");
            }
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.log(e, "Fehler beim Laden der Zielobjekte");
            throw e;
        }
        return zielobjekte;
    }

    private void createBausteinReferences(CnATreeElement element, NZielobjektId zielobjektId) throws CommandException {
        if (!this.importBausteine) {
            return;
        }
        long startTime = System.currentTimeMillis();
        List<BausteineMassnahmenResult> findBausteinMassnahmenByZielobjekt = null;
        findBausteinMassnahmenByZielobjekt = this.nZielObjektBausteineMassnahmenResultMap.containsKey(zielobjektId) ? this.nZielObjektBausteineMassnahmenResultMap.get(zielobjektId) : Collections.emptyList();
        findBausteinMassnahmenByZielobjekt = this.reduceBausteinMassnahmeResultToOnePerBaustein(findBausteinMassnahmenByZielobjekt);
        for (BausteineMassnahmenResult bausteineMassnahmenResult : findBausteinMassnahmenByZielobjekt) {
            List targetIds = this.getGstoolDao().findReferencedZobsByBaustein(bausteineMassnahmenResult.zoBst, zielobjektId.getZobId());
            Set<CnATreeElement> targets = this.getCnATreeElementsById(targetIds);
            BausteinUmsetzung bu = this.getVeriniceBausteinUmsetzung(bausteineMassnahmenResult, element);
            if (bu != null) {
                this.createReferencesForBausteinUmsetzung(element, targets, bu);
                continue;
            }
            LOG.warn((Object)("BausteinUmsetzung with Nr.:" + bausteineMassnahmenResult.baustein.getNr() + " not found for element " + element.getTitle()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time computing references for element <" + element.getTitle() + ">:\t" + (System.currentTimeMillis() - startTime) / 1000L + "s"));
        }
    }

    private void createReferencesForBausteinUmsetzung(CnATreeElement element, Set<CnATreeElement> targets, BausteinUmsetzung bu) throws CommandException {
        HashSet<CnATreeElement> filteredTargets = new HashSet<CnATreeElement>();
        StringBuilder sb = new StringBuilder();
        for (CnATreeElement target : targets) {
            sb.append(bu.hashCode()).append("#").append(target.hashCode());
            if (!this.createdLinks.contains(sb.toString())) {
                filteredTargets.add(target);
            }
            sb.setLength(0);
        }
        ImportCreateBausteinReferences2 command = new ImportCreateBausteinReferences2((CnATreeElement)bu, filteredTargets);
        long commandStart = System.currentTimeMillis();
        command = (ImportCreateBausteinReferences2)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        this.createdLinks.addAll(command.getCreatedLinksIdentifier());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time executing command on element <" + element.getTitle() + ">:\t" + (System.currentTimeMillis() - commandStart) / 1000L + "s"));
        }
    }

    private Set<CnATreeElement> getCnATreeElementsById(List<Integer> targetIds) {
        HashSet<CnATreeElement> targets = new HashSet<CnATreeElement>(targetIds.size());
        for (Integer targetId : targetIds) {
            CnATreeElement mappedElement = this.getCnATreeElementByZobId(targetId);
            if (mappedElement == null) continue;
            targets.add(mappedElement);
        }
        return targets;
    }

    private List<BausteineMassnahmenResult> reduceBausteinMassnahmeResultToOnePerBaustein(List<BausteineMassnahmenResult> inputList) {
        long startTime = System.currentTimeMillis();
        HashMap<Integer, BausteineMassnahmenResult> map = new HashMap<Integer, BausteineMassnahmenResult>();
        for (BausteineMassnahmenResult bausteineMassnahmenResult : inputList) {
            if (map.containsKey(bausteineMassnahmenResult.baustein.getId().getBauId())) continue;
            map.put(bausteineMassnahmenResult.baustein.getId().getBauId(), bausteineMassnahmenResult);
        }
        ArrayList<BausteineMassnahmenResult> reducedList = new ArrayList<BausteineMassnahmenResult>(map.size());
        reducedList.addAll(map.values());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reduced BausteineMassnahmenList from " + inputList.size() + " to " + reducedList.size()));
            LOG.debug((Object)("Time needed for Reducing:\t" + (System.currentTimeMillis() - startTime) / 1000L + "s"));
        }
        return reducedList;
    }

    private boolean mbBausteinEquals(MbBaust mbB1, MbBaust mbB2) {
        return mbB1.getNr().equals(mbB2.getNr()) && mbB1.getId().getBauId().equals(mbB2.getId().getBauId());
    }

    private BausteinUmsetzung getVeriniceBausteinUmsetzung(BausteineMassnahmenResult bausteineMassnahmeResult, CnATreeElement parent) {
        for (Map.Entry<MbBaust, BausteinUmsetzung> entry : this.alleBausteineToBausteinUmsetzungMap.entrySet()) {
            BausteinUmsetzung bausteinUmsetzung;
            MbBaust mbBKey = entry.getKey();
            if (!this.mbBausteinEquals(mbBKey, bausteineMassnahmeResult.baustein) || !parent.equals((Object)(bausteinUmsetzung = entry.getValue()).getParent())) continue;
            return bausteinUmsetzung;
        }
        return null;
    }

    private CnATreeElement getCnATreeElementByZobId(Integer zobId) {
        for (Map.Entry<NZielobjektId, CnATreeElement> entry : this.alleZielobjekte.entrySet()) {
            NZielobjektId zielobjektId = entry.getKey();
            if (!zobId.equals(zielobjektId.getZobId())) continue;
            return entry.getValue();
        }
        return null;
    }

    private void importSchutzbedarf() throws Exception {
        if (!this.schutzbedarf) {
            return;
        }
        this.monitor.beginTask("Importiere Schutzbedarf f\u00fcr alle Zielobjekte...", this.alleZielobjekte.size());
        Set<Map.Entry<NZielobjektId, CnATreeElement>> alleZielobjekteEntries = this.alleZielobjekte.entrySet();
        for (Map.Entry<NZielobjektId, CnATreeElement> entry : alleZielobjekteEntries) {
            this.handleSchutzBedarfForSingleElement(entry);
        }
    }

    private void handleSchutzBedarfForSingleElement(Map.Entry<NZielobjektId, CnATreeElement> entry) throws CommandException {
        if (entry.getValue().getProtectionRequirementsProvider() != null) {
            List internalSchutzbedarf = this.getGstoolDao().findSchutzbedarfByZielobjektId(entry.getKey());
            for (NZobSb schubeda : internalSchutzbedarf) {
                this.transferSchutzBedarfGeneral(entry, schubeda);
            }
        } else if ("netzkomponente".equals(entry.getValue().getTypeId())) {
            this.transferSchutzBedarfNetzkomponente(entry);
        }
    }

    private void transferSchutzBedarfNetzkomponente(Map.Entry<NZielobjektId, CnATreeElement> entry) throws CommandException {
        List internalSchutzbedarf = this.getGstoolDao().findSchutzbedarfByZielobjektId(entry.getKey());
        if (internalSchutzbedarf.size() == 1) {
            NZobSb nzobSb = (NZobSb)internalSchutzbedarf.get(0);
            boolean uebertragung = nzobSb.getZsbUebertragung().equals((byte)1);
            boolean angebunden = nzobSb.getZsbAngebunden().equals((byte)1);
            boolean vertraulich = nzobSb.getZsbVertraulich().equals((byte)1);
            boolean integritaet = nzobSb.getZsbIntegritaet().equals((byte)1);
            boolean verfuegbar = nzobSb.getZsbVerfuegbar().equals((byte)1);
            ImportTransferSchutzbedarf command = new ImportTransferSchutzbedarf((NetzKomponente)entry.getValue(), new boolean[]{angebunden, vertraulich, integritaet, verfuegbar, uebertragung});
            ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        } else {
            LOG.warn((Object)("Found more than one schutzbedarfEntry for element:\t" + entry.getValue().getUuid() + "\n=>Will not import Schutzbedarf for this element"));
        }
    }

    private void transferSchutzBedarfGeneral(Map.Entry<NZielobjektId, CnATreeElement> entry, NZobSb schubeda) throws CommandException {
        CnATreeElement element = entry.getValue();
        MSchutzbedarfkategTxt vertr = this.getGstoolDao().findSchutzbedarfNameForId(schubeda.getZsbVertrSbkId());
        MSchutzbedarfkategTxt verfu = this.getGstoolDao().findSchutzbedarfNameForId(schubeda.getZsbVerfuSbkId());
        MSchutzbedarfkategTxt integ = this.getGstoolDao().findSchutzbedarfNameForId(schubeda.getZsbIntegSbkId());
        int vertraulichkeit = vertr != null ? Schutzbedarf.toInt((String)element.getTypeId(), (String)(String.valueOf(element.getTypeId()) + "_vertraulichkeit"), (String)vertr.getName()) : 0;
        int verfuegbarkeit = verfu != null ? Schutzbedarf.toInt((String)element.getTypeId(), (String)(String.valueOf(element.getTypeId()) + "_verfuegbarkeit"), (String)verfu.getName()) : 0;
        int integritaet = integ != null ? Schutzbedarf.toInt((String)element.getTypeId(), (String)(String.valueOf(element.getTypeId()) + "_integritaet"), (String)integ.getName()) : 0;
        String vertrBegruendung = schubeda.getZsbVertrBegr();
        String verfuBegruendung = schubeda.getZsbVerfuBegr();
        String integBegruendung = schubeda.getZsbIntegBegr();
        Short isPersonenbezogen = schubeda.getZsbPersDaten();
        if (isPersonenbezogen == null) {
            isPersonenbezogen = 0;
        }
        ImportTransferSchutzbedarf command = new ImportTransferSchutzbedarf(element, vertraulichkeit, verfuegbarkeit, integritaet, vertrBegruendung, verfuBegruendung, integBegruendung, isPersonenbezogen.shortValue());
        ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
    }

    private void importZielobjektVerknuepfungen() throws CommandException {
        if (!this.zielObjekteZielobjekte) {
            return;
        }
        LinkedList<Link> linkList = new LinkedList<Link>();
        for (Map.Entry<NZielobjektId, CnATreeElement> entry : this.alleZielobjekte.entrySet()) {
            this.monitor.worked(1);
            NZielobjektId zielobjektId = entry.getKey();
            CnATreeElement dependant = entry.getValue();
            List dependencies = this.getGstoolDao().findLinksByZielobjektId(zielobjektId);
            for (NZielobjekt dependency : dependencies) {
                CnATreeElement to;
                CnATreeElement from;
                CnATreeElement dependencyElement = this.findZielobjektFor(dependency);
                if (dependencyElement == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Kein Ziel gefunden f\u00fcr Verkn\u00fcpfung von " + dependant.getTitle() + " zu ZO: " + dependency.getName()));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Neue Verkn\u00fcpfung von " + dependant.getTitle() + " zu " + dependencyElement.getTitle()));
                }
                if (dependencyElement instanceof Person || dependencyElement instanceof NetzKomponente || dependant instanceof ITVerbund) {
                    from = dependant;
                    to = dependencyElement;
                } else {
                    from = dependencyElement;
                    to = dependant;
                }
                linkList.add(new Link(from, to));
            }
        }
        LinkCreater linkCreater = new LinkCreater((List<Link>)linkList, this.monitor);
        int n = linkList.size();
        this.monitor.beginTask("Importiere Verkn\u00fcpfungen von Zielobjekten...", n);
        linkCreater.execute();
    }

    private CnATreeElement findZielobjektFor(NZielobjekt dependency) {
        for (Map.Entry<NZielobjektId, CnATreeElement> entry : this.alleZielobjekte.entrySet()) {
            NZielobjektId zielobjektId = entry.getKey();
            if (!zielobjektId.equals((Object)dependency.getId())) continue;
            return entry.getValue();
        }
        return null;
    }

    private void importMassnahmenVerknuepfungen() {
        if (!this.massnahmenPersonen || !this.importBausteine) {
            return;
        }
        this.monitor.beginTask("Verkn\u00fcpfe Ansprechpartner mit Ma\u00dfnahmen...", this.alleMassnahmen.size());
        int n = this.alleMassnahmen.size();
        int current = 1;
        for (Map.Entry<ModZobjBstMass, MassnahmenUmsetzung> entry : this.alleMassnahmen.entrySet()) {
            ModZobjBstMass obm = entry.getKey();
            this.monitor.worked(1);
            this.monitor.subTask(String.valueOf(current) + "/" + n + " - " + entry.getValue().getTitle());
            ++current;
            Set personenSrc = this.getGstoolDao().findVerantowrtlicheMitarbeiterForMassnahme(obm.getId());
            if (personenSrc == null || personenSrc.size() <= 0) continue;
            List<Person> dependencies = this.findPersonen(personenSrc);
            if (dependencies.size() != personenSrc.size()) {
                LOG.warn((Object)"ACHTUNG: Es wurde mindestens eine Person f\u00fcr die zu verkn\u00fcpfenden Verantwortlichen nicht gefunden.");
            }
            MassnahmenUmsetzung dependantMassnahme = entry.getValue();
            for (Person personToLink : dependencies) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Verkn\u00fcpfe Massnahme " + dependantMassnahme.getTitle() + " mit Person " + personToLink.getTitle()));
                }
                dependantMassnahme.addUmsetzungDurch(personToLink);
            }
        }
    }

    private void importBausteinPersonVerknuepfungen() {
        HashSet<BausteinUmsetzung> changedElements = new HashSet<BausteinUmsetzung>();
        if (!this.bausteinPersonen || !this.importBausteine) {
            return;
        }
        this.monitor.beginTask("Verkn\u00fcpfe Personen mit Bausteinen...", this.alleBausteineToBausteinUmsetzungMap.size());
        for (Map.Entry<MbBaust, BausteinUmsetzung> entry : this.alleBausteineToBausteinUmsetzungMap.entrySet()) {
            Set befragteMitarbeiter;
            this.monitor.worked(1);
            MbBaust mbBaust = entry.getKey();
            BausteinUmsetzung bausteinUmsetzung = entry.getValue();
            if (bausteinUmsetzung == null) continue;
            ModZobjBst modZobjBst = this.alleBausteineToZoBstMap.get(mbBaust);
            NZielobjekt interviewer = modZobjBst.getNZielobjektByFkZbZ2();
            if (interviewer != null) {
                HashSet<NZielobjekt> set = new HashSet<NZielobjekt>();
                set.add(interviewer);
                List<Person> personen = this.findPersonen(set);
                if (personen != null && !personen.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Befragung f\u00fcr Baustein " + bausteinUmsetzung.getTitle() + " durchgef\u00fchrt von " + personen.get(0)));
                    }
                    bausteinUmsetzung.addBefragungDurch(personen.get(0));
                    changedElements.add(bausteinUmsetzung);
                }
            }
            if ((befragteMitarbeiter = this.getGstoolDao().findBefragteMitarbeiterForBaustein(modZobjBst.getId())) == null || befragteMitarbeiter.isEmpty()) continue;
            List<Person> dependencies = this.findPersonen(befragteMitarbeiter);
            if (dependencies.size() != befragteMitarbeiter.size()) {
                LOG.warn((Object)"ACHTUNG: Es wurde mindestens eine Person f\u00fcr die zu verkn\u00fcpfenden Interviewpartner nicht gefunden.");
            }
            this.monitor.subTask(bausteinUmsetzung.getTitle());
            for (Person personToLink : dependencies) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Verkn\u00fcpfe Baustein " + bausteinUmsetzung.getTitle() + " mit befragter Person " + personToLink.getTitle()));
                }
                bausteinUmsetzung.addBefragtePersonDurch(personToLink);
                changedElements.add(bausteinUmsetzung);
            }
        }
    }

    private List<Person> findPersonen(Set<NZielobjekt> personen) {
        ArrayList<Person> result = new ArrayList<Person>(personen.size());
        for (NZielobjekt nzielobjekt : personen) {
            NZielobjektId identifier = nzielobjekt.getId();
            Person person = this.allePersonenByNZielobjektId.get(identifier);
            if (person == null) continue;
            result.add(person);
        }
        return result;
    }

    private CnATreeElement createBausteine(String sourceId, CnATreeElement element, NZielobjekt zielobjekt) throws CommandException {
        if (!this.importBausteine) {
            return element;
        }
        List findBausteinMassnahmenByZielobjekt = this.getGstoolDao().findBausteinMassnahmenByZielobjekt(zielobjekt);
        this.nZielObjektBausteineMassnahmenResultMap.put(zielobjekt.getId(), findBausteinMassnahmenByZielobjekt);
        Map bausteineMassnahmenMap = TransferData.convertBausteinMap((List)findBausteinMassnahmenByZielobjekt);
        this.monitor.subTask(String.valueOf(this.numberImported) + "/" + this.numberOfElements + " - Erstelle " + zielobjekt.getName() + " mit " + bausteineMassnahmenMap.size() + " Baust. und " + this.getAnzahlMassnahmen(bausteineMassnahmenMap) + " Ma\u00dfn...");
        HashMap<MbBaust, BausteinInformationTransfer> udBausteineTxtMap = new HashMap<MbBaust, BausteinInformationTransfer>();
        HashMap<MbMassn, MassnahmeInformationTransfer> udBstMassTxtMap = new HashMap<MbMassn, MassnahmeInformationTransfer>();
        HashMap<MbBaust, List<GefaehrdungInformationTransfer>> udBaustGefMap = new HashMap<MbBaust, List<GefaehrdungInformationTransfer>>();
        ServiceFactory.lookupAuthService();
        for (Map.Entry entry : bausteineMassnahmenMap.entrySet()) {
            MbBaust b = (MbBaust)entry.getKey();
            if (b.getId().getBauImpId() != 1) continue;
            this.prepareUserDefinedBausteinImport(zielobjekt, (List)entry.getValue(), udBausteineTxtMap, udBstMassTxtMap, udBaustGefMap, b);
        }
        ImportCreateBausteine command = new ImportCreateBausteine(sourceId, element, bausteineMassnahmenMap, this.zeiten, this.kosten, this.importUmsetzung, udBausteineTxtMap, udBstMassTxtMap, udBaustGefMap, this.allCatalogueBausteine);
        command = (ImportCreateBausteine)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        if (command.getAlleBausteineToBausteinUmsetzungMap() != null) {
            this.alleBausteineToBausteinUmsetzungMap.putAll(command.getAlleBausteineToBausteinUmsetzungMap());
        }
        if (command.getAlleBausteineToZoBstMap() != null) {
            this.alleBausteineToZoBstMap.putAll(command.getAlleBausteineToZoBstMap());
        }
        if (command.getAlleMassnahmen() != null) {
            this.alleMassnahmen.putAll(command.getAlleMassnahmen());
        }
        if (command.getIndividualMassnahmenMap() != null && command.getIndividualMassnahmenMap().size() > 0) {
            this.individualMassnahmenMap.putAll(command.getIndividualMassnahmenMap());
        }
        return command.getChangedElement();
    }

    private void prepareUserDefinedBausteinImport(NZielobjekt zielobjekt, List<BausteineMassnahmenResult> bausteineMassnahmenResultList, Map<MbBaust, BausteinInformationTransfer> udBausteineTxtMap, Map<MbMassn, MassnahmeInformationTransfer> udBstMassTxtMap, Map<MbBaust, List<GefaehrdungInformationTransfer>> udBaustGefMap, MbBaust b) {
        udBausteineTxtMap.put(b, this.getGstoolDao().findTxtForMbBaust(b, zielobjekt, GSScraperUtil.getInstance().getModel().getEncoding()));
        for (BausteineMassnahmenResult r : bausteineMassnahmenResultList) {
            udBstMassTxtMap.put(r.massnahme, this.getGstoolDao().findTxtforMbMassn(r.massnahme, GSScraperUtil.getInstance().getModel().getEncoding()));
        }
        ArrayList<GefaehrdungInformationTransfer> gefaehrdunInformationTransferList = new ArrayList<GefaehrdungInformationTransfer>();
        List mbBaustGefList = this.getGstoolDao().findGefaehrdungenForBaustein(b, zielobjekt);
        for (MbBaustGefaehr gefaehr : mbBaustGefList) {
            GefaehrdungInformationTransfer git = this.getGstoolDao().findGefaehrdungInformationForBausteinGefaehrdung(gefaehr, zielobjekt, GSScraperUtil.getInstance().getModel().getEncoding());
            if (git.getTitel() == null || git.getId() == null) continue;
            gefaehrdunInformationTransferList.add(git);
        }
        if (!gefaehrdunInformationTransferList.isEmpty()) {
            udBaustGefMap.put(b, gefaehrdunInformationTransferList);
        }
    }

    private int getAnzahlMassnahmen(Map<MbBaust, List<BausteineMassnahmenResult>> bausteineMassnahmenMap) {
        int result = 0;
        for (List<BausteineMassnahmenResult> list : bausteineMassnahmenMap.values()) {
            result += list.size();
        }
        return result;
    }

    private CnATreeElement importEsa(ZielobjektTypeResult zielobjekt, CnATreeElement element) throws CommandException {
        List esaResult = this.getGstoolDao().findESAByZielobjekt(zielobjekt.zielobjekt);
        if (esaResult == null || esaResult.isEmpty()) {
            LOG.warn((Object)("No ESA found for zielobjekt" + zielobjekt.zielobjekt.getName()));
            return element;
        }
        if (esaResult.size() > 1) {
            LOG.warn((Object)("Warning: More than one ESA found for zielobjekt" + zielobjekt.zielobjekt.getName() + " Using first one only."));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ESA found for zielobjekt " + zielobjekt.zielobjekt.getName()));
        }
        if (element == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No matching CnaTreeElement to migrate ESA for zielobjekt " + zielobjekt.zielobjekt.getName()));
            }
            return element;
        }
        TransferData.transferESA((CnATreeElement)element, (ESAResult)((ESAResult)esaResult.get(0)));
        CnAElementHome.getInstance().update(element);
        return element;
    }

    private List<Baustein> loadCatalogueBausteine() throws CommandException, IOException, GSServiceException {
        List<Baustein> bausteine;
        IBSIConfig bsiConfig = null;
        if (!ServiceFactory.isPermissionHandlingNeeded()) {
            bsiConfig = BSIConfigFactory.createStandaloneConfig();
        }
        if (bsiConfig == null) {
            LoadBausteine command = new LoadBausteine();
            command = (LoadBausteine)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            bausteine = command.getBausteine();
        } else {
            BSIMassnahmenModel model = GSScraperUtil.getInstance().getModel();
            model.setBSIConfig(bsiConfig);
            bausteine = model.loadBausteine((sernet.verinice.interfaces.IProgress)new NullMonitor());
        }
        if (bausteine == null) {
            bausteine = Collections.emptyList();
        }
        return bausteine;
    }

    private void copyMDBToTempDB(String sourceDbUrl) {
        MDBFileDatabase source = new MDBFileDatabase();
        DerbyDatabase target = new DerbyDatabase();
        try {
            try {
                String tempDbUrl = CnAWorkspace.getInstance().createTempImportDbUrl();
                DataMover mover = new DataMover();
                source.connect("sun.jdbc.odbc.JdbcOdbcDriver", sourceDbUrl);
                target.connect("org.apache.derby.iapi.jdbc.AutoloadedDriver", tempDbUrl);
                mover.setSource(source);
                mover.setTarget(target);
                mover.exportDatabse();
            }
            catch (Exception e) {
                LOG.error((Object)"Error: ", (Throwable)e);
                ExceptionUtil.log(e, "Fehler beim Import aus MDB-Datei \u00fcber tempor\u00e4re Derby-DB.");
                try {
                    source.close();
                    target.close();
                }
                catch (Exception e2) {
                    LOG.debug((Object)"Konnte tempor\u00e4re Import-DB nicht schlie\u00dfen.", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                source.close();
                target.close();
            }
            catch (Exception e) {
                LOG.debug((Object)"Konnte tempor\u00e4re Import-DB nicht schlie\u00dfen.", (Throwable)e);
            }
        }
    }

    public boolean delete(File dir) {
        if (dir.isDirectory()) {
            String[] subdirs = dir.list();
            int i = 0;
            while (i < subdirs.length) {
                boolean success = this.delete(new File(dir, subdirs[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public String getSourceId() {
        return this.sourceId;
    }
}

