/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Preferences;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.IGSModel;
import sernet.gs.reveng.MbGefaehr;
import sernet.gs.reveng.importData.GSDBConstants;
import sernet.gs.reveng.importData.GSVampire;
import sernet.gs.reveng.importData.RAGefaehrdungenResult;
import sernet.gs.reveng.importData.RAGefaehrdungsMassnahmenResult;
import sernet.gs.reveng.importData.ZielobjektTypeResult;
import sernet.gs.ui.rcp.gsimport.AbstractGstoolImportTask;
import sernet.gs.ui.rcp.gsimport.IProgress;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.OwnGefaehrdungHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.RisikoMassnahmeHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.RisikoMassnahmenUmsetzungFactory;
import sernet.gs.ui.rcp.main.bsi.views.BSIKatalogInvisibleRoot;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.snutils.DBException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.FinishedRiskAnalysis;
import sernet.verinice.model.bsi.risikoanalyse.FinishedRiskAnalysisLists;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.OwnGefaehrdung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahme;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.LoadCnAElementByExternalID;
import sernet.verinice.service.commands.risk.AddMassnahmeToGefaherdung;
import sernet.verinice.service.commands.risk.AssociateGefaehrdungsUmsetzung;
import sernet.verinice.service.commands.risk.NegativeEstimateGefaehrdung;
import sernet.verinice.service.commands.risk.SelectRiskTreatment;
import sernet.verinice.service.commands.risk.StartNewRiskAnalysis;
import sernet.verinice.service.gstoolimport.TransferData;
import sernet.verinice.service.parser.GSScraperUtil;

public class ImportRisikoanalysenTask
extends AbstractGstoolImportTask {
    private static final Logger LOG = Logger.getLogger(ImportRisikoanalysenTask.class);
    private IProgress monitor;
    private TransferData transferData;
    private int numberOfRAs;
    private String sourceID;
    private FinishedRiskAnalysis riskAnalysis;
    private FinishedRiskAnalysisLists riskAnalysisLists;
    private Map<String, Gefaehrdung> allCreatedOwnGefaehrdungen;
    private Map<String, RisikoMassnahme> allCreatedOwnMassnahmen;
    private Map<String, Gefaehrdung> allBsiGefaehrdungen = new HashMap<String, Gefaehrdung>();

    public ImportRisikoanalysenTask(String sourceID) {
        this.sourceID = sourceID;
        this.allCreatedOwnGefaehrdungen = new HashMap<String, Gefaehrdung>();
        this.allCreatedOwnMassnahmen = new HashMap<String, RisikoMassnahme>();
    }

    @Override
    public void executeTask(int importType, IProgress monitor) throws Exception {
        this.loadGefaehrdungen();
        this.loadMassnahmen();
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        String sourceDbUrl = prefs.getString("gs_cna_dburl");
        if (sourceDbUrl.indexOf("odbc") > -1) {
            throw new DBException("Kann nicht direkt aus MDB-Datei importieren. Datenbank vorher anh\u00e4ngen in Men\u00fc \"Bearbeiten, Einstellungen\".");
        }
        this.monitor = monitor;
        this.transferData = new TransferData(this.getGstoolDao(), false);
        this.importRisikoanalysen();
    }

    private void importRisikoanalysen() throws CommandException, SQLException, IOException {
        List allZielobjekte = this.getGstoolDao().findZielobjektWithRA();
        this.numberOfRAs = allZielobjekte.size();
        this.monitor.beginTask("Importiere Risikoanalysen...", this.numberOfRAs);
        int i = 1;
        for (ZielobjektTypeResult zielobjekt : allZielobjekte) {
            this.importRisikoanalyse(zielobjekt, i);
            ++i;
        }
    }

    private void importRisikoanalyse(ZielobjektTypeResult zielobjekt, int i) throws CommandException, SQLException, IOException {
        String name = zielobjekt.zielobjekt.getName();
        this.monitor.worked(1);
        this.monitor.subTask(String.valueOf(i) + "/" + this.numberOfRAs + " - Zielobjekt: " + name);
        CnATreeElement element = this.findCnaTreeElementByGstoolGuid(zielobjekt.zielobjekt.getGuid());
        if (element == null) {
            return;
        }
        List gefaehrdungenForZielobjekt = this.getGstoolDao().findRAGefaehrdungenForZielobjekt(zielobjekt.zielobjekt);
        if (gefaehrdungenForZielobjekt == null || gefaehrdungenForZielobjekt.size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No gefaehrungen found, not creating risk analysis object for " + zielobjekt.zielobjekt.getName()));
            }
            return;
        }
        if (this.allBsiGefaehrdungen == null || this.allBsiGefaehrdungen.size() == 0) {
            this.loadAllBSIGefaehrdungen();
        }
        StartNewRiskAnalysis startRiskAnalysis = new StartNewRiskAnalysis(element);
        startRiskAnalysis = (StartNewRiskAnalysis)ServiceFactory.lookupCommandService().executeCommand((ICommand)startRiskAnalysis);
        this.riskAnalysis = startRiskAnalysis.getFinishedRiskAnalysis();
        this.riskAnalysisLists = startRiskAnalysis.getFinishedRiskLists();
        this.importGefaehrdungen(zielobjekt, element, gefaehrdungenForZielobjekt);
        CnAElementHome.getInstance().update((CnATreeElement)this.riskAnalysis);
    }

    private void importGefaehrdungen(ZielobjektTypeResult zielobjekt, CnATreeElement element, List<RAGefaehrdungenResult> gefaehrdungenForZielobjekt) throws SQLException, IOException, CommandException {
        for (RAGefaehrdungenResult gefaehrdungenResult : gefaehrdungenForZielobjekt) {
            GefaehrdungsUmsetzung gefaehrdungsUmsetzung;
            Gefaehrdung gefaehrdung = this.createGefaehrdung(gefaehrdungenResult);
            if (gefaehrdung == null || (gefaehrdungsUmsetzung = this.addGefaehrdungToRiskAnalysis(gefaehrdungenResult, gefaehrdung)) == null) continue;
            if (!gefaehrdungsUmsetzung.getOkay().booleanValue()) {
                gefaehrdungsUmsetzung = this.setNegativeEstimated(gefaehrdungsUmsetzung);
            }
            if (gefaehrdungenResult.getRisikobehandlungABCD() != GSDBConstants.RA_BEHAND_A_REDUKTION) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading massnahmen for gefaehrdung " + gefaehrdungsUmsetzung.getTitle()));
            }
            List ragmResults = this.getGstoolDao().findRAGefaehrdungsMassnahmenForZielobjekt(zielobjekt.zielobjekt, gefaehrdungenResult.getGefaehrdung());
            for (RAGefaehrdungsMassnahmenResult massnahmenResult : ragmResults) {
                this.importMassnahme(element, massnahmenResult, gefaehrdungsUmsetzung);
            }
        }
    }

    private Gefaehrdung createGefaehrdung(RAGefaehrdungenResult gefaehrdungenResult) throws SQLException, IOException, CommandException {
        Gefaehrdung gefaehrdung = null;
        if (TransferData.isUserDefGefaehrdung((MbGefaehr)gefaehrdungenResult.getGefaehrdung())) {
            OwnGefaehrdung ownGefaehrdung = new OwnGefaehrdung();
            TransferData.transferOwnGefaehrdung((OwnGefaehrdung)ownGefaehrdung, (RAGefaehrdungenResult)gefaehrdungenResult);
            String cacheId = this.createOwnGefaehrdungsCacheId(ownGefaehrdung);
            if (this.allCreatedOwnGefaehrdungen.containsKey(cacheId)) {
                gefaehrdung = this.allCreatedOwnGefaehrdungen.get(cacheId);
            } else {
                ownGefaehrdung = OwnGefaehrdungHome.getInstance().save(ownGefaehrdung);
                this.allCreatedOwnGefaehrdungen.put(cacheId, (Gefaehrdung)ownGefaehrdung);
                gefaehrdung = ownGefaehrdung;
            }
        } else {
            gefaehrdung = this.findBsiStandardGefaehrdung(gefaehrdungenResult);
            if (gefaehrdung == null) {
                LOG.error((Object)("Keine passende Standard-Gef\u00e4hrdung gefunden in BSI-Katalog f\u00fcr GSTOOL-Gef\u00e4hrdung: " + gefaehrdungenResult.getGefaehrdungTxt().getName()));
            }
        }
        return gefaehrdung;
    }

    private GefaehrdungsUmsetzung addGefaehrdungToRiskAnalysis(RAGefaehrdungenResult gefaehrdungenResult, Gefaehrdung gefaehrdung) throws CommandException, SQLException, IOException {
        AssociateGefaehrdungsUmsetzung associateGefaehrdung = new AssociateGefaehrdungsUmsetzung(this.riskAnalysisLists.getDbId(), gefaehrdung, this.riskAnalysis.getDbId(), "DE");
        associateGefaehrdung = (AssociateGefaehrdungsUmsetzung)ServiceFactory.lookupCommandService().executeCommand((ICommand)associateGefaehrdung);
        GefaehrdungsUmsetzung gefaehrdungsUmsetzung = associateGefaehrdung.getGefaehrdungsUmsetzung();
        TransferData.transferRAGefaehrdungsUmsetzung((GefaehrdungsUmsetzung)gefaehrdungsUmsetzung, (RAGefaehrdungenResult)gefaehrdungenResult);
        gefaehrdungsUmsetzung.setExtId(GSVampire.generateGefaehrdungsUmsetzungExtid((String)String.valueOf(gefaehrdungenResult.getGefaehrdung().getId().getGefId()), (String)String.valueOf(gefaehrdungenResult.getZielobjekt().getId().getZobId()), (String)gefaehrdungenResult.getGefaehrdung().getGuid(), (String)gefaehrdungenResult.getZielobjekt().getGuid()));
        CnAElementHome.getInstance().update((CnATreeElement)gefaehrdungsUmsetzung);
        assert (gefaehrdungsUmsetzung.getExtId() != null);
        return gefaehrdungsUmsetzung;
    }

    private GefaehrdungsUmsetzung setNegativeEstimated(GefaehrdungsUmsetzung gefaehrdungsUmsetzung) throws CommandException {
        NegativeEstimateGefaehrdung negativeEstimateGefaehrdungCommand = new NegativeEstimateGefaehrdung(this.riskAnalysisLists.getDbId(), gefaehrdungsUmsetzung, (CnATreeElement)this.riskAnalysis);
        negativeEstimateGefaehrdungCommand = (NegativeEstimateGefaehrdung)ServiceFactory.lookupCommandService().executeCommand((ICommand)negativeEstimateGefaehrdungCommand);
        this.riskAnalysisLists = negativeEstimateGefaehrdungCommand.getRaList();
        gefaehrdungsUmsetzung = negativeEstimateGefaehrdungCommand.getGefaehrdungsUmsetzung();
        SelectRiskTreatment selectRiskTreatmentCommand = new SelectRiskTreatment(this.riskAnalysisLists.getDbId(), (CnATreeElement)this.riskAnalysis, gefaehrdungsUmsetzung, gefaehrdungsUmsetzung.getAlternative());
        selectRiskTreatmentCommand = (SelectRiskTreatment)ServiceFactory.lookupCommandService().executeCommand((ICommand)selectRiskTreatmentCommand);
        this.riskAnalysisLists = selectRiskTreatmentCommand.getFinishedRiskLists();
        return gefaehrdungsUmsetzung;
    }

    private void importMassnahme(CnATreeElement element, RAGefaehrdungsMassnahmenResult massnahmenResult, GefaehrdungsUmsetzung gefaehrdungsUmsetzung) throws SQLException, IOException, CommandException {
        RisikoMassnahmenUmsetzung risikoMassnahme = null;
        risikoMassnahme = TransferData.isUserDefMassnahme((RAGefaehrdungsMassnahmenResult)massnahmenResult) ? this.importUserMassnahme(element, massnahmenResult, gefaehrdungsUmsetzung) : this.importBsiMassnahme(element, massnahmenResult, gefaehrdungsUmsetzung);
        if (risikoMassnahme != null) {
            AddMassnahmeToGefaherdung command = new AddMassnahmeToGefaherdung(gefaehrdungsUmsetzung, risikoMassnahme);
            command = (AddMassnahmeToGefaherdung)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            risikoMassnahme = command.getChild();
        }
    }

    private RisikoMassnahmenUmsetzung importUserMassnahme(CnATreeElement element, RAGefaehrdungsMassnahmenResult massnahmenResult, GefaehrdungsUmsetzung gefaehrdungsUmsetzung) throws SQLException, IOException, CommandException {
        RisikoMassnahmenUmsetzung risikoMassnahme = new RisikoMassnahmenUmsetzung(element, gefaehrdungsUmsetzung);
        TransferData.transferRAGefaehrdungsMassnahmen((RAGefaehrdungsMassnahmenResult)massnahmenResult, (MassnahmenUmsetzung)risikoMassnahme);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Transferred user defined massnahme: " + risikoMassnahme.getTitle()));
        }
        RisikoMassnahme newRisikoMassnahme = new RisikoMassnahme();
        newRisikoMassnahme.setNumber(risikoMassnahme.getKapitel());
        newRisikoMassnahme.setName(risikoMassnahme.getName());
        newRisikoMassnahme.setDescription(TransferData.convertClobToStringEncodingSave((Clob)massnahmenResult.getMassnahmeTxt().getBeschreibung(), (String)GSScraperUtil.getInstance().getModel().getEncoding()));
        String key = this.createOwnMassnahmeCacheId(newRisikoMassnahme);
        if (!this.allCreatedOwnMassnahmen.containsKey(key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Saving new user defined massnahme to database.");
            }
            RisikoMassnahmeHome.getInstance().save(newRisikoMassnahme);
            this.allCreatedOwnMassnahmen.put(key, newRisikoMassnahme);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Transferred user defined massnahme: " + risikoMassnahme.getTitle()));
        }
        return risikoMassnahme;
    }

    private RisikoMassnahmenUmsetzung importBsiMassnahme(CnATreeElement element, RAGefaehrdungsMassnahmenResult massnahmenResult, GefaehrdungsUmsetzung gefaehrdungsUmsetzung) throws SQLException, IOException {
        MassnahmenUmsetzung newMnUms = new MassnahmenUmsetzung((CnATreeElement)gefaehrdungsUmsetzung);
        TransferData.transferRAGefaehrdungsMassnahmen((RAGefaehrdungsMassnahmenResult)massnahmenResult, (MassnahmenUmsetzung)newMnUms);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Transferred BSI-standard massnahme: " + newMnUms.getTitle()));
        }
        RisikoMassnahmenUmsetzung risikoMassnahme = RisikoMassnahmenUmsetzungFactory.buildFromMassnahmenUmsetzung(newMnUms, element, null);
        return risikoMassnahme;
    }

    private Gefaehrdung findBsiStandardGefaehrdung(RAGefaehrdungenResult ragResult) {
        String gefName = ragResult.getGefaehrdungTxt().getName();
        return this.allBsiGefaehrdungen.get(gefName);
    }

    private void loadGefaehrdungen() throws CommandException {
        List<OwnGefaehrdung> allGefaehrdungen = OwnGefaehrdungHome.getInstance().loadAll();
        for (OwnGefaehrdung ownGefaehrdung : allGefaehrdungen) {
            String cacheId = this.createOwnGefaehrdungsCacheId(ownGefaehrdung);
            this.allCreatedOwnGefaehrdungen.put(cacheId, (Gefaehrdung)ownGefaehrdung);
        }
    }

    private void loadMassnahmen() throws CommandException {
        List<RisikoMassnahme> allMassnahmen = RisikoMassnahmeHome.getInstance().loadAll();
        for (RisikoMassnahme massnahme : allMassnahmen) {
            String cacheId = this.createOwnMassnahmeCacheId(massnahme);
            this.allCreatedOwnMassnahmen.put(cacheId, massnahme);
        }
    }

    private void loadAllBSIGefaehrdungen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Caching all BSI standard Gefaehrdungen from catalog...");
        }
        List<Baustein> bausteine = BSIKatalogInvisibleRoot.getInstance().getBausteine();
        for (Baustein baustein : bausteine) {
            if (baustein.getGefaehrdungen() == null) continue;
            for (Gefaehrdung gefaehrdung : baustein.getGefaehrdungen()) {
                Boolean duplicate = false;
                for (IGSModel iGSModel : this.allBsiGefaehrdungen.values()) {
                    if (!iGSModel.getId().equals(gefaehrdung.getId())) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate.booleanValue()) continue;
                this.allBsiGefaehrdungen.put(gefaehrdung.getTitel(), gefaehrdung);
            }
        }
    }

    private String createOwnGefaehrdungsCacheId(OwnGefaehrdung ownGefaehrdung) {
        return String.valueOf(ownGefaehrdung.getId()) + ownGefaehrdung.getTitel() + ownGefaehrdung.getBeschreibung();
    }

    private String createOwnMassnahmeCacheId(RisikoMassnahme riskMn) {
        return String.valueOf(riskMn.getId()) + riskMn.getName() + riskMn.getDescription();
    }

    private CnATreeElement findCnaTreeElementByGstoolGuid(String guid) throws CommandException {
        LoadCnAElementByExternalID command = new LoadCnAElementByExternalID(this.sourceID, guid, false, false);
        command.setProperties(true);
        command = (LoadCnAElementByExternalID)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        List elementList = command.getElements();
        if (elementList == null || elementList.size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("NOT found: CnaTreeElmt with sourceID " + this.sourceID + " and extID " + guid + "..."));
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found: CnaTreeElmt with sourceID " + this.sourceID + " and extID " + guid + "..."));
        }
        return (CnATreeElement)elementList.get(0);
    }
}

