/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import sernet.gs.reveng.importData.ZielobjektTypeResult;
import sernet.gs.ui.rcp.gsimport.AbstractGstoolImportTask;
import sernet.gs.ui.rcp.gsimport.GstoolTypeMapper;
import sernet.gs.ui.rcp.gsimport.IProgress;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.snutils.DBException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.service.commands.task.ImportNotesForZielobjekt;
import sernet.verinice.service.gstoolimport.TransferData;

public class ImportNotesTask
extends AbstractGstoolImportTask {
    private IProgress monitor;

    @Override
    public void executeTask(int importType, IProgress monitor) throws DBException, CommandException {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        String sourceDbUrl = prefs.getString("gs_cna_dburl");
        if (sourceDbUrl.indexOf("odbc") > -1) {
            throw new DBException("Kann nicht direkt aus MDB-Datei importieren. Datenbank vorher anh\u00e4ngen in Men\u00fc \"Bearbeiten, Einstellungen\".");
        }
        this.monitor = monitor;
        this.importNotes();
    }

    private void importNotes() throws CommandException {
        List allZielobjekte = this.getGstoolDao().findZielobjektTypAll();
        int n = allZielobjekte.size();
        int i = 0;
        this.monitor.beginTask("Importiere Notizen", n);
        for (ZielobjektTypeResult zielobjekt : allZielobjekte) {
            String name = zielobjekt.zielobjekt.getName();
            this.monitor.worked(1);
            this.monitor.subTask(String.valueOf(++i) + "/" + n + " - Zielobjekt: " + name);
            List notesResults = this.getGstoolDao().findNotizenForZielobjekt(name);
            if (notesResults.isEmpty()) continue;
            Map notizenMap = TransferData.convertZielobjektNotizenMap((List)notesResults);
            String importedObjectTypeId = GstoolTypeMapper.getVeriniceTypeOrDefault(zielobjekt.type, zielobjekt.subtype);
            ImportNotesForZielobjekt command = new ImportNotesForZielobjekt(name, importedObjectTypeId, notizenMap);
            ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        }
    }
}

