/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.reveng.importData.ZielobjektTypeResult;
import sernet.gs.ui.rcp.gsimport.GstoolTypeMapper;
import sernet.gs.ui.rcp.gsimport.GstoolTypeNotFoundException;
import sernet.gs.ui.rcp.gsimport.UnknownTypeDialog;

public class GstoolTypeValidator {
    private boolean result = true;
    private Set<String> unknownTypes;
    private Shell shell;

    public GstoolTypeValidator() {
    }

    public GstoolTypeValidator(Shell shell) {
        this.shell = shell;
    }

    public boolean validate(List<ZielobjektTypeResult> zielobjektTypeList) {
        this.unknownTypes = new HashSet<String>();
        for (ZielobjektTypeResult zielobjektType : zielobjektTypeList) {
            this.validate(zielobjektType.type, zielobjektType.subtype);
        }
        if (!this.unknownTypes.isEmpty()) {
            this.showCancelDialog();
        }
        return this.result;
    }

    public boolean validate(String gstoolType, String gstoolSubtype) {
        try {
            GstoolTypeMapper.getVeriniceType(gstoolType, gstoolSubtype);
        }
        catch (GstoolTypeNotFoundException e) {
            this.addToUnknownTypes(gstoolType, gstoolSubtype);
            return false;
        }
        return true;
    }

    private boolean showCancelDialog() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UnknownTypeDialog dialog = new UnknownTypeDialog(GstoolTypeValidator.this.getShell(), GstoolTypeValidator.this.unknownTypes);
                GstoolTypeValidator.this.result = dialog.open();
            }
        });
        return this.result;
    }

    private void addToUnknownTypes(String gstoolType, String gstoolSubtype) {
        if (this.unknownTypes == null) {
            this.unknownTypes = new HashSet<String>();
        }
        this.unknownTypes.add(gstoolSubtype);
    }

    public Shell getShell() {
        if (this.shell == null) {
            return Display.getCurrent().getActiveShell();
        }
        return this.shell;
    }
}

