/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import sernet.gs.service.VeriniceCharset;
import sernet.gs.ui.rcp.gsimport.GstoolImportMappingElement;
import sernet.gs.ui.rcp.gsimport.GstoolTypeNotFoundException;
import sernet.gs.ui.rcp.gsimport.IGstoolImportMappingChangeListener;
import sernet.gs.ui.rcp.main.CnAWorkspace;

public abstract class GstoolTypeMapper {
    private static final Logger LOG = Logger.getLogger(GstoolTypeMapper.class);
    public static final String TYPE_PROPERTIES_FILE = "gstool-types.properties";
    public static final String SUBTYPE_PROPERTIES_FILE = "gstool-subtypes.properties";
    public static final Charset SUBTYPE_PROPERTIES_FILE_ENCODING = VeriniceCharset.CHARSET_ISO_8859_15;
    public static final String DEFAULT_TYPE_ID = "sonstit";
    private static Map<String, String> gstoolTypes;
    private static Map<String, String> gstoolSubtypesMap;
    private static List<GstoolImportMappingElement> gstoolSubtypesList;
    private static Set<IGstoolImportMappingChangeListener> changeListenerSet;

    public static String getVeriniceTypeOrDefault(String gstoolType, String gstoolSubtype) {
        String type;
        try {
            type = GstoolTypeMapper.getVeriniceType(gstoolType, gstoolSubtype);
        }
        catch (GstoolTypeNotFoundException e) {
            LOG.error((Object)(String.valueOf(e.getMessage()) + ", using default verinice type id instead: " + DEFAULT_TYPE_ID));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Stacktrace: ", (Throwable)e);
            }
            type = DEFAULT_TYPE_ID;
        }
        return type;
    }

    public static String getVeriniceType(String gstoolType, String gstoolSubtype) throws GstoolTypeNotFoundException {
        String type = GstoolTypeMapper.getGstoolTypes().get(gstoolType);
        if (type == null) {
            type = GstoolTypeMapper.getGstoolSubtypes().get(gstoolSubtype);
        }
        if (type == null || type.equals("UNKNOWN")) {
            throw new GstoolTypeNotFoundException("Could not find a type id for GSTOOL type: " + gstoolType + " and sub type: " + gstoolSubtype);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GSTOOL type: '" + gstoolType + "' and subtype: '" + gstoolSubtype + "', returning verinice type: " + type));
        }
        return type;
    }

    public static void addGstoolSubtypeToPropertyFile(GstoolImportMappingElement mappingEntry) {
        Properties properties = GstoolTypeMapper.readPropertyFile(SUBTYPE_PROPERTIES_FILE);
        properties.put(mappingEntry.getKey(), mappingEntry.getValue());
        GstoolTypeMapper.writePropertyFile(properties, SUBTYPE_PROPERTIES_FILE);
        GstoolTypeMapper.fireMappingAddedEvent(mappingEntry);
    }

    public static void removeGstoolSubtypeToPropertyFile(GstoolImportMappingElement oldElement) {
        Properties properties = GstoolTypeMapper.readPropertyFile(SUBTYPE_PROPERTIES_FILE);
        properties.remove(oldElement.getKey());
        GstoolTypeMapper.writePropertyFile(properties, SUBTYPE_PROPERTIES_FILE);
        GstoolTypeMapper.fireMappingRemovedEvent(oldElement);
    }

    public static void editGstoolSubtypeToPropertyFile(GstoolImportMappingElement oldElement, GstoolImportMappingElement mappingEntry) {
        Properties properties = GstoolTypeMapper.readPropertyFile(SUBTYPE_PROPERTIES_FILE);
        properties.remove(oldElement.getKey());
        properties.put(mappingEntry.getKey(), mappingEntry.getValue());
        GstoolTypeMapper.writePropertyFile(properties, SUBTYPE_PROPERTIES_FILE);
        GstoolTypeMapper.fireMappingChangedEvent(mappingEntry);
    }

    private static Map<String, String> getGstoolTypes() {
        if (gstoolTypes == null) {
            gstoolTypes = GstoolTypeMapper.getGstoolTypesFromFile();
        }
        return gstoolTypes;
    }

    private static Map<String, String> getGstoolTypesFromFile() {
        Properties properties = GstoolTypeMapper.readPropertyFile(TYPE_PROPERTIES_FILE);
        Set<Object> keys = properties.keySet();
        gstoolTypes = new HashMap<String, String>();
        for (Object key : keys) {
            gstoolTypes.put((String)key, (String)properties.get(key));
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)("Type added: " + key + " = " + properties.get(key)));
        }
        return gstoolTypes;
    }

    public static Map<String, String> getGstoolSubtypes() {
        if (gstoolSubtypesMap == null) {
            gstoolSubtypesMap = GstoolTypeMapper.getGstoolSubtypesFromFile();
        }
        return gstoolSubtypesMap;
    }

    public static List<GstoolImportMappingElement> getGstoolSubtypesAsList() {
        if (gstoolSubtypesList == null) {
            gstoolSubtypesList = GstoolTypeMapper.getGstoolSubtypesListFromFile();
        }
        return gstoolSubtypesList;
    }

    private static void refreshGstoolSubTypes(Properties properties) {
        gstoolSubtypesMap = GstoolTypeMapper.changePropertiesToMap(properties);
        gstoolSubtypesList = GstoolTypeMapper.changePropertiesToList(properties);
    }

    private static List<GstoolImportMappingElement> changePropertiesToList(Properties properties) {
        ArrayList<GstoolImportMappingElement> gsToolSubtypesList = new ArrayList<GstoolImportMappingElement>();
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            gsToolSubtypesList.add(new GstoolImportMappingElement((String)key, (String)properties.get(key)));
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)("Subtype added: " + key + " = " + properties.get(key)));
        }
        return gsToolSubtypesList;
    }

    private static Map<String, String> changePropertiesToMap(Properties properties) {
        HashMap<String, String> gstoolSubtypesMap = new HashMap<String, String>();
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            gstoolSubtypesMap.put((String)key, (String)properties.get(key));
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)("Subtype added: " + key + " = " + properties.get(key)));
        }
        return gstoolSubtypesMap;
    }

    public static Map<String, String> getGstoolSubtypesFromFile() {
        gstoolSubtypesMap = new HashMap<String, String>();
        Properties subProperties = GstoolTypeMapper.readPropertyFile(SUBTYPE_PROPERTIES_FILE);
        return GstoolTypeMapper.changePropertiesToMap(subProperties);
    }

    public static List<GstoolImportMappingElement> getGstoolSubtypesListFromFile() {
        Properties subProperties = GstoolTypeMapper.readPropertyFile(SUBTYPE_PROPERTIES_FILE);
        return GstoolTypeMapper.changePropertiesToList(subProperties);
    }

    private static void writePropertyFile(Properties properties, String filename) {
        File file = new File(GstoolTypeMapper.getPropertyFolderPath(), filename);
        try {
            if (file.delete() && LOG.isDebugEnabled()) {
                LOG.debug((Object)"File deleted");
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), SUBTYPE_PROPERTIES_FILE_ENCODING, new OpenOption[0]);){
                properties.store(writer, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            GstoolTypeMapper.refreshGstoolSubTypes(properties);
        }
        catch (IOException e) {
            LOG.error((Object)("Error wgile writing to property file: " + filename), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Properties readPropertyFile(String fileName) {
        File file = new File(GstoolTypeMapper.getPropertyFolderPath(), fileName);
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), SUBTYPE_PROPERTIES_FILE_ENCODING);){
                properties.load(reader);
                LOG.debug((Object)("Reading types from " + file + "..."));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Can not read properties from file " + file), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Can not read properties from file " + file), (Throwable)e);
            throw new RuntimeException(e);
        }
        return properties;
    }

    private static File getPropertyFolderPath() {
        return CnAWorkspace.getInstance().getConfDir();
    }

    private static void fireMappingAddedEvent(GstoolImportMappingElement mappingEntry) {
        for (IGstoolImportMappingChangeListener listener : GstoolTypeMapper.getChangeListenerSet()) {
            listener.mappingAdded(mappingEntry);
        }
    }

    private static void fireMappingChangedEvent(GstoolImportMappingElement mappingEntry) {
        for (IGstoolImportMappingChangeListener listener : GstoolTypeMapper.getChangeListenerSet()) {
            listener.mappingChanged(mappingEntry);
        }
    }

    private static void fireMappingRemovedEvent(GstoolImportMappingElement mappingEntry) {
        for (IGstoolImportMappingChangeListener listener : GstoolTypeMapper.getChangeListenerSet()) {
            listener.mappingRemoved(mappingEntry);
        }
    }

    public static void addChangeListener(IGstoolImportMappingChangeListener listener) {
        GstoolTypeMapper.getChangeListenerSet().add(listener);
    }

    public static void removeChangeListener(IGstoolImportMappingChangeListener listener) {
        GstoolTypeMapper.getChangeListenerSet().remove(listener);
    }

    private static Set<IGstoolImportMappingChangeListener> getChangeListenerSet() {
        if (changeListenerSet == null) {
            changeListenerSet = new HashSet<IGstoolImportMappingChangeListener>();
        }
        return changeListenerSet;
    }
}

