/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import sernet.gs.ui.rcp.gsimport.GsImportMappingComboBoxEditingSupport;
import sernet.gs.ui.rcp.gsimport.GsImportMappingContentProvider;
import sernet.gs.ui.rcp.gsimport.GsImportMappingLabelProvider;
import sernet.gs.ui.rcp.gsimport.GsImportMappingStringEditingSupport;
import sernet.gs.ui.rcp.gsimport.GstoolImportMappingElement;
import sernet.gs.ui.rcp.gsimport.GstoolTypeMapper;
import sernet.gs.ui.rcp.gsimport.IGstoolImportMappingChangeListener;
import sernet.gs.ui.rcp.gsimport.Messages;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.rcp.RightsEnabledView;

public class GstoolImportMappingView
extends RightsEnabledView
implements IGstoolImportMappingChangeListener {
    private static final Logger LOG = Logger.getLogger(GstoolImportMappingView.class);
    public static final String ID = "sernet.gs.ui.rcp.gsimport.gstoolimportmappingview";
    private TableViewer viewer;
    private TableComparator tableSorter = new TableComparator();
    private GsImportMappingLabelProvider labelProvider;
    private GsImportMappingContentProvider contentProvider;
    private WorkspaceJob initDataJob = new WorkspaceJob(""){

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            try {
                try {
                    monitor.beginTask("", -1);
                    GstoolImportMappingView.this.init();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while loading data.", (Throwable)e);
                    status = new Status(4, "sernet.gs.ui.rcp.main", "Error while loading data.", (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return status;
        }
    };
    private Action addMappingEntryAction;
    private Action deleteMappingEntryAction;
    private IModelLoadListener modelLoadListener;

    public GstoolImportMappingView() {
        GstoolTypeMapper.addChangeListener(this);
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void init() {
        GstoolImportMappingView.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GstoolImportMappingView.this.refresh();
            }
        });
    }

    protected void startInitDataJob() {
        if (CnAElementFactory.isIsoModelLoaded()) {
            JobScheduler.scheduleInitJob(this.initDataJob);
        } else if (this.modelLoadListener == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No model loaded, adding model load listener.");
            }
            this.createModelLoadListener();
        }
    }

    private void createModelLoadListener() {
        this.modelLoadListener = new IModelLoadListener(){

            @Override
            public void closed(BSIModel model) {
            }

            @Override
            public void loaded(BSIModel model) {
                JobScheduler.scheduleInitJob(GstoolImportMappingView.this.initDataJob);
                CnAElementFactory.getInstance().removeLoadListener(GstoolImportMappingView.this.modelLoadListener);
            }

            @Override
            public void loaded(ISO27KModel model) {
            }

            @Override
            public void loaded(BpModel model) {
            }

            @Override
            public void loaded(CatalogModel model) {
            }
        };
        CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.alternateCreatePartControl(parent);
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.addMappingEntryAction);
        manager.add((IAction)this.deleteMappingEntryAction);
    }

    private void alternateCreatePartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.labelProvider = new GsImportMappingLabelProvider();
        this.contentProvider = new GsImportMappingContentProvider(this);
        this.createTableViewer(parent);
        this.makeActions();
        this.fillLocalToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.startInitDataJob();
    }

    private void createTableViewer(Composite parent) {
        int gstoolTypeColumnWidth = 150;
        int veriniceTypeColumnWidth = 80;
        this.viewer = new TableViewer(parent, 66306);
        Table table = this.viewer.getTable();
        TableViewerColumn gstoolTypeColumn = new TableViewerColumn(this.viewer, 16384);
        gstoolTypeColumn.getColumn().setWidth(150);
        gstoolTypeColumn.getColumn().setText(Messages.GSImportMappingView_1);
        gstoolTypeColumn.getColumn().addSelectionListener((SelectionListener)new SortSelectionAdapter(this, gstoolTypeColumn.getColumn(), 0));
        gstoolTypeColumn.setEditingSupport((EditingSupport)new GsImportMappingStringEditingSupport(this.viewer, this));
        TableViewerColumn veriniceTypeColumn = new TableViewerColumn(this.viewer, 16384);
        veriniceTypeColumn.getColumn().setWidth(80);
        veriniceTypeColumn.getColumn().setText(Messages.GSImportMappingView_2);
        veriniceTypeColumn.getColumn().addSelectionListener((SelectionListener)new SortSelectionAdapter(this, veriniceTypeColumn.getColumn(), 1));
        veriniceTypeColumn.setEditingSupport((EditingSupport)new GsImportMappingComboBoxEditingSupport(this.viewer, this));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)this.tableSorter);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)new PlaceHolder(""));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof GstoolImportMappingElement) {
                        GstoolImportMappingView.this.deleteMappingEntryAction.setEnabled(true);
                    } else {
                        GstoolImportMappingView.this.deleteMappingEntryAction.setEnabled(false);
                    }
                }
            }
        });
    }

    void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StructuredSelection selection = (StructuredSelection)GstoolImportMappingView.this.viewer.getSelection();
                GstoolImportMappingView.this.viewer.setInput(GstoolTypeMapper.getGstoolSubtypesAsList());
                GstoolImportMappingView.this.viewer.setSelection((ISelection)selection, true);
            }
        });
    }

    private void makeActions() {
        this.addMappingEntryAction = new Action(){

            public void run() {
                GstoolImportMappingView.this.addMappingEntry();
            }
        };
        this.addMappingEntryAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("plus.png"));
        this.addMappingEntryAction.setEnabled(true);
        this.deleteMappingEntryAction = new Action(){

            public void run() {
                GstoolImportMappingView.this.deleteMappingEntry();
            }
        };
        this.deleteMappingEntryAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("minus.png"));
        this.deleteMappingEntryAction.setEnabled(false);
    }

    private void addMappingEntry() {
        GstoolImportMappingElement mappingElement = new GstoolImportMappingElement("< " + Messages.GSImportMappingView_newEntry + " >", "sonstit");
        GstoolTypeMapper.addGstoolSubtypeToPropertyFile(mappingElement);
        this.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)mappingElement), true);
    }

    private void deleteMappingEntry() {
        if (this.viewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            GstoolImportMappingElement deletedObject2 = null;
            for (GstoolImportMappingElement deletedObject2 : selection) {
                GstoolTypeMapper.removeGstoolSubtypeToPropertyFile(deletedObject2);
            }
            this.refresh();
        } else {
            LOG.warn((Object)"wrong selection type", (Throwable)new IllegalArgumentException("wrong selection type"));
        }
    }

    @Override
    public String getRightID() {
        return "gstoolimport";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    @Override
    public void mappingAdded(GstoolImportMappingElement mappingElement) {
        this.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)mappingElement), true);
    }

    @Override
    public void mappingChanged(GstoolImportMappingElement mappingElement) {
        this.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)mappingElement), true);
    }

    @Override
    public void mappingRemoved(GstoolImportMappingElement mappingElement) {
        this.refresh();
    }

    public void dispose() {
        GstoolTypeMapper.removeChangeListener(this);
        super.dispose();
    }

    private static class SortSelectionAdapter
    extends SelectionAdapter {
        private GstoolImportMappingView gsiView;
        private TableColumn column;
        private int index;

        public SortSelectionAdapter(GstoolImportMappingView gsiView, TableColumn column, int index) {
            this.gsiView = gsiView;
            this.column = column;
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            this.gsiView.tableSorter.setColumn(this.index);
            int dir = this.gsiView.viewer.getTable().getSortDirection();
            dir = this.gsiView.viewer.getTable().getSortColumn() == this.column ? (dir == 128 ? 1024 : 128) : 1024;
            this.gsiView.viewer.getTable().setSortDirection(dir);
            this.gsiView.viewer.getTable().setSortColumn(this.column);
            this.gsiView.refresh();
        }
    }

    private static class TableComparator
    extends ViewerComparator {
        private int currentColumnIndex = 0;
        private static final int DEFAULT_SORT_COLUMN = 0;
        private boolean isAscending = true;

        public void setColumn(int column) {
            if (column == this.currentColumnIndex) {
                this.isAscending = !this.isAscending;
            } else {
                this.currentColumnIndex = column;
                this.isAscending = true;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc = 0;
            if (e1 instanceof GstoolImportMappingElement && e2 instanceof GstoolImportMappingElement) {
                GstoolImportMappingElement g1 = (GstoolImportMappingElement)e1;
                GstoolImportMappingElement g2 = (GstoolImportMappingElement)e2;
                rc = this.currentColumnIndex == 0 ? g1.compareTo(g2) : (this.currentColumnIndex == 1 ? g1.getValue().compareToIgnoreCase(g2.getValue()) : 0);
                if (!this.isAscending) {
                    rc = -rc;
                }
            }
            return rc;
        }
    }
}

