/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.ui.rcp.gsimport.GstoolImportMappingElement;
import sernet.gs.ui.rcp.gsimport.GstoolImportMappingView;
import sernet.gs.ui.rcp.gsimport.GstoolTypeMapper;
import sernet.hui.common.connect.HitroUtil;

public class GsImportMappingComboBoxEditingSupport
extends EditingSupport {
    private static final Logger LOG = Logger.getLogger(GsImportMappingComboBoxEditingSupport.class);
    private static final Set<String> veriniceITGSObjectTypes = new HashSet<String>(8);
    private TableViewer viewer;
    private GstoolImportMappingView view;
    private String[] translatedVeriniceValues = null;
    private Map<String, String> veriniceValuesMap = null;

    static {
        veriniceITGSObjectTypes.addAll(Arrays.asList("itverbund", "anwendung", "client", "server", "raum", "gebaeude", "tkkomponente", "sonstit"));
    }

    public GsImportMappingComboBoxEditingSupport(TableViewer viewer, GstoolImportMappingView view) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.view = view;
    }

    protected boolean canEdit(Object arg0) {
        return true;
    }

    protected CellEditor getCellEditor(Object arg0) {
        ComboBoxCellEditor choiceEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), this.getTranslatedVeriniceValues(), 8);
        choiceEditor.setActivationStyle(1);
        return choiceEditor;
    }

    protected Object getValue(Object element) {
        if (element instanceof GstoolImportMappingElement) {
            GstoolImportMappingElement entry = (GstoolImportMappingElement)element;
            return this.getIndexOfVeriniceObjectType(entry.getKey());
        }
        return -1;
    }

    private String[] getTranslatedVeriniceValues() {
        if (this.translatedVeriniceValues == null) {
            this.translatedVeriniceValues = this.getMappedTranslatedVeriniceValues().keySet().toArray(new String[veriniceITGSObjectTypes.size()]);
        }
        return this.translatedVeriniceValues;
    }

    private Map<String, String> getMappedTranslatedVeriniceValues() {
        if (this.veriniceValuesMap == null) {
            this.veriniceValuesMap = new TreeMap<String, String>();
            for (String value : veriniceITGSObjectTypes) {
                String msg = HitroUtil.getInstance().getTypeFactory().getMessage(value);
                String tmp = StringUtils.isNotEmpty((String)msg) ? msg : value;
                this.veriniceValuesMap.put(tmp, value);
            }
        }
        return this.veriniceValuesMap;
    }

    private int getIndexOfVeriniceObjectType(String objectType) {
        String[] list = this.getTranslatedVeriniceValues();
        int i = 0;
        while (i < list.length) {
            if (objectType.equals(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setValue(Object element, Object value) {
        try {
            if (value instanceof Integer) {
                int val = (Integer)value;
                if (element instanceof GstoolImportMappingElement) {
                    GstoolImportMappingElement oldEntry = (GstoolImportMappingElement)element;
                    GstoolImportMappingElement newEntry = new GstoolImportMappingElement(oldEntry.getKey(), this.getMappedTranslatedVeriniceValues().get(this.getTranslatedVeriniceValues()[val]));
                    GstoolTypeMapper.addGstoolSubtypeToPropertyFile(newEntry);
                    this.view.refresh();
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)newEntry), true);
                } else {
                    LOG.error((Object)("Class of Element:\t" + element.getClass().getCanonicalName()));
                }
            } else {
                LOG.error((Object)("Class of value-Element:\t" + element.getClass().getCanonicalName()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error", (Throwable)e);
        }
    }
}

