/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sernet.gs.ui.rcp.gsimport.IProgress;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommandService;

public abstract class ChunkExecuter<T> {
    private int maxNumberPerCommand = 100;
    private List<T> elementList;
    private IProgress monitor;
    ICommandService commandService;

    public ChunkExecuter(List<T> elementList, IProgress monitor) {
        this.elementList = elementList;
        this.monitor = monitor;
    }

    public void execute() throws CommandException {
        int n = this.elementList.size();
        int current = 0;
        Iterator<T> elementIterator = this.elementList.iterator();
        while (elementIterator.hasNext()) {
            LinkedList<T> chunkList = new LinkedList<T>();
            int i = 0;
            while (i < this.maxNumberPerCommand) {
                if (!elementIterator.hasNext()) break;
                chunkList.add(elementIterator.next());
                ++i;
            }
            this.executeChunk(chunkList);
            this.monitor.worked(chunkList.size());
            this.monitor.subTask(String.valueOf(current += chunkList.size()) + " von " + n + " gespeichert...");
        }
    }

    protected abstract void executeChunk(List<T> var1) throws CommandException;

    protected ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandService();
        }
        return this.commandService;
    }

    private ICommandService createCommandService() {
        return ServiceFactory.lookupCommandService();
    }

    public int getMaxNumberPerCommand() {
        return this.maxNumberPerCommand;
    }

    public void setMaxNumberPerCommand(int maxNumberPerCommand) {
        this.maxNumberPerCommand = maxNumberPerCommand;
    }
}

