/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.gsimport;

import java.io.File;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import sernet.gs.reveng.importData.GSVampire;
import sernet.gs.ui.rcp.gsimport.GstoolImportCanceledException;
import sernet.gs.ui.rcp.gsimport.IProgress;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;

public abstract class AbstractGstoolImportTask {
    private static final Logger LOG = Logger.getLogger(AbstractGstoolImportTask.class);
    public static final int TYPE_SQLSERVER = 1;
    public static final int TYPE_MDB = 2;
    private GSVampire gstoolDao;
    private ClassLoader originalClassLoader;

    public void execute(int importType, IProgress monitor) {
        try {
            this.initThreadContextClassLoader();
            this.executeTask(importType, monitor);
            this.resetThreadContextClassLoader();
            CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        }
        catch (GstoolImportCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error while importing data from GSTOOL", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while importing data from GSTOOL", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract void executeTask(int var1, IProgress var2) throws Exception;

    protected void initThreadContextClassLoader() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = Hibernate.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    protected void resetThreadContextClassLoader() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    protected GSVampire getGstoolDao() {
        if (this.gstoolDao == null) {
            this.initGsVampire();
        }
        return this.gstoolDao;
    }

    protected void initGsVampire() {
        File conf = new File(CnAWorkspace.getInstance().getConfDir() + File.separator + "hibernate-vampire.cfg.xml");
        this.gstoolDao = new GSVampire(conf.getAbsolutePath());
    }
}

