/*
 * Decompiled with CFR 0.152.
 */
package com.heatonresearch.datamover;

import com.heatonresearch.datamover.db.Database;
import com.heatonresearch.datamover.db.DatabaseException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class DataMover {
    private static final Logger LOG = Logger.getLogger(DataMover.class);
    private Database source;
    private Database target;
    private List<String> tables = new ArrayList<String>();

    public Database getSource() {
        return this.source;
    }

    public void setSource(Database source) {
        this.source = source;
    }

    public Database getTarget() {
        return this.target;
    }

    public void setTarget(Database target) {
        this.target = target;
    }

    public void createTable(String table) throws DatabaseException {
        if (!this.target.tableExists(table)) {
            String sql = this.source.generateCreate(table);
            this.target.execute(sql);
        }
    }

    private void createTables() throws DatabaseException {
        Logger.getLogger(this.getClass()).debug((Object)"Create tables.");
        Collection<String> list = this.source.listTables();
        for (String table : list) {
            try {
                Logger.getLogger(this.getClass()).debug((Object)("Create table: " + table));
                this.createTable(table);
                this.tables.add(table);
            }
            catch (DatabaseException e) {
                LOG.error((Object)"Error while creating table", (Throwable)e);
            }
        }
    }

    private void copyTable(String table) throws DatabaseException {
        StringBuffer selectSQL = new StringBuffer();
        StringBuffer insertSQL = new StringBuffer();
        StringBuffer values = new StringBuffer();
        Collection<String> columns = this.source.listColumns(table);
        Logger.getLogger(this.getClass()).debug((Object)("Begin copy: " + table));
        selectSQL.append("SELECT ");
        insertSQL.append("INSERT INTO ");
        insertSQL.append(table);
        insertSQL.append("(");
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                selectSQL.append(",");
                insertSQL.append(",");
                values.append(",");
            } else {
                first = false;
            }
            selectSQL.append(column);
            insertSQL.append(column);
            values.append("?");
        }
        selectSQL.append(" FROM ");
        selectSQL.append(table);
        insertSQL.append(") VALUES (");
        insertSQL.append(values);
        insertSQL.append(")");
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            try {
                statement = this.target.prepareStatement(insertSQL.toString());
                rs = this.source.executeQuery(selectSQL.toString());
                int rows = 0;
                while (rs.next()) {
                    ++rows;
                    int i = 1;
                    while (i <= columns.size()) {
                        try {
                            statement.setString(i, rs.getString(i));
                        }
                        catch (SQLException e) {
                            Logger.getLogger(this.getClass()).debug((Object)("Error setting column: " + ((List)columns).get(i)));
                            try {
                                statement.setString(i, "");
                            }
                            catch (Exception e2) {
                                statement.setString(i, "0");
                            }
                        }
                        ++i;
                    }
                    statement.execute();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Copied " + rows + " rows."));
                    LOG.debug((Object)"");
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
            try {
                if (rs != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    private void copyTableData() throws DatabaseException {
        for (String table : this.tables) {
            this.copyTable(table);
        }
    }

    public void exportDatabse() throws DatabaseException {
        this.createTables();
        this.copyTableData();
    }
}

